/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionVariableDescriptor
implements VariableDescriptor {
    public static final Hash.Strategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new PsiExpressionStrategy();
    @NotNull
    private final PsiExpression myExpression;

    public ExpressionVariableDescriptor(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ExpressionVariableDescriptor.$$$reportNull$$$0(0);
        }
        this.myExpression = expression2;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression = this.myExpression;
        if (psiExpression == null) {
            ExpressionVariableDescriptor.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    @Override
    @Nullable
    public PsiType getType(@Nullable DfaVariableValue qualifier) {
        return this.myExpression.getType();
    }

    public int hashCode() {
        return EXPRESSION_HASHING_STRATEGY.hashCode((Object)this.myExpression);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExpressionVariableDescriptor && EXPRESSION_HASHING_STRATEGY.equals((Object)this.myExpression, (Object)((ExpressionVariableDescriptor)obj).myExpression);
    }

    public String toString() {
        return this.myExpression.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/ExpressionVariableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/ExpressionVariableDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PsiExpressionStrategy
    implements Hash.Strategy<PsiExpression> {
        private static final Logger LOG = Logger.getInstance(PsiExpressionStrategy.class);

        private PsiExpressionStrategy() {
        }

        public int hashCode(PsiExpression object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.hashCode(o1) != this.hashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.hashCode(o1) + "!=" + this.hashCode(o2));
                }
                return true;
            }
            return false;
        }
    }
}

