/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.util.Consumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HighlightBreakOutsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public HighlightBreakOutsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            HighlightBreakOutsHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            HighlightBreakOutsHandler.$$$reportNull$$$0(1);
        }
        if (selectionConsumer == null) {
            HighlightBreakOutsHandler.$$$reportNull$$$0(2);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiSwitchExpression enclosingExpression;
        PsiElement parent;
        if (targets == null) {
            HighlightBreakOutsHandler.$$$reportNull$$$0(3);
        }
        if ((parent = this.myTarget.getParent()) instanceof PsiContinueStatement) {
            PsiStatement statement = ((PsiContinueStatement)parent).findContinuedStatement();
            if (statement instanceof PsiLoopStatement) {
                this.processLoop((PsiStatement)parent, (PsiLoopStatement)statement);
            }
        } else if (parent instanceof PsiBreakStatement) {
            PsiStatement exitedStatement = ((PsiBreakStatement)parent).findExitedStatement();
            if (exitedStatement instanceof PsiLoopStatement) {
                this.processLoop((PsiStatement)parent, (PsiLoopStatement)exitedStatement);
            } else if (exitedStatement instanceof PsiSwitchStatement) {
                this.addOccurrence(exitedStatement.getFirstChild());
                this.collectSiblings((PsiStatement)parent, (PsiElement)exitedStatement, (PsiElement)exitedStatement);
            }
        } else if (parent instanceof PsiYieldStatement && (enclosingExpression = ((PsiYieldStatement)parent).findEnclosingExpression()) != null) {
            this.addOccurrence(enclosingExpression.getFirstChild());
            this.collectSiblings((PsiStatement)parent, (PsiElement)enclosingExpression, (PsiElement)enclosingExpression);
        }
        this.addOccurrence(this.myTarget);
    }

    private void processLoop(PsiStatement parent, PsiLoopStatement statement) {
        this.highlightLoopDeclaration(statement);
        PsiStatement body2 = statement.getBody();
        if (body2 instanceof PsiBlockStatement) {
            this.collectSiblings(parent, (PsiElement)statement, (PsiElement)((PsiBlockStatement)body2).getCodeBlock());
        }
    }

    private void collectSiblings(PsiStatement currentStatement, PsiElement container, @NotNull PsiElement block) {
        if (block == null) {
            HighlightBreakOutsHandler.$$$reportNull$$$0(4);
        }
        try {
            ControlFlow controlFlow = ControlFlowFactory.getInstance(block.getProject()).getControlFlow(block, new LocalsControlFlowPolicy(block), false, false);
            Collection<PsiStatement> statements = ControlFlowUtil.findExitPointsAndStatements(controlFlow, 0, controlFlow.getSize(), new IntArrayList(), ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            for (PsiStatement psiStatement : statements) {
                if (currentStatement == psiStatement || !(psiStatement instanceof PsiContinueStatement && ((PsiContinueStatement)psiStatement).findContinuedStatement() == container || psiStatement instanceof PsiBreakStatement && ((PsiBreakStatement)psiStatement).findExitedStatement() == container) && (!(psiStatement instanceof PsiYieldStatement) || ((PsiYieldStatement)psiStatement).findEnclosingExpression() != container)) continue;
                this.addOccurrence(psiStatement.getFirstChild());
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    private void highlightLoopDeclaration(PsiLoopStatement statement) {
        if (statement instanceof PsiDoWhileStatement) {
            PsiKeyword whileKeyword = ((PsiDoWhileStatement)statement).getWhileKeyword();
            if (whileKeyword != null) {
                this.addOccurrence((PsiElement)whileKeyword);
            }
        } else {
            this.addOccurrence(statement.getFirstChild());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightBreakOutsHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightBreakOutsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSiblings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

