/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class HighlightExceptionsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClassType[] myClassTypes;
    private final PsiElement myPlace;
    private final PsiElement myOtherPlace;
    private final Condition<? super PsiType> myTypeFilter;

    HighlightExceptionsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, PsiClassType @NotNull [] classTypes, @NotNull PsiElement place, PsiElement otherPlace, @NotNull Condition<? super PsiType> typeFilter) {
        if (editor == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(2);
        }
        if (place == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(3);
        }
        if (typeFilter == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(4);
        }
        if (classTypes == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(5);
        }
        super(editor, file);
        this.myTarget = target;
        this.myClassTypes = classTypes;
        this.myPlace = place;
        this.myOtherPlace = otherPlace;
        this.myTypeFilter = typeFilter;
    }

    @NotNull
    public List<PsiClass> getTargets() {
        List<PsiClass> list = ChooseClassAndDoHighlightRunnable.resolveClasses(this.myClassTypes);
        if (list == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(6);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiClass> targets, final @NotNull Consumer<? super List<? extends PsiClass>> selectionConsumer) {
        if (targets == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(7);
        }
        if (selectionConsumer == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(8);
        }
        new ChooseClassAndDoHighlightRunnable(this.myClassTypes, this.myEditor, JavaBundle.message((String)"highlight.exceptions.thrown.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes2) {
                if (classes2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                selectionConsumer.consume(Arrays.asList(classes2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/codeInsight/highlighting/HighlightExceptionsHandler$1", "selected"));
            }
        }.run();
    }

    public void computeUsages(@NotNull List<? extends PsiClass> targets) {
        if (targets == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(9);
        }
        this.addUsage(this.myTarget);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myFile.getProject());
        for (PsiClass psiClass : targets) {
            this.addExceptionThrowPlaces(factory.createType(psiClass), this.myPlace);
            if (this.myOtherPlace == null) continue;
            this.addExceptionThrowPlaces(factory.createType(psiClass), this.myOtherPlace);
        }
        this.buildStatusText(JavaBundle.message((String)"java.terms.exception", (Object[])new Object[0]), this.myReadUsages.size() - 1);
    }

    private void addExceptionThrowPlaces(final @NotNull PsiClassType type2, final @NotNull PsiElement place) {
        if (type2 == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(10);
        }
        if (place == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(11);
        }
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                super.visitThrowStatement(statement);
                List<PsiClassType> actualTypes = ExceptionUtil.getUnhandledExceptions(statement, place);
                for (PsiClassType actualType : actualTypes) {
                    if (actualType == null || !type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    PsiExpression psiExpression = statement.getException();
                    if (psiExpression instanceof PsiReferenceExpression) {
                        HighlightExceptionsHandler.this.addUsage((PsiElement)psiExpression);
                        continue;
                    }
                    if (psiExpression instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement ref = ((PsiNewExpression)psiExpression).getClassReference();
                        if (ref == null) continue;
                        HighlightExceptionsHandler.this.addUsage((PsiElement)ref);
                        continue;
                    }
                    PsiExpression exception = statement.getException();
                    if (exception == null) continue;
                    HighlightExceptionsHandler.this.addUsage((PsiElement)exception);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiReference reference = expression2.getMethodExpression().getReference();
                if (reference != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addUsage((PsiElement)expression2.getMethodExpression());
                        break;
                    }
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                super.visitNewExpression(expression2);
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                if (classReference2 != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression2, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addUsage((PsiElement)classReference2);
                        break;
                    }
                }
            }

            public void visitResourceExpression(PsiResourceExpression expression2) {
                super.visitResourceExpression(expression2);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)expression2, place);
                for (PsiClassType actualType : exceptionTypes) {
                    if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    HighlightExceptionsHandler.this.addUsage((PsiElement)expression2);
                    break;
                }
            }

            public void visitResourceVariable(PsiResourceVariable variable) {
                super.visitResourceVariable(variable);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)variable, place);
                for (PsiClassType actualType : exceptionTypes) {
                    PsiIdentifier name2;
                    if (!type2.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType) || (name2 = variable.getNameIdentifier()) == null) continue;
                    HighlightExceptionsHandler.this.addUsage((PsiElement)name2);
                    break;
                }
            }
        });
    }

    private void addUsage(@NotNull PsiElement element) {
        if (element == null) {
            HighlightExceptionsHandler.$$$reportNull$$$0(12);
        }
        this.addOccurrence(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightExceptionsHandler";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightExceptionsHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionThrowPlaces";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

