/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public HighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            HighlightExitPointsHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            HighlightExitPointsHandler.$$$reportNull$$$0(1);
        }
        if (selectionConsumer == null) {
            HighlightExitPointsHandler.$$$reportNull$$$0(2);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent;
        if (targets == null) {
            HighlightExitPointsHandler.$$$reportNull$$$0(3);
        }
        if (!((parent = this.myTarget.getParent()) instanceof PsiReturnStatement) && !(parent instanceof PsiThrowStatement)) {
            return;
        }
        PsiCodeBlock body2 = null;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
        if (psiElement instanceof PsiLambdaExpression) {
            PsiElement lambdaBody = ((PsiLambdaExpression)psiElement).getBody();
            if (lambdaBody instanceof PsiCodeBlock) {
                body2 = (PsiCodeBlock)lambdaBody;
            }
        } else if (psiElement instanceof PsiMethod) {
            body2 = ((PsiMethod)psiElement).getBody();
        }
        if (body2 == null) {
            return;
        }
        try {
            this.highlightExitPoints((PsiStatement)parent, body2);
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    @Nullable
    private static PsiElement getExitTarget(PsiStatement exitStatement) {
        if (exitStatement instanceof PsiReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)exitStatement, PsiMethod.class);
        }
        if (exitStatement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)exitStatement).findExitedStatement();
        }
        if (exitStatement instanceof PsiContinueStatement) {
            return ((PsiContinueStatement)exitStatement).findContinuedStatement();
        }
        if (exitStatement instanceof PsiThrowStatement) {
            PsiStatement target;
            PsiExpression expr2 = ((PsiThrowStatement)exitStatement).getException();
            if (expr2 == null) {
                return null;
            }
            PsiType exceptionType = expr2.getType();
            if (!(exceptionType instanceof PsiClassType)) {
                return null;
            }
            for (target = exitStatement; !(target instanceof PsiMethod || target == null || target instanceof PsiClass || target instanceof PsiFile); target = target.getParent()) {
                PsiParameter[] params;
                if (!(target instanceof PsiTryStatement)) continue;
                PsiTryStatement tryStatement = (PsiTryStatement)target;
                for (PsiParameter param : params = tryStatement.getCatchBlockParameters()) {
                    if (param.getType().isAssignableFrom(exceptionType)) break;
                }
            }
            if (target instanceof PsiMethod || target instanceof PsiTryStatement) {
                return target;
            }
            return null;
        }
        return null;
    }

    private void highlightExitPoints(PsiStatement parent, PsiCodeBlock body2) throws AnalysisCanceledException {
        Project project = this.myTarget.getProject();
        ControlFlow flow = ControlFlowFactory.getInstance(project).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        Collection<PsiStatement> exitStatements = ControlFlowUtil.findExitPointsAndStatements(flow, 0, flow.getSize(), new IntArrayList(), PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class, PsiThrowStatement.class);
        if (!exitStatements.contains(parent)) {
            return;
        }
        PsiElement originalTarget = HighlightExitPointsHandler.getExitTarget(parent);
        Iterator<PsiStatement> it = exitStatements.iterator();
        while (it.hasNext()) {
            PsiStatement psiStatement = it.next();
            if (HighlightExitPointsHandler.getExitTarget(psiStatement) == originalTarget) continue;
            it.remove();
        }
        for (PsiElement psiElement : exitStatements) {
            this.addOccurrence(psiElement);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{exitStatements.size(), HighlightUsagesHandler.getShortcutText()});
    }

    @NotNull
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightExitPointsHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightExitPointsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

