/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaTypeProvider
extends ExpressionTypeProvider<PsiExpression> {
    @NotNull
    public String getInformationHint(@NotNull PsiExpression element) {
        if (element == null) {
            JavaTypeProvider.$$$reportNull$$$0(0);
        }
        String string = StringUtil.escapeXmlEntities((String)JavaTypeProvider.getTypePresentation(element));
        if (string == null) {
            JavaTypeProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getTypePresentation(@NotNull PsiExpression element) {
        PsiType type2;
        if (element == null) {
            JavaTypeProvider.$$$reportNull$$$0(2);
        }
        if ((type2 = element.getType()) instanceof PsiLambdaExpressionType) {
            type2 = ((PsiLambdaExpressionType)type2).getExpression().getFunctionalInterfaceType();
        } else if (type2 instanceof PsiMethodReferenceType) {
            type2 = ((PsiMethodReferenceType)type2).getExpression().getFunctionalInterfaceType();
        }
        String string = type2 == null ? "<unknown>" : type2.getPresentableText();
        if (string == null) {
            JavaTypeProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getErrorHint() {
        String string = JavaBundle.message((String)"error.hint.no.expression.found", (Object[])new Object[0]);
        if (string == null) {
            JavaTypeProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<PsiExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            JavaTypeProvider.$$$reportNull$$$0(5);
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(PsiExpression.class).filter(JavaTypeProvider::isLargestNonTrivialExpression).toList();
        if (list == null) {
            JavaTypeProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isLargestNonTrivialExpression(@NotNull PsiExpression e) {
        PsiElement p;
        if (e == null) {
            JavaTypeProvider.$$$reportNull$$$0(7);
        }
        if ((p = e.getParent()) instanceof PsiUnaryExpression) {
            return false;
        }
        return !(p instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)p).getMethodExpression() != e;
    }

    public boolean hasAdvancedInformation() {
        return true;
    }

    @NotNull
    public String getAdvancedInformationHint(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaTypeProvider.$$$reportNull$$$0(8);
        }
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return "<unknown>";
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        ArrayList<Pair> infoLines = new ArrayList<Pair>();
        String basicType = JavaTypeProvider.getTypePresentation(expression2);
        if (result != null) {
            DfType dfType = result.getDfType(expression2);
            PsiType type2 = expression2.getType();
            Set<Object> values = result.getExpressionValues(expression2);
            if (!values.isEmpty()) {
                if (values.size() == 1) {
                    infoLines.add(Pair.create((Object)"Value", (Object)DfConstantType.renderValue(values.iterator().next())));
                } else {
                    infoLines.add(Pair.create((Object)"Value (one of)", (Object)((StreamEx)StreamEx.of(values).map(DfConstantType::renderValue).sorted()).joining((CharSequence)", ")));
                }
            } else {
                if (dfType instanceof DfAntiConstantType) {
                    ArrayList nonValues = new ArrayList(((DfAntiConstantType)dfType).getNotValues());
                    nonValues.remove(null);
                    if (!nonValues.isEmpty()) {
                        infoLines.add(Pair.create((Object)"Not equal to", (Object)((StreamEx)StreamEx.of(nonValues).map(DfConstantType::renderValue).sorted()).joining((CharSequence)", ")));
                    }
                }
                if (dfType instanceof DfIntegralType) {
                    String rangeText = ((DfIntegralType)dfType).getRange().getPresentationText(type2);
                    if (!rangeText.equals("any value")) {
                        infoLines.add(Pair.create((Object)"Range", (Object)rangeText));
                    }
                } else if (dfType instanceof DfReferenceType) {
                    DfReferenceType refType = (DfReferenceType)dfType;
                    infoLines.add(Pair.create((Object)"Nullability", (Object)refType.getNullability().getPresentationName()));
                    infoLines.add(Pair.create((Object)"Constraints", (Object)refType.getConstraint().getPresentationText(type2)));
                    if (refType.getMutability() != Mutability.UNKNOWN) {
                        infoLines.add(Pair.create((Object)"Mutability", (Object)refType.getMutability().toString()));
                    }
                    infoLines.add(Pair.create((Object)"Locality", (Object)(refType.isLocal() ? "local object" : "")));
                    SpecialField field = refType.getSpecialField();
                    if (field != null) {
                        infoLines.add(Pair.create((Object)StringUtil.wordsToBeginFromUpperCase((String)field.toString()), (Object)field.getPresentationText(refType.getSpecialFieldType(), type2)));
                    }
                }
            }
        }
        infoLines.removeIf(pair2 -> ((String)pair2.getSecond()).isEmpty());
        if (!infoLines.isEmpty()) {
            infoLines.add(0, Pair.create((Object)"Type", (Object)basicType));
            String string = StreamEx.of(infoLines).map(pair2 -> JavaTypeProvider.makeHtmlRow((String)pair2.getFirst(), (String)pair2.getSecond())).joining((CharSequence)"", (CharSequence)"<table>", (CharSequence)"</table>");
            if (string == null) {
                JavaTypeProvider.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = basicType;
        if (string == null) {
            JavaTypeProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static String makeHtmlRow(@NotNull String titleText, String contentText) {
        if (titleText == null) {
            JavaTypeProvider.$$$reportNull$$$0(11);
        }
        String titleCell = "<td align='left' valign='top' style='color:" + ColorUtil.toHtmlColor((Color)DocumentationComponent.SECTION_COLOR) + "'>" + StringUtil.escapeXmlEntities((String)titleText) + ":</td>";
        String contentCell = "<td>" + StringUtil.escapeXmlEntities((String)contentText) + "</td>";
        return "<tr>" + titleCell + contentCell + "</tr>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/JavaTypeProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/JavaTypeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvancedInformationHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHint";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLargestNonTrivialExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdvancedInformationHint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeHtmlRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

