/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.MergeFilterChainAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SplitFilterAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)SplitFilterAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2;
        if (project == null) {
            SplitFilterAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SplitFilterAction.$$$reportNull$$$0(1);
        }
        if ((expression2 = SplitConditionUtil.findCondition(element, true, false)) == null || expression2.getOperands().length < 2) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        if (((PsiLambdaExpression)parent).getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        return MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent) && !SplitFilterAction.hasPatternVariablesUsedAfterSplit(expression2, element);
    }

    private static boolean hasPatternVariablesUsedAfterSplit(@NotNull PsiPolyadicExpression expression2, @NotNull PsiElement token) {
        if (expression2 == null) {
            SplitFilterAction.$$$reportNull$$$0(2);
        }
        if (token == null) {
            SplitFilterAction.$$$reportNull$$$0(3);
        }
        ArrayList<PsiExpression> afterOperands = new ArrayList<PsiExpression>();
        for (PsiElement after = token; after != null; after = after.getNextSibling()) {
            if (!(after instanceof PsiExpression)) continue;
            afterOperands.add((PsiExpression)after);
        }
        for (PsiElement child = expression2.getFirstChild(); child != token; child = child.getNextSibling()) {
            if (!(child instanceof PsiExpression)) continue;
            for (PsiPatternVariable variable : JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)child)) {
                for (PsiExpression operand2 : afterOperands) {
                    if (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)operand2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = JavaBundle.message((String)"intention.split.filter.text", (Object[])new Object[0]);
        if (string == null) {
            SplitFilterAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.split.filter.family", (Object[])new Object[0]);
        if (string == null) {
            SplitFilterAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token;
        PsiPolyadicExpression expression2;
        PsiLambdaExpression originalLambdaExpression;
        if (project == null) {
            SplitFilterAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SplitFilterAction.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((originalLambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)(expression2 = SplitConditionUtil.findCondition((PsiElement)(token = (PsiJavaToken)element), true, false)), PsiLambdaExpression.class)) != null);
        String lambdaParameterName = originalLambdaExpression.getParameterList().getParameters()[0].getName();
        PsiElement originalLambdaExpressionBody = originalLambdaExpression.getBody();
        LOG.assertTrue(originalLambdaExpressionBody != null);
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
        LOG.assertTrue(methodCallExpression != null, (Object)expression2);
        PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(qualifierExpression2 != null);
        PsiMethodCallExpression newFilterCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("a.filter(" + lambdaParameterName + " -> x)", (PsiElement)methodCallExpression);
        PsiLambdaExpression newFilterLambda = (PsiLambdaExpression)newFilterCall.getArgumentList().getExpressions()[0];
        PsiExpression filterCallQualifier = newFilterCall.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(filterCallQualifier != null);
        PsiElement newFilterLambdaBody = newFilterLambda.getBody();
        LOG.assertTrue(newFilterLambdaBody != null);
        List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)expression2, PsiComment.class);
        int separatorOffset = token.getTextOffset();
        for (PsiComment comment : comments) {
            if (comment.getTextOffset() < separatorOffset) {
                newFilterLambda.getParent().add((PsiElement)comment);
                continue;
            }
            originalLambdaExpression.addBefore((PsiElement)comment, originalLambdaExpressionBody);
        }
        PsiExpression rOperands = SplitConditionUtil.getROperands(expression2, token);
        PsiExpression lOperands = SplitConditionUtil.getLOperands(expression2, token);
        originalLambdaExpressionBody.replace((PsiElement)rOperands);
        newFilterLambdaBody.replace((PsiElement)lOperands);
        filterCallQualifier.replace((PsiElement)qualifierExpression2);
        qualifierExpression2.replace((PsiElement)newFilterCall);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitFilterAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitFilterAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasPatternVariablesUsedAfterSplit";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

