/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnrollLoopAction
extends PsiElementBaseIntentionAction {
    private static final int MAX_BODY_SIZE_ESTIMATE = 5000;

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiLoopStatement loop;
        PsiVariable iterationParameter;
        if (project == null) {
            UnrollLoopAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            UnrollLoopAction.$$$reportNull$$$0(1);
        }
        if ((iterationParameter = UnrollLoopAction.getVariable(loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class))) == null || !(loop.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        List<PsiExpression> expressions2 = UnrollLoopAction.extractExpressions(loop);
        PsiStatement body2 = loop.getBody();
        if (body2 == null) {
            return false;
        }
        if (expressions2.isEmpty() || expressions2.size() > 5000 || (expressions2.size() - 1) * body2.getTextLength() > 5000) {
            return false;
        }
        PsiStatement[] statements = ControlFlowUtils.unwrapBlock(body2);
        if (statements.length == 0) {
            return false;
        }
        if (Arrays.stream(statements).anyMatch(PsiDeclarationStatement.class::isInstance)) {
            return false;
        }
        if (VariableAccessUtils.variableIsAssigned(iterationParameter, (PsiElement)body2)) {
            return false;
        }
        for (PsiStatement statement : statements) {
            boolean acceptable;
            if (UnrollLoopAction.isLoopBreak(statement) || (acceptable = PsiTreeUtil.processElements((PsiElement)statement, e -> {
                if (e instanceof PsiBreakStatement && ((PsiBreakStatement)e).findExitedStatement() == loop) {
                    return false;
                }
                return !(e instanceof PsiContinueStatement) || ((PsiContinueStatement)e).findContinuedStatement() != loop;
            }))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getVariable(PsiLoopStatement loop) {
        CountingLoop countingLoop;
        if (loop instanceof PsiForeachStatement) {
            return ((PsiForeachStatement)loop).getIterationParameter();
        }
        if (loop instanceof PsiForStatement && (countingLoop = CountingLoop.from((PsiForStatement)loop)) != null) {
            return countingLoop.getCounter();
        }
        return null;
    }

    @NotNull
    private static List<PsiExpression> extractExpressions(PsiLoopStatement loop) {
        CountingLoop countingLoop;
        if (loop instanceof PsiForeachStatement) {
            PsiExpression expression2 = ExpressionUtils.resolveExpression(((PsiForeachStatement)loop).getIteratedValue());
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiArrayInitializerExpression) {
                List<PsiExpression> list = Arrays.asList(((PsiArrayInitializerExpression)expression2).getInitializers());
                if (list == null) {
                    UnrollLoopAction.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (expression2 instanceof PsiNewExpression) {
                PsiArrayInitializerExpression initializer = ((PsiNewExpression)expression2).getArrayInitializer();
                List<PsiExpression> list = initializer == null ? Collections.emptyList() : Arrays.asList(initializer.getInitializers());
                if (list == null) {
                    UnrollLoopAction.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiClass enumClass;
                PsiType type2;
                PsiExpression[] args;
                PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
                if (Holder.SINGLETON_CONSTRUCTOR.test(call)) {
                    List<PsiExpression> list = Arrays.asList(call.getArgumentList().getExpressions());
                    if (list == null) {
                        UnrollLoopAction.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                if (Holder.LIST_CONSTRUCTOR.test(call) && ((args = call.getArgumentList().getExpressions()).length > 1 || MethodCallUtils.isVarArgCall((PsiCall)call))) {
                    List<PsiExpression> list = Arrays.asList(args);
                    if (list == null) {
                        UnrollLoopAction.$$$reportNull$$$0(5);
                    }
                    return list;
                }
                if (CallMatcher.enumValues().test(call) && (type2 = call.getType()) instanceof PsiArrayType && (enumClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiArrayType)type2).getComponentType())) != null && enumClass.isEnum()) {
                    List constants = StreamEx.of((Object[])enumClass.getFields()).select(PsiEnumConstant.class).toList();
                    List<PsiExpression> list = UnrollLoopAction.generatedList((PsiElement)loop, constants.size(), index -> enumClass.getQualifiedName() + "." + ((PsiEnumConstant)constants.get(index)).getName());
                    if (list == null) {
                        UnrollLoopAction.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            }
            if (ExpressionUtils.isSafelyRecomputableExpression(expression2)) {
                Integer listSize;
                DfType dfType;
                Integer arraySize;
                PsiType type3 = expression2.getType();
                if (type3 instanceof PsiArrayType && (arraySize = DfConstantType.getConstantOfType(SpecialField.ARRAY_LENGTH.getFromQualifier(dfType = CommonDataflow.getDfType(expression2)), Integer.class)) != null) {
                    PsiExpression array = expression2;
                    List<PsiExpression> list = UnrollLoopAction.generatedList((PsiElement)loop, arraySize, index -> ParenthesesUtils.getText(array, 2) + "[" + index + "]");
                    if (list == null) {
                        UnrollLoopAction.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                if (InheritanceUtil.isInheritor((PsiType)type3, (String)"java.util.List") && (listSize = DfConstantType.getConstantOfType(SpecialField.COLLECTION_SIZE.getFromQualifier(dfType = CommonDataflow.getDfType(expression2)), Integer.class)) != null) {
                    PsiExpression list = expression2;
                    List<PsiExpression> list2 = UnrollLoopAction.generatedList((PsiElement)loop, listSize, index -> ParenthesesUtils.getText(list, 1) + ".get(" + index + ")");
                    if (list2 == null) {
                        UnrollLoopAction.$$$reportNull$$$0(8);
                    }
                    return list2;
                }
            }
        }
        if (loop instanceof PsiForStatement && (countingLoop = CountingLoop.from((PsiForStatement)loop)) != null) {
            String suffix;
            boolean descending = countingLoop.isDescending();
            long multiplier = descending ? -1L : 1L;
            Object from = CommonDataflow.computeValue(countingLoop.getInitializer());
            if (!(from instanceof Integer) && !(from instanceof Long)) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    UnrollLoopAction.$$$reportNull$$$0(9);
                }
                return list;
            }
            long fromValue = ((Number)from).longValue();
            Object to = CommonDataflow.computeValue(countingLoop.getBound());
            if (!(to instanceof Integer) && !(to instanceof Long)) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    UnrollLoopAction.$$$reportNull$$$0(10);
                }
                return list;
            }
            long toValue = ((Number)to).longValue();
            long diff = multiplier * (toValue - fromValue);
            String string = suffix = PsiType.LONG.equals((Object)countingLoop.getCounter().getType()) ? "L" : "";
            if (countingLoop.isIncluding()) {
                ++diff;
            }
            if (diff < 0L || diff > 5000L) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    UnrollLoopAction.$$$reportNull$$$0(11);
                }
                return list;
            }
            int size = (int)diff;
            List<PsiExpression> list = UnrollLoopAction.generatedList((PsiElement)loop, size, index -> fromValue + multiplier * (long)index + suffix);
            if (list == null) {
                UnrollLoopAction.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PsiExpression> list = Collections.emptyList();
        if (list == null) {
            UnrollLoopAction.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static List<PsiExpression> generatedList(final PsiElement context, final int size, final IntFunction<String> generator) {
        final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        return new AbstractList<PsiExpression>(){

            @Override
            public PsiExpression get(int index) {
                return factory.createExpressionFromText((String)generator.apply(index), context);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            UnrollLoopAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.unroll.loop.family", (Object[])new Object[0]);
        if (string == null) {
            UnrollLoopAction.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiExpression iteratedValue2;
        PsiLocalVariable variable;
        PsiLoopStatement loop;
        if (project == null) {
            UnrollLoopAction.$$$reportNull$$$0(16);
        }
        if (element == null) {
            UnrollLoopAction.$$$reportNull$$$0(17);
        }
        if ((loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class)) == null) {
            return;
        }
        if (!(loop.getParent() instanceof PsiCodeBlock)) {
            return;
        }
        List<PsiExpression> expressions2 = UnrollLoopAction.extractExpressions(loop);
        if (expressions2.isEmpty()) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CommentTracker ct = new CommentTracker();
        PsiLoopStatement anchor = loop;
        for (PsiExpression expression2 : expressions2) {
            PsiElement[] children;
            ct.markUnchanged(loop.getBody());
            PsiLoopStatement copy = (PsiLoopStatement)factory.createStatementFromText(loop.getText(), element);
            PsiVariable variable2 = Objects.requireNonNull(UnrollLoopAction.getVariable(copy));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variable2, (SearchScope)new LocalSearchScope((PsiElement)copy))) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                ct.markUnchanged(expression2);
                InlineUtil.inlineVariable(variable2, expression2, (PsiJavaCodeReferenceElement)referenceElement);
            }
            PsiStatement body2 = copy.getBody();
            assert (body2 != null);
            if (body2 instanceof PsiBlockStatement) {
                children = ((PsiBlockStatement)body2).getCodeBlock().getChildren();
                children = Arrays.copyOfRange(children, 1, children.length - 1);
            } else {
                children = new PsiElement[]{body2};
            }
            for (PsiElement child : children) {
                PsiElement added = anchor.getParent().addBefore(child, (PsiElement)anchor);
                if (!(added instanceof PsiIfStatement) || !UnrollLoopAction.isLoopBreak((PsiStatement)added)) continue;
                PsiIfStatement ifStatement = (PsiIfStatement)added;
                PsiExpression condition2 = Objects.requireNonNull(ifStatement.getCondition());
                PsiStatement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch());
                String negated = BoolUtils.getNegatedExpressionText(condition2, ct);
                condition2.replace((PsiElement)factory.createExpressionFromText(negated, (PsiElement)condition2));
                PsiBlockStatement block = (PsiBlockStatement)thenBranch.replace((PsiElement)factory.createStatementFromText("{}", added));
                anchor = block.getCodeBlock().getLastChild();
            }
        }
        if (loop instanceof PsiForeachStatement && (variable = ExpressionUtils.resolveLocalVariable(iteratedValue2 = ((PsiForeachStatement)loop).getIteratedValue())) != null && PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)((PsiElement)expressions2.get(0)), (boolean)true)) {
            ct.delete((PsiElement)variable);
        }
        ct.deleteAndRestoreComments((PsiElement)loop);
    }

    private static boolean isLoopBreak(PsiStatement statement) {
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement;
        if (ifStatement.getElseBranch() != null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        return thenBranch instanceof PsiBreakStatement && ((PsiBreakStatement)thenBranch).getLabelIdentifier() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/UnrollLoopAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/UnrollLoopAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractExpressions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final CallMatcher LIST_CONSTRUCTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Arrays", "asList"), CallMatcher.staticCall("java.util.List", "of"));
        private static final CallMatcher SINGLETON_CONSTRUCTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "singleton", "singletonList").parameterCount(1), CallMatcher.staticCall("java.util.List", "of").parameterTypes("E"));

        private Holder() {
        }
    }
}

