/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.codeInsight.intention.impl.lists.AbstractChopListAction;
import com.intellij.codeInsight.intention.impl.lists.JavaListUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaChopListAction<L extends PsiElement, E extends PsiElement>
extends AbstractChopListAction<L, E> {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            AbstractJavaChopListAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AbstractJavaChopListAction.$$$reportNull$$$0(1);
        }
        if (!(element.getContainingFile() instanceof PsiJavaFile)) {
            return false;
        }
        return super.isAvailable(project, editor, element);
    }

    @Override
    @Nullable
    PsiElement prevBreak(@NotNull PsiElement element) {
        if (element == null) {
            AbstractJavaChopListAction.$$$reportNull$$$0(2);
        }
        return JavaListUtils.prevBreak(element);
    }

    @Override
    @Nullable
    PsiElement nextBreak(@NotNull PsiElement element) {
        if (element == null) {
            AbstractJavaChopListAction.$$$reportNull$$$0(3);
        }
        return JavaListUtils.nextBreak(element);
    }

    @Override
    int findOffsetForBreakAfter(E element) {
        PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward(element), PsiJavaToken.class);
        if (token != null && token.getTokenType() == JavaTokenType.COMMA) {
            return token.getTextRange().getEndOffset();
        }
        return element.getTextRange().getEndOffset();
    }

    @Override
    protected boolean canChop(List<E> elements) {
        return !JavaListUtils.containsEolComments(elements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/impl/lists/AbstractJavaChopListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prevBreak";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "nextBreak";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

