/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.singlereturn;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishMarker {
    @NotNull
    final FinishMarkerType myType;
    @Nullable
    final PsiExpression myDefaultValue;

    private FinishMarker(@NotNull FinishMarkerType type2, @Nullable PsiExpression value2) {
        if (type2 == null) {
            FinishMarker.$$$reportNull$$$0(0);
        }
        this.myType = type2;
        this.myDefaultValue = value2;
    }

    public static FinishMarker defineFinishMarker(@NotNull PsiCodeBlock block, @NotNull PsiType returnType, List<? extends PsiReturnStatement> returns) {
        if (block == null) {
            FinishMarker.$$$reportNull$$$0(1);
        }
        if (returnType == null) {
            FinishMarker.$$$reportNull$$$0(2);
        }
        boolean mayNeedMarker = FinishMarker.mayNeedMarker(returns, block);
        return FinishMarker.defineFinishMarker(block, returns, returnType, mayNeedMarker, JavaPsiFacade.getElementFactory((Project)block.getProject()));
    }

    private static boolean mayNeedMarker(List<? extends PsiReturnStatement> returns, PsiCodeBlock block) {
        for (PsiReturnStatement psiReturnStatement : returns) {
            if (!FinishMarker.mayNeedMarker(psiReturnStatement, block)) continue;
            return true;
        }
        return false;
    }

    static boolean mayNeedMarker(PsiReturnStatement returnStatement, PsiCodeBlock block) {
        PsiElement parent = returnStatement.getParent();
        while (parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiBlockStatement) {
                parent = grandParent.getParent();
                continue;
            }
            if (grandParent instanceof PsiCatchSection) {
                parent = grandParent.getParent();
                break;
            }
            if (grandParent instanceof PsiStatement) {
                parent = grandParent;
                break;
            }
            return parent != block;
        }
        if (!(parent instanceof PsiStatement)) {
            return true;
        }
        PsiStatement currentContext = (PsiStatement)parent;
        PsiStatement loopOrSwitch = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)currentContext, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class});
        if (loopOrSwitch != null && PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)loopOrSwitch, (boolean)true)) {
            currentContext = loopOrSwitch;
        } else {
            while (currentContext instanceof PsiIfStatement) {
                PsiElement ifParent = currentContext.getParent();
                if (ifParent instanceof PsiIfStatement) {
                    currentContext = (PsiStatement)ifParent;
                    continue;
                }
                if (!(ifParent instanceof PsiCodeBlock)) continue;
                if (!(ifParent.getParent() instanceof PsiStatement)) {
                    return ifParent != block;
                }
                currentContext = (PsiStatement)ifParent.getParent();
                if (!(currentContext instanceof PsiBlockStatement) || !(currentContext.getParent() instanceof PsiIfStatement) || ControlFlowUtils.codeBlockMayCompleteNormally((PsiCodeBlock)ifParent)) break;
                currentContext = (PsiStatement)currentContext.getParent();
            }
        }
        while (true) {
            PsiElement contextParent;
            if ((contextParent = currentContext.getParent()) instanceof PsiCodeBlock) {
                Object[] contextStatements = ((PsiCodeBlock)contextParent).getStatements();
                int pos = ArrayUtil.indexOf((Object[])contextStatements, (Object)currentContext);
                assert (pos >= 0);
                if (pos < contextStatements.length - 1) {
                    return true;
                }
                if (contextParent == block) {
                    return false;
                }
                if (!(contextParent.getParent() instanceof PsiStatement)) {
                    return true;
                }
                currentContext = (PsiStatement)contextParent.getParent();
                continue;
            }
            if (!(contextParent instanceof PsiIfStatement) && !(contextParent instanceof PsiLabeledStatement)) break;
            currentContext = (PsiStatement)contextParent;
        }
        return true;
    }

    private static FinishMarker defineFinishMarker(PsiCodeBlock block, List<? extends PsiReturnStatement> returns, PsiType returnType, boolean mayNeedMarker, PsiElementFactory factory) {
        Object value2;
        if (PsiType.VOID.equals((Object)returnType)) {
            return new FinishMarker(FinishMarkerType.SEPARATE_VAR, null);
        }
        PsiReturnStatement terminalReturn = (PsiReturnStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])block.getStatements()), PsiReturnStatement.class);
        List nonTerminalReturns = StreamEx.of(returns).without((Object)terminalReturn).map(PsiReturnStatement::getReturnValue).map(PsiUtil::skipParenthesizedExprDown).toList();
        if (nonTerminalReturns.size() == 0) {
            return new FinishMarker(FinishMarkerType.SEPARATE_VAR, null);
        }
        Set nonTerminalReturnValues = StreamEx.of((Collection)nonTerminalReturns).map(val -> val instanceof PsiLiteralExpression ? ((PsiLiteralExpression)val).getValue() : ObjectUtils.NULL).toSet();
        if (!mayNeedMarker) {
            PsiExpression initValue = FinishMarker.findBestExpression(terminalReturn, nonTerminalReturns, mayNeedMarker);
            if (initValue == null && nonTerminalReturnValues.size() == 1 && nonTerminalReturnValues.iterator().next() != ObjectUtils.NULL) {
                initValue = (PsiExpression)nonTerminalReturns.iterator().next();
            }
            return new FinishMarker(FinishMarkerType.SEPARATE_VAR, initValue);
        }
        if (PsiType.BOOLEAN.equals((Object)returnType) && nonTerminalReturnValues.size() == 1 && (value2 = nonTerminalReturnValues.iterator().next()) instanceof Boolean) {
            boolean boolReturn = (Boolean)value2;
            FinishMarkerType markerType = boolReturn ? FinishMarkerType.BOOLEAN_TRUE : FinishMarkerType.BOOLEAN_FALSE;
            return new FinishMarker(markerType, factory.createExpressionFromText(String.valueOf(!boolReturn), null));
        }
        if (PsiType.INT.equals((Object)returnType) || PsiType.LONG.equals((Object)returnType)) {
            return FinishMarker.getMarkerForIntegral(nonTerminalReturns, terminalReturn, mayNeedMarker, returnType, factory);
        }
        if (!(returnType instanceof PsiPrimitiveType)) {
            if (StreamEx.of((Collection)nonTerminalReturns).map(ret -> NullabilityUtil.getExpressionNullability(ret, true)).allMatch(arg_0 -> Nullability.NOT_NULL.equals(arg_0))) {
                return new FinishMarker(FinishMarkerType.VALUE_NON_EQUAL, factory.createExpressionFromText("null", null));
            }
        }
        if (terminalReturn != null && FinishMarker.canMoveToStart(value2 = terminalReturn.getReturnValue())) {
            return new FinishMarker(FinishMarkerType.SEPARATE_VAR, (PsiExpression)value2);
        }
        return new FinishMarker(FinishMarkerType.SEPARATE_VAR, FinishMarker.findBestExpression(terminalReturn, nonTerminalReturns, mayNeedMarker));
    }

    @Nullable
    private static PsiExpression findBestExpression(PsiReturnStatement terminalReturn, List<PsiExpression> nonTerminalReturns, boolean mayNeedMarker) {
        List bestGroup = ((LinkedHashMap)((StreamEx)StreamEx.of(nonTerminalReturns).filter(FinishMarker::canMoveToStart)).groupingBy(PsiElement::getText, LinkedHashMap::new, Collectors.toList())).values().stream().max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList());
        if (bestGroup.size() >= 2) {
            return (PsiExpression)bestGroup.get(0);
        }
        if (terminalReturn != null && FinishMarker.canMoveToStart(terminalReturn.getReturnValue())) {
            return terminalReturn.getReturnValue();
        }
        if (mayNeedMarker && !bestGroup.isEmpty()) {
            return (PsiExpression)bestGroup.get(0);
        }
        return null;
    }

    @NotNull
    private static FinishMarker getMarkerForIntegral(List<PsiExpression> nonTerminalReturns, PsiReturnStatement terminalReturn, boolean mayNeedMarker, PsiType returnType, PsiElementFactory factory) {
        boolean isLong = PsiType.LONG.equals((Object)returnType);
        LongRangeSet fullSet = Objects.requireNonNull(LongRangeSet.fromType(returnType));
        LongRangeSet set = nonTerminalReturns.stream().map(CommonDataflow::getExpressionRange).map(range -> range == null ? fullSet : range).reduce(LongRangeSet::unite).orElse(fullSet);
        if (!set.isEmpty() && !set.contains(fullSet)) {
            Long point;
            PsiExpression terminalReturnValue = terminalReturn == null ? null : terminalReturn.getReturnValue();
            LongRangeSet terminal = CommonDataflow.getExpressionRange(terminalReturnValue);
            if (terminal != null && (point = terminal.getConstantValue()) != null && !set.contains(point)) {
                PsiExpression defValue = FinishMarker.canMoveToStart(terminalReturnValue) ? (PsiExpression)terminalReturnValue.copy() : factory.createExpressionFromText(point + (isLong ? "L" : ""), null);
                return new FinishMarker(FinishMarkerType.VALUE_NON_EQUAL, defValue);
            }
            long[] candidates = new long[]{0L, 1L, -1L, fullSet.min(), fullSet.max()};
            point = null;
            for (long candidate : candidates) {
                if (set.contains(candidate)) continue;
                point = candidate;
                break;
            }
            if (point != null) {
                String text2 = point == Integer.MIN_VALUE ? "java.lang.Integer.MIN_VALUE" : (point == Integer.MAX_VALUE ? "java.lang.Integer.MAX_VALUE" : (point == Long.MIN_VALUE ? "java.lang.Long.MIN_VALUE" : (point == Long.MAX_VALUE ? "java.lang.Long.MAX_VALUE" : String.valueOf(point))));
                return new FinishMarker(FinishMarkerType.VALUE_NON_EQUAL, factory.createExpressionFromText(text2, null));
            }
        }
        return new FinishMarker(FinishMarkerType.SEPARATE_VAR, FinishMarker.findBestExpression(terminalReturn, nonTerminalReturns, mayNeedMarker));
    }

    @Contract(value="null -> false")
    private static boolean canMoveToStart(PsiExpression value2) {
        if (!ExpressionUtils.isSafelyRecomputableExpression(value2)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)value2), PsiReferenceExpression.class);
        if (ref != null && !ref.isQualified()) {
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (target instanceof PsiLocalVariable) {
                return false;
            }
            if (target instanceof PsiParameter) {
                PsiElement block = ((PsiParameter)target).getDeclarationScope();
                return block instanceof PsiMethod && HighlightControlFlowUtil.isEffectivelyFinal(target, block, null);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/impl/singlereturn/FinishMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "defineFinishMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum FinishMarkerType {
        BOOLEAN_TRUE,
        BOOLEAN_FALSE,
        VALUE_EQUAL,
        VALUE_NON_EQUAL,
        SEPARATE_VAR;

    }
}

