/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

public class JavaDocExternalFilter
extends AbstractExternalFilter {
    private final Project myProject;
    private PsiElement myElement;
    private static final AbstractExternalFilter.ParseSettings ourPackageInfoSettings = new AbstractExternalFilter.ParseSettings(Pattern.compile("package\\s+[^\\s]+\\s+description", 2), Pattern.compile("START OF BOTTOM NAVBAR", 2), true, false);
    private static final Pattern HREF_SELECTOR = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"", 34);
    private static final Pattern METHOD_HEADING = Pattern.compile("<H[34]>(.+?)</H[34]>", 34);
    private final AbstractExternalFilter.RefConvertor[] myReferenceConverters = new AbstractExternalFilter.RefConvertor[]{new AbstractExternalFilter.RefConvertor(HREF_SELECTOR){

        protected String convertReference(String root, String href) {
            if (BrowserUtil.isAbsoluteURL((String)href)) {
                return href;
            }
            String reference = JavaDocInfoGenerator.createReferenceForRelativeLink(href, JavaDocExternalFilter.this.myElement);
            if (reference == null) {
                if (href.startsWith("#")) {
                    return root + href;
                }
                String nakedRoot = ourHtmlFileSuffix.matcher(root).replaceAll("/");
                return JavaDocExternalFilter.doAnnihilate((String)(nakedRoot + href));
            }
            return reference;
        }
    }};

    public JavaDocExternalFilter(Project project) {
        this.myProject = project;
    }

    protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
        return this.myReferenceConverters;
    }

    @Nullable
    public static String filterInternalDocInfo(String text2) {
        return text2 == null ? null : PlatformDocumentationUtil.fixupText((CharSequence)text2);
    }

    @Nullable
    public String getExternalDocInfoForElement(@NotNull String docURL, PsiElement element) throws Exception {
        VirtualFile file;
        Url url;
        if (docURL == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(0);
        }
        String externalDoc = null;
        this.myElement = element;
        String projectPath = "/" + this.myProject.getName() + "/";
        String builtInServer = "http://localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() + projectPath;
        if (docURL.startsWith(builtInServer) && (url = Urls.parseFromIdea((CharSequence)docURL)) != null && (file = WebServerPathToFileManager.getInstance((Project)this.myProject).findVirtualFile(url.getPath().substring(projectPath.length()))) != null) {
            StringBuilder result = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
                this.doBuildFromStream(docURL, reader, result);
            }
            externalDoc = this.correctDocText(docURL, result);
        }
        if (externalDoc == null) {
            externalDoc = super.getExternalDocInfoForElement(docURL, element);
        }
        if (externalDoc == null) {
            return null;
        }
        if (element instanceof PsiMethod) {
            Pair classNameAndPresentation = (Pair)ReadAction.compute(() -> {
                PsiClass aClass = ((PsiMethod)element).getContainingClass();
                if (aClass != null) {
                    String qName = aClass.getQualifiedName();
                    return Pair.pair((Object)qName, (Object)(qName + JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)aClass, true)));
                }
                return null;
            });
            if (classNameAndPresentation == null) {
                return externalDoc;
            }
            Matcher matcher = METHOD_HEADING.matcher(externalDoc);
            StringBuilder buffer = new StringBuilder("<h3>");
            DocumentationManager.createHyperlink((StringBuilder)buffer, (String)((String)classNameAndPresentation.first), (String)((String)classNameAndPresentation.second), (boolean)false);
            return matcher.replaceFirst(buffer.append("</h3>").toString());
        }
        return externalDoc;
    }

    @NotNull
    protected AbstractExternalFilter.ParseSettings getParseSettings(@NotNull String url) {
        if (url == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(1);
        }
        AbstractExternalFilter.ParseSettings parseSettings = url.endsWith("package-summary.html") ? ourPackageInfoSettings : super.getParseSettings(url);
        if (parseSettings == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(2);
        }
        return parseSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docURL";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/javadoc/JavaDocExternalFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/javadoc/JavaDocExternalFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParseSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDocInfoForElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParseSettings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

