/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;

public class ShortenFQNamesProcessor
implements TemplateOptionalProcessor,
DumbAware {
    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.isToShortenLongNames()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            throw new IllegalStateException(editor + " " + editor.getDocument());
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file, templateRange.getStartOffset(), templateRange.getEndOffset()));
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
    }

    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return template.isToShortenLongNames();
    }

    public void setEnabled(Template template, boolean value2) {
        template.setToShortenLongNames(value2);
    }
}

