/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.text.BlockSupport;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeMacro
extends Macro {
    public String getName() {
        return "expectedType";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.expected.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiType[] types;
        if (params == null) {
            ExpectedTypeMacro.$$$reportNull$$$0(0);
        }
        if ((types = ExpectedTypeMacro.getExpectedTypes(params, context)) == null || types.length == 0) {
            return null;
        }
        return new PsiTypeResult(types[0], context.getProject());
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        PsiType[] types;
        if (params == null) {
            ExpectedTypeMacro.$$$reportNull$$$0(1);
        }
        if ((types = ExpectedTypeMacro.getExpectedTypes(params, context)) == null || types.length < 2) {
            return null;
        }
        LinkedHashSet set = new LinkedHashSet();
        for (PsiType type2 : types) {
            JavaTemplateUtil.addTypeLookupItem(set, type2);
        }
        return set.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static PsiType @Nullable [] getExpectedTypes(Expression[] params, ExpressionContext context) {
        ExpectedTypeInfo[] infos;
        if (params.length != 0) {
            return null;
        }
        Project project = context.getProject();
        PsiType[] types = null;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        assert (file != null);
        PsiFile fileCopy = (PsiFile)file.copy();
        BlockSupport.getInstance((Project)project).reparseRange(fileCopy, context.getTemplateStartOffset(), context.getTemplateEndOffset(), (CharSequence)"IntellijIdeaRulezzz ");
        PsiElement element = fileCopy.findElementAt(context.getTemplateStartOffset());
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiExpression && (infos = ExpectedTypesProvider.getExpectedTypes((PsiExpression)element.getParent(), true)).length > 0) {
            types = new PsiType[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                ExpectedTypeInfo info = infos[i];
                types[i] = info.getType();
            }
        }
        return types;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/codeInsight/template/macro/ExpectedTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

