/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

public class TypeOfVariableMacro
extends Macro {
    public String getName() {
        return "typeOfVariable";
    }

    public String getPresentableName() {
        return "typeOfVariable(VAR)";
    }

    @NotNull
    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            TypeOfVariableMacro.$$$reportNull$$$0(0);
        }
        if (params.length == 0) {
            return null;
        }
        Project project = context.getProject();
        Result result = params[0].calculateQuickResult(context);
        if (result instanceof PsiElementResult) {
            PsiElement element = ((PsiElementResult)result).getElement();
            if (element instanceof PsiVariable) {
                return new PsiTypeResult(((PsiVariable)element).getType(), project);
            }
        } else if (result instanceof TextResult) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
            PsiElement place = file.findElementAt(context.getStartOffset());
            PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(place, "");
            String name2 = result.toString();
            for (PsiVariable var : vars) {
                if (!name2.equals(var.getName())) continue;
                return new PsiTypeResult(var.getType(), project);
            }
        }
        return null;
    }

    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            TypeOfVariableMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(params, context);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/codeInsight/template/macro/TypeOfVariableMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

