/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PossibleHeapPollutionVarargsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(PossibleHeapPollutionVarargsInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            PossibleHeapPollutionVarargsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "SafeVarargsDetector";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "unchecked";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PossibleHeapPollutionVarargsInspection.$$$reportNull$$$0(1);
        }
        return new HeapPollutionVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HeapPollutionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public HeapPollutionVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!PsiUtil.getLanguageLevel((PsiElement)method).isAtLeast(LanguageLevel.JDK_1_7)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiParameter psiParameter = parameters2[parameters2.length - 1];
            if (!psiParameter.isVarArgs()) {
                return;
            }
            this.checkForHeapPollution(method, (PsiVariable)psiParameter);
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (!aClass.isRecord()) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            PsiRecordHeader header = aClass.getRecordHeader();
            if (header == null) {
                return;
            }
            PsiRecordComponent lastComponent = (PsiRecordComponent)ArrayUtil.getLastElement((Object[])header.getRecordComponents());
            if (lastComponent == null || !lastComponent.isVarArgs()) {
                return;
            }
            PsiMethod constructor = JavaPsiRecordUtil.findCanonicalConstructor(aClass);
            if (constructor != null && constructor.isPhysical()) {
                return;
            }
            PsiType type2 = lastComponent.getType();
            LOG.assertTrue(type2 instanceof PsiEllipsisType, (Object)("type: " + type2.getCanonicalText() + "; param: " + lastComponent));
            PsiType componentType = ((PsiEllipsisType)type2).getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                return;
            }
            PsiElement nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                AnnotateAsSafeVarargsQuickFix quickFix = new AnnotateAsSafeVarargsQuickFix();
                this.myHolder.registerProblem(nameIdentifier, JavaAnalysisBundle.message((String)"possible.heap.pollution.from.parameterized.vararg.type.loc", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
            }
        }

        private void checkForHeapPollution(PsiMethod method, PsiVariable psiParameter) {
            PsiType type2 = psiParameter.getType();
            LOG.assertTrue(type2 instanceof PsiEllipsisType, (Object)("type: " + type2.getCanonicalText() + "; param: " + psiParameter));
            PsiType componentType = ((PsiEllipsisType)type2).getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter)) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)element))) continue;
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerProblem(method, nameIdentifier);
            }
        }

        protected void registerProblem(PsiMethod method, PsiIdentifier nameIdentifier) {
            Object quickFix;
            if (GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, PsiUtil.getLanguageLevel((PsiElement)method))) {
                quickFix = new AnnotateAsSafeVarargsQuickFix();
            } else {
                PsiClass containingClass = method.getContainingClass();
                LOG.assertTrue(containingClass != null);
                boolean canBeFinal = !method.hasModifierProperty("abstract") && !containingClass.isInterface() && OverridingMethodsSearch.search((PsiMethod)method).findFirst() == null;
                quickFix = canBeFinal ? new MakeFinalAndAnnotateQuickFix() : null;
            }
            this.myHolder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"possible.heap.pollution.from.parameterized.vararg.type.loc", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
        }
    }

    private static class MakeFinalAndAnnotateQuickFix
    implements LocalQuickFix {
        private MakeFinalAndAnnotateQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"make.final.and.annotate.as.safevarargs", (Object[])new Object[0]);
            if (string == null) {
                MakeFinalAndAnnotateQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                MakeFinalAndAnnotateQuickFix.$$$reportNull$$$0(1);
            }
            return currentFile;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                MakeFinalAndAnnotateQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MakeFinalAndAnnotateQuickFix.$$$reportNull$$$0(3);
            }
            if ((psiElement = descriptor.getPsiElement()) instanceof PsiIdentifier) {
                PsiMethod psiMethod = (PsiMethod)psiElement.getParent();
                WriteAction.run(() -> psiMethod.getModifierList().setModifierProperty("final", true));
                new AddAnnotationPsiFix("java.lang.SafeVarargs", (PsiModifierListOwner)psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AnnotateAsSafeVarargsQuickFix
    implements LocalQuickFix {
        private AnnotateAsSafeVarargsQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"annotate.as.safevarargs", (Object[])new Object[0]);
            if (string == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof PsiIdentifier)) {
                return;
            }
            PsiModifierListOwner owner2 = (PsiModifierListOwner)psiElement.getParent();
            if (owner2 instanceof PsiClass) {
                PsiClass rec = (PsiClass)owner2;
                if (!rec.isRecord()) {
                    return;
                }
                String compactCtorText = "public " + rec.getName() + " {}";
                PsiMethod ctor = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(compactCtorText, (PsiElement)owner2);
                PsiMethod firstMethod = (PsiMethod)ArrayUtil.getFirstElement((Object[])rec.getMethods());
                owner2 = (PsiMethod)WriteCommandAction.writeCommandAction((PsiFile)owner2.getContainingFile(), (PsiFile[])new PsiFile[0]).withName(this.getFamilyName()).compute(() -> rec.addBefore((PsiElement)ctor, (PsiElement)firstMethod));
            }
            if (owner2 instanceof PsiMethod) {
                new AddAnnotationPsiFix("java.lang.SafeVarargs", owner2, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

