/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAssignmentFix
extends RemoveInitializerFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"inspection.unused.assignment.remove.assignment.quickfix", (Object[])new Object[0]);
        if (string == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PsiElement parent;
        if (project == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(2);
        }
        if (!((parent = (element = descriptor.getPsiElement()) instanceof PsiReferenceExpression ? element.getParent() : element) instanceof PsiAssignmentExpression)) {
            return;
        }
        PsiAssignmentExpression parentExpr = (PsiAssignmentExpression)parent;
        PsiElement gParentExpr = parentExpr.getParent();
        PsiExpression initializer = RemoveAssignmentFix.getInitializer(parentExpr);
        if (initializer == null) {
            return;
        }
        if (RemoveAssignmentFix.mayBeFixedWithoutSideEffect(gParentExpr)) {
            if (!FileModificationService.getInstance().prepareFileForWrite(gParentExpr.getContainingFile())) {
                return;
            }
            WriteAction.run(() -> {
                if (gParentExpr instanceof PsiParenthesizedExpression) {
                    gParentExpr.replace((PsiElement)initializer);
                } else {
                    parentExpr.replace((PsiElement)initializer);
                }
            });
            return;
        }
        PsiElement resolve2 = RemoveAssignmentFix.resolveExpression(element, parentExpr);
        if (!(resolve2 instanceof PsiVariable)) {
            return;
        }
        RemoveAssignmentFix.sideEffectAwareRemove(project, initializer, parent, (PsiVariable)resolve2);
    }

    @Nullable
    private static PsiExpression getInitializer(@NotNull PsiAssignmentExpression assignmentExpr) {
        if (assignmentExpr == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(3);
        }
        IElementType operationSign = assignmentExpr.getOperationTokenType();
        PsiExpression result = assignmentExpr.getRExpression();
        if (JavaTokenType.EQ != operationSign && result != null) {
            result = DeclarationJoinLinesHandler.getInitializerExpression(assignmentExpr.getLExpression(), assignmentExpr);
        }
        return result;
    }

    private static boolean mayBeFixedWithoutSideEffect(@NotNull PsiElement expr2) {
        if (expr2 == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(4);
        }
        return expr2 instanceof PsiExpression || expr2 instanceof PsiExpressionList || expr2 instanceof PsiReturnStatement || expr2 instanceof PsiLocalVariable;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PsiElement expr2, @NotNull PsiAssignmentExpression parentExpr) {
        if (expr2 == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(5);
        }
        if (parentExpr == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(6);
        }
        PsiElement result = null;
        if (expr2 instanceof PsiReferenceExpression) {
            result = ((PsiReferenceExpression)expr2).resolve();
        } else {
            PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)parentExpr.getLExpression());
            if (lExpr instanceof PsiReferenceExpression) {
                result = ((PsiReferenceExpression)lExpr).resolve();
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAssignmentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpr";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mayBeFixedWithoutSideEffect";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

