/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class AnnotationBasedNonBlockingContextChecker
implements NonBlockingContextChecker {
    private final List<String> myNonBlockingAnnotations;

    public AnnotationBasedNonBlockingContextChecker(List<String> nonBlockingAnnotations) {
        this.myNonBlockingAnnotations = nonBlockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(0);
        }
        return this.myNonBlockingAnnotations != null && StreamEx.of((Object)"org.jetbrains.annotations.NonBlocking").append(this.myNonBlockingAnnotations).anyMatch(annotation -> JavaPsiFacade.getInstance((Project)file.getProject()).findClass(annotation, file.getResolveScope()) != null);
    }

    public boolean isContextNonBlockingFor(@NotNull PsiElement element) {
        UCallExpression callExpression;
        if (element == null) {
            AnnotationBasedNonBlockingContextChecker.$$$reportNull$$$0(1);
        }
        if ((callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class)) == null) {
            return false;
        }
        UMethod callingMethod = (UMethod)UastUtils.getParentOfType((UElement)callExpression, UMethod.class);
        if (callingMethod == null) {
            return false;
        }
        PsiMethod psiCallingMethod = callingMethod.getJavaPsi();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiCallingMethod, this.myNonBlockingAnnotations, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/AnnotationBasedNonBlockingContextChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isContextNonBlockingFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

