/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.InThrowAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailedException;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class ClassDataIndexer
implements VirtualFileGist.GistCalculator<Map<HMember, Equations>> {
    static final String STRING_CONCAT_FACTORY = "java/lang/invoke/StringConcatFactory";
    public static final Consumer<Map<HMember, Equations>> ourIndexSizeStatistics = ApplicationManager.getApplication().isUnitTestMode() ? new ClassDataIndexerStatistics() : map2 -> {};
    static final BinaryOperator<Equations> MERGER = (eq1, eq2) -> eq1.equals(eq2) ? eq1 : new Equations(Collections.emptyList(), false);
    private static final int VERSION = 14;
    private static final int VERSION_MODIFIER = HardCodedPurity.AGGRESSIVE_HARDCODED_PURITY ? 1 : 0;
    private static final int FINAL_VERSION = 28 + VERSION_MODIFIER;
    private static final VirtualFileGist<Map<HMember, Equations>> ourGist = GistManager.getInstance().newVirtualFileGist("BytecodeAnalysisIndex", FINAL_VERSION, (DataExternalizer)new BytecodeAnalysisIndex.EquationsExternalizer(), (VirtualFileGist.GistCalculator)new ClassDataIndexer());

    @Nullable
    public Map<HMember, Equations> calcData(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            ClassDataIndexer.$$$reportNull$$$0(0);
        }
        HashMap<HMember, Equations> map2 = new HashMap<HMember, Equations>();
        if (ClassDataIndexer.isFileExcluded(file)) {
            return map2;
        }
        try {
            ClassReader reader = new ClassReader(file.contentsToByteArray(false));
            Map<EKey, Equations> allEquations = ClassDataIndexer.processClass(reader, file.getPresentableUrl());
            allEquations = ClassDataIndexer.solvePartially(reader.getClassName(), allEquations);
            allEquations.forEach((methodKey, equations) -> map2.merge(methodKey.member.hashed(), ClassDataIndexer.hash(equations), MERGER));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        ourIndexSizeStatistics.consume(map2);
        return map2;
    }

    static boolean isFileExcluded(VirtualFile file) {
        return ClassDataIndexer.isInsideDummyAndroidJar(file);
    }

    private static boolean isInsideDummyAndroidJar(VirtualFile file) {
        String path = file.getPath();
        int index = path.indexOf("/android.jar!/");
        return index > 0 && path.lastIndexOf("platforms/android-", index) > 0;
    }

    private static Map<EKey, Equations> solvePartially(String className2, Map<EKey, Equations> map2) {
        PuritySolver solver = new PuritySolver();
        BiFunction<EKey, Equations, EKey> keyCreator = (key2, eqs) -> new EKey(key2.member, eqs.find(Direction.Volatile).isPresent() ? Direction.Volatile : Direction.Pure, eqs.stable, false);
        EntryStream.of(map2).mapToKey(keyCreator).flatMapValues(eqs -> eqs.results.stream().map(drp -> drp.result)).selectValues(Effects.class).forKeyValue(solver::addEquation);
        solver.addPlainFieldEquations(md -> md instanceof Member && ((Member)md).internalClassName.equals(className2));
        Map<EKey, Effects> solved = solver.solve();
        Map partiallySolvedPurity = StreamEx.of((Object[])new Map[]{solved, solver.pending}).flatMapToEntry(Function.identity()).removeValues(Effects::isTop).toMap();
        return EntryStream.of(map2).mapToValue((key2, eqs) -> eqs.update(Direction.Pure, (Effects)partiallySolvedPurity.get(keyCreator.apply((EKey)key2, (Equations)eqs)))).toMap();
    }

    private static Equations hash(Equations equations) {
        return new Equations(ContainerUtil.map(equations.results, ClassDataIndexer::hash), equations.stable);
    }

    private static DirectionResultPair hash(DirectionResultPair drp) {
        return new DirectionResultPair(drp.directionKey, ClassDataIndexer.hash(drp.result));
    }

    private static Result hash(Result result) {
        if (result instanceof Effects) {
            Effects effects = (Effects)result;
            return new Effects(effects.returnValue, StreamEx.of(effects.effects).map(ClassDataIndexer::hash).toSet());
        }
        if (result instanceof Pending) {
            return new Pending(ContainerUtil.map((Object[])((Pending)result).delta, ClassDataIndexer::hash));
        }
        return result;
    }

    private static Component hash(Component component) {
        return new Component(component.value, (EKey[])StreamEx.of((Object[])component.ids).map(EKey::hashed).toArray(EKey[]::new));
    }

    private static EffectQuantum hash(EffectQuantum effect) {
        if (effect instanceof EffectQuantum.CallQuantum) {
            EffectQuantum.CallQuantum call = (EffectQuantum.CallQuantum)effect;
            return new EffectQuantum.CallQuantum(call.key.hashed(), call.data, call.isStatic);
        }
        return effect;
    }

    @NotNull
    private static Equations convertEquations(EKey methodKey, List<Equation> rawMethodEquations) {
        List compressedMethodEquations = ContainerUtil.map(rawMethodEquations, equation -> new DirectionResultPair(equation.key.dirKey, equation.result));
        return new Equations(compressedMethodEquations, methodKey.stable);
    }

    public static Map<EKey, Equations> processClass(ClassReader classReader, String presentableUrl) {
        ExpandableArray sharedPendingStates = new ExpandableArray();
        ExpandableArray sharedPendingActions = new ExpandableArray();
        ExpandableArray sharedResults = new ExpandableArray();
        HashMap<EKey, Equations> equations = new HashMap<EKey, Equations>();
        ClassDataIndexer.registerVolatileFields(equations, classReader);
        Set<Member> staticFinalFields = ClassDataIndexer.getStaticFinalFields(classReader);
        if ((classReader.getAccess() & 0x4000) != 0) {
            EKey ordinalKey = new EKey(new Member(classReader.getClassName(), "ordinal", "()I"), Direction.Out, true);
            equations.put(ordinalKey, new Equations(Collections.singletonList(new DirectionResultPair(Direction.Pure.asInt(), new Effects(DataValue.LocalDataValue, Collections.emptySet()))), true));
        }
        classReader.accept((ClassVisitor)new MethodAnalysisVisitor(equations, presentableUrl, sharedPendingStates, sharedPendingActions, sharedResults, staticFinalFields), 6);
        return equations;
    }

    private static void registerVolatileFields(final Map<EKey, Equations> equations, final ClassReader classReader) {
        classReader.accept(new ClassVisitor(524288){

            public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
                if ((access & 0x40) != 0) {
                    EKey fieldKey = new EKey(new Member(classReader.getClassName(), name2, desc), Direction.Out, true);
                    equations.put(fieldKey, new Equations(Collections.singletonList(new DirectionResultPair(Direction.Volatile.asInt(), Effects.VOLATILE_EFFECTS)), true));
                }
                return null;
            }
        }, 7);
    }

    private static Set<Member> getStaticFinalFields(final ClassReader classReader) {
        final HashSet<Member> staticFields = new HashSet<Member>();
        classReader.accept(new ClassVisitor(524288){

            public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
                int modifiers = 24;
                if ((access & modifiers) == modifiers && (access & 0x5000) == 0 && (desc.startsWith("L") || desc.startsWith("["))) {
                    staticFields.add(new Member(classReader.getClassName(), name2, desc));
                }
                return null;
            }
        }, 7);
        return staticFields;
    }

    @NotNull
    static List<Equations> getEquations(GlobalSearchScope scope, HMember key2) {
        List list = ContainerUtil.mapNotNull((Collection)FileBasedIndex.getInstance().getContainingFiles(BytecodeAnalysisIndex.NAME, (Object)key2, scope), file -> (Equations)((Map)ourGist.getFileData(null, file)).get(key2));
        if (list == null) {
            ClassDataIndexer.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodAnalysisVisitor
    extends KeyedMethodVisitor {
        private final Map<EKey, Equations> myEquations;
        private final String myPresentableUrl;
        private final ExpandableArray<State> mySharedPendingStates;
        private final ExpandableArray<PendingAction> mySharedPendingActions;
        private final ExpandableArray<PResults.PResult> mySharedResults;
        private final Set<Member> myStaticFinalFields;

        private MethodAnalysisVisitor(Map<EKey, Equations> equations, String presentableUrl, ExpandableArray<State> sharedPendingStates, ExpandableArray<PendingAction> sharedPendingActions, ExpandableArray<PResults.PResult> sharedResults, Set<Member> staticFinalFields) {
            this.myEquations = equations;
            this.myPresentableUrl = presentableUrl;
            this.mySharedPendingStates = sharedPendingStates;
            this.mySharedPendingActions = sharedPendingActions;
            this.mySharedResults = sharedResults;
            this.myStaticFinalFields = staticFinalFields;
        }

        @Override
        protected MethodVisitor visitMethod(final MethodNode node, final Member method, final EKey key2) {
            return new MethodVisitor(524288, (MethodVisitor)node){
                private boolean jsr;

                public void visitJumpInsn(int opcode, Label label) {
                    if (opcode == 168) {
                        this.jsr = true;
                    }
                    super.visitJumpInsn(opcode, label);
                }

                public void visitEnd() {
                    super.visitEnd();
                    myEquations.put(key2, ClassDataIndexer.convertEquations(key2, this.processMethod(node, this.jsr, method, key2.stable)));
                }
            };
        }

        private List<Equation> processMethod(MethodNode methodNode, boolean jsr, Member method, boolean stable) {
            ProgressManager.checkCanceled();
            Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
            Type resultType = Type.getReturnType((String)methodNode.desc);
            boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
            boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
            boolean isInterestingResult = isReferenceResult || isBooleanResult;
            ArrayList<Equation> equations = new ArrayList<Equation>();
            ContainerUtil.addIfNotNull(equations, (Object)PurityAnalysis.analyze(method, methodNode, stable));
            try {
                ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                if (graph.transitions.length > 0) {
                    boolean branching;
                    DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                    boolean bl = branching = !dfs.back.isEmpty();
                    if (!branching) {
                        for (int[] transition : graph.transitions) {
                            if (transition == null || transition.length <= 1) continue;
                            branching = true;
                            break;
                        }
                    }
                    if (branching) {
                        RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                        if (richControlFlow.reducible()) {
                            NegationAnalysis negated = MethodAnalysisVisitor.tryNegation(method, argumentTypes, graph, isBooleanResult, dfs, jsr);
                            this.processBranchingMethod(method, methodNode, richControlFlow, argumentTypes, resultType, stable, jsr, equations, negated);
                            return equations;
                        }
                        ProjectBytecodeAnalysis.LOG.debug(method + ": CFG is not reducible");
                    } else {
                        this.processNonBranchingMethod(method, argumentTypes, graph, resultType, stable, equations);
                        return equations;
                    }
                }
                equations.addAll(MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                return equations;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (TooComplexException e) {
                ProjectBytecodeAnalysis.LOG.debug(method + " in " + this.myPresentableUrl + " is too complex for bytecode analysis");
                return MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable);
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + method + " in " + this.myPresentableUrl, e);
                return MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable);
            }
        }

        private static NegationAnalysis tryNegation(final Member method, final Type[] argumentTypes, final ControlFlowGraph graph, boolean isBooleanResult, DFSTree dfs, final boolean jsr) throws AnalyzerException {
            Util util;
            class Util {
                Util() {
                }

                boolean isMethodCall(int opCode) {
                    return opCode == 184 || opCode == 183 || opCode == 182 || opCode == 185;
                }

                boolean singleIfBranch() {
                    int branch = 0;
                    for (int i = 0; i < graph.transitions.length; ++i) {
                        int[] transition = graph.transitions[i];
                        if (transition.length == 2) {
                            boolean isIfInsn;
                            ++branch;
                            int opCode = graph.methodNode.instructions.get(i).getOpcode();
                            boolean bl = isIfInsn = opCode == 153 || opCode == 154;
                            if (!isIfInsn) {
                                return false;
                            }
                        }
                        if (branch <= 1) continue;
                        return false;
                    }
                    return branch == 1;
                }

                boolean singleMethodCall() {
                    int callCount = 0;
                    for (int i = 0; i < graph.transitions.length; ++i) {
                        if (!this.isMethodCall(graph.methodNode.instructions.get(i).getOpcode()) || ++callCount <= 1) continue;
                        return false;
                    }
                    return callCount == 1;
                }

                public boolean booleanConstResult() {
                    try {
                        boolean[] origins = OriginsAnalysis.resultOrigins(MethodAnalysisVisitor.leakingParametersAndFrames((Member)method, (MethodNode)graph.methodNode, (Type[])argumentTypes, (boolean)jsr).frames, graph.methodNode.instructions, graph);
                        for (int i = 0; i < origins.length; ++i) {
                            boolean isBooleanConst;
                            if (!origins[i]) continue;
                            int opCode = graph.methodNode.instructions.get(i).getOpcode();
                            boolean bl = isBooleanConst = opCode == 3 || opCode == 4;
                            if (isBooleanConst) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (AnalyzerException analyzerException) {
                        return false;
                    }
                }
            }
            if (graph.methodNode.instructions.size() < 20 && isBooleanResult && dfs.back.isEmpty() && !jsr && (util = new Util()).singleIfBranch() && util.singleMethodCall() && util.booleanConstResult()) {
                NegationAnalysis analyzer = new NegationAnalysis(method, graph);
                try {
                    analyzer.analyze();
                    return analyzer;
                }
                catch (NegationAnalysisFailedException ignore) {
                    return null;
                }
            }
            return null;
        }

        private void processBranchingMethod(Member method, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, Type resultType, boolean stable, boolean jsr, List<? super Equation> result, NegationAnalysis negatedAnalysis) throws AnalyzerException {
            boolean withCycle;
            Equation throwEquation;
            boolean shouldInferNonTrivialFailingContracts;
            Equation outEquation;
            boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
            boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
            boolean isInterestingResult = isBooleanResult || isReferenceResult;
            LeakingParameters leakingParametersAndFrames = MethodAnalysisVisitor.leakingParametersAndFrames(method, methodNode, argumentTypes, jsr);
            boolean[] leakingParameters = leakingParametersAndFrames.parameters;
            boolean[] leakingNullableParameters = leakingParametersAndFrames.nullableParameters;
            boolean[] origins = OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow);
            Equation equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable, this.mySharedPendingStates).analyze() : null;
            if (isReferenceResult) {
                result.add(outEquation);
                result.add(new Equation(new EKey(method, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
            }
            if (methodNode.name.equals("<init>")) {
                shouldInferNonTrivialFailingContracts = false;
                throwEquation = new Equation(new EKey(method, Direction.Throw, stable), Value.Top);
            } else {
                InThrowAnalysis inThrowAnalysis = new InThrowAnalysis(richControlFlow, Direction.Throw, origins, stable, this.mySharedPendingStates);
                throwEquation = inThrowAnalysis.analyze();
                if (!throwEquation.result.equals(Value.Top)) {
                    result.add(throwEquation);
                }
                shouldInferNonTrivialFailingContracts = !inThrowAnalysis.myHasNonTrivialReturn;
            }
            boolean bl = withCycle = !richControlFlow.dfsTree.back.isEmpty();
            if (argumentTypes.length > 50 && withCycle) {
                return;
            }
            IntFunction<Function> inOuts = index -> val -> {
                if (isBooleanResult && negatedAnalysis != null) {
                    return Stream.of(negatedAnalysis.contractEquation(index, (Value)val, stable));
                }
                Stream.Builder<Equation> builder = Stream.builder();
                try {
                    if (isInterestingResult) {
                        builder.add(new InOutAnalysis(richControlFlow, new Direction.InOut(index, (Value)val), origins, stable, this.mySharedPendingStates).analyze());
                    }
                    if (shouldInferNonTrivialFailingContracts) {
                        Direction.InThrow direction = new Direction.InThrow(index, (Value)val);
                        if (throwEquation.result.equals(Value.Fail)) {
                            builder.add(new Equation(new EKey(method, direction, stable), Value.Fail));
                        } else {
                            builder.add(new InThrowAnalysis(richControlFlow, direction, origins, stable, this.mySharedPendingStates).analyze());
                        }
                    }
                }
                catch (AnalyzerException e) {
                    throw new RuntimeException("Analyzer error", e);
                }
                return builder.build();
            };
            for (int i = 0; i < argumentTypes.length; ++i) {
                boolean notNullParam = false;
                if (ASMUtils.isReferenceType(argumentTypes[i])) {
                    boolean possibleNPE = false;
                    if (leakingParameters[i]) {
                        NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i, false), stable, this.mySharedPendingActions, this.mySharedResults);
                        Equation notNullParamEquation = notNullInAnalysis.analyze();
                        possibleNPE = notNullInAnalysis.possibleNPE;
                        notNullParam = notNullParamEquation.result.equals(Value.NotNull);
                        result.add(notNullParamEquation);
                    } else {
                        result.add(new Equation(new EKey(method, new Direction.In(i, false), stable), Value.Top));
                    }
                    if (leakingNullableParameters[i]) {
                        if (notNullParam || possibleNPE) {
                            result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Top));
                        } else {
                            result.add(new NullableInAnalysis(richControlFlow, new Direction.In(i, true), stable, this.mySharedPendingStates).analyze());
                        }
                    } else {
                        result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Null));
                    }
                    if (isInterestingResult) {
                        if (!leakingParameters[i]) {
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), outEquation.result));
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.result));
                            continue;
                        }
                        if (notNullParam) {
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), Value.Bot));
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.result));
                            continue;
                        }
                    }
                }
                Value.typeValues(argumentTypes[i]).flatMap(inOuts.apply(i)).forEach(result::add);
            }
        }

        private void processNonBranchingMethod(Member method, Type[] argumentTypes, ControlFlowGraph graph, Type returnType, boolean stable, List<? super Equation> result) throws AnalyzerException {
            Set<Member> fieldsToTrack = method.methodName.equals("<clinit>") ? this.myStaticFinalFields : Collections.emptySet();
            CombinedAnalysis analyzer = new CombinedAnalysis(method, graph, fieldsToTrack);
            analyzer.analyze();
            ContainerUtil.addIfNotNull(result, (Object)analyzer.outContractEquation(stable));
            ContainerUtil.addIfNotNull(result, (Object)analyzer.failEquation(stable));
            this.storeStaticFieldEquations(analyzer);
            if (ASMUtils.isReferenceType(returnType)) {
                result.add(analyzer.nullableResultEquation(stable));
            }
            EntryStream.of((Object[])argumentTypes).forKeyValue((i, argType) -> {
                if (ASMUtils.isReferenceType(argType)) {
                    result.add(analyzer.notNullParamEquation((int)i, stable));
                    result.add(analyzer.nullableParamEquation((int)i, stable));
                }
                Value.typeValues(argType).flatMap(val -> Stream.of(analyzer.contractEquation((int)i, (Value)val, stable), analyzer.failEquation((int)i, (Value)val, stable))).filter(Objects::nonNull).forEach(result::add);
            });
        }

        private void storeStaticFieldEquations(CombinedAnalysis analyzer) {
            for (Equation equation : analyzer.staticFieldEquations()) {
                this.myEquations.put(equation.key, new Equations(Collections.singletonList(new DirectionResultPair(equation.key.dirKey, equation.result)), true));
            }
        }

        private static List<Equation> topEquations(Member method, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
            ArrayList<Equation> result = new ArrayList<Equation>(argumentTypes.length * 4 + 2);
            if (isReferenceResult) {
                result.add(new Equation(new EKey(method, Direction.Out, stable), Value.Top));
                result.add(new Equation(new EKey(method, Direction.NullableOut, stable), Value.Bot));
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                result.add(new Equation(new EKey(method, new Direction.In(i, false), stable), Value.Top));
                result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Top));
                if (!isInterestingResult) continue;
                result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), Value.Top));
                result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), Value.Top));
            }
            return result;
        }

        @NotNull
        private static LeakingParameters leakingParametersAndFrames(Member method, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
            LeakingParameters leakingParameters = argumentTypes.length < 32 ? LeakingParameters.buildFast(method.internalClassName, methodNode, jsr) : LeakingParameters.build(method.internalClassName, methodNode, jsr);
            if (leakingParameters == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(0);
            }
            return leakingParameters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$MethodAnalysisVisitor", "leakingParametersAndFrames"));
        }
    }

    private static class ClassDataIndexerStatistics
    implements Consumer<Map<HMember, Equations>> {
        private static final AtomicLong ourTotalSize = new AtomicLong(0L);
        private static final AtomicLong ourTotalCount = new AtomicLong(0L);

        private ClassDataIndexerStatistics() {
        }

        public void consume(Map<HMember, Equations> map2) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                new BytecodeAnalysisIndex.EquationsExternalizer().save((DataOutput)new DataOutputStream(stream), map2);
                ourTotalSize.addAndGet(stream.size());
                ourTotalCount.incrementAndGet();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            if (ourTotalCount.get() == 0L) {
                return "";
            }
            return String.format(Locale.ENGLISH, "Classes: %d\nBytes: %d\nBytes per class: %.2f%n", ourTotalCount.get(), ourTotalSize.get(), (double)ourTotalSize.get() / (double)ourTotalCount.get());
        }
    }
}

