/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.openapi.util.text.StringHash;
import java.nio.ByteBuffer;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMember
implements MemberDescriptor {
    private static final int CLASS_HASH_SIZE = 8;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 12;
    final long myClass;
    final int myMethod;

    HMember(Member method) {
        this.myClass = StringHash.calc((String)method.internalClassName);
        this.myMethod = StringHash.murmur((String)method.methodName, (int)37) * 31 + StringHash.murmur((String)method.methodDesc, (int)41);
    }

    public HMember(byte @NotNull [] bytes) {
        if (bytes == null) {
            HMember.$$$reportNull$$$0(0);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.myClass = buffer.getLong();
        this.myMethod = buffer.getInt();
    }

    byte @NotNull [] asBytes() {
        ByteBuffer bytes = ByteBuffer.allocate(12);
        bytes.putLong(this.myClass).putInt(this.myMethod);
        byte[] byArray = bytes.array();
        if (byArray == null) {
            HMember.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMember that = (HMember)o;
        return that.myClass == this.myClass && that.myMethod == this.myMethod;
    }

    public int hashCode() {
        return Long.hashCode(this.myClass) * 31 + this.myMethod;
    }

    @Override
    @NotNull
    public HMember hashed() {
        HMember hMember = this;
        if (hMember == null) {
            HMember.$$$reportNull$$$0(2);
        }
        return hMember;
    }

    public String toString() {
        return HMember.bytesToString(this.asBytes());
    }

    static String bytesToString(byte[] key2) {
        return IntStreamEx.of((byte[])key2).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/HMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/HMember";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asBytes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "hashed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

