/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @NotNull
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        CommonDataflowVisitor visitor2;
        if (block == null) {
            return new DataflowResult(RunnerResult.NOT_APPLICABLE);
        }
        DataFlowRunner runner = new DataFlowRunner(block.getProject(), block, false, ThreeState.UNSURE);
        RunnerResult result = runner.analyzeMethodRecursively(block, visitor2 = new CommonDataflowVisitor());
        if (result != RunnerResult.OK) {
            return new DataflowResult(result);
        }
        if (!(block instanceof PsiClass)) {
            DataflowResult dataflowResult = visitor2.myResult;
            if (dataflowResult == null) {
                CommonDataflow.$$$reportNull$$$0(0);
            }
            return dataflowResult;
        }
        DataflowResult dfr = visitor2.myResult.copy();
        List states = visitor2.myEndOfInitializerStates;
        for (PsiMethod method : ((PsiClass)block).getConstructors()) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) continue;
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)block, method) ? Collections.singletonList(runner.createMemoryState()) : StreamEx.of((Collection)states).map(DfaMemoryState::createCopy).toList();
            if (runner.analyzeBlockRecursively((PsiElement)body2, initialStates, visitor2) == RunnerResult.OK) {
                dfr = visitor2.myResult.copy();
                continue;
            }
            visitor2.myResult = dfr;
        }
        DataflowResult dataflowResult = dfr;
        if (dataflowResult == null) {
            CommonDataflow.$$$reportNull$$$0(1);
        }
        return dataflowResult;
    }

    @Nullable
    public static DataflowResult getDataflowResult(PsiExpression context) {
        final PsiElement body2 = DfaUtil.getDataflowContext(context);
        if (body2 == null) {
            return null;
        }
        final ConcurrentHashMap fileMap = (ConcurrentHashMap)CachedValuesManager.getCachedValue((PsiElement)body2.getContainingFile(), () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        class ManagedCompute
        implements ForkJoinPool.ManagedBlocker {
            DataflowResult myResult;

            ManagedCompute() {
            }

            @Override
            public boolean block() {
                this.myResult = fileMap.computeIfAbsent(body2, x$0 -> CommonDataflow.runDFA(x$0));
                return true;
            }

            @Override
            public boolean isReleasable() {
                this.myResult = (DataflowResult)fileMap.get(body2);
                return this.myResult != null;
            }

            DataflowResult getResult() {
                return this.myResult == null || this.myResult.myResult != RunnerResult.OK ? null : this.myResult;
            }
        }
        ManagedCompute managedCompute = new ManagedCompute();
        try {
            ForkJoinPool.managedBlock(managedCompute);
        }
        catch (RejectedExecutionException ex) {
            managedCompute.block();
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        return managedCompute.getResult();
    }

    @NotNull
    public static DfType getDfType(PsiExpression expression2) {
        DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                CommonDataflow.$$$reportNull$$$0(2);
            }
            return dfType;
        }
        DfType dfType = result.getDfType(PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2));
        if (dfType == null) {
            CommonDataflow.$$$reportNull$$$0(3);
        }
        return dfType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static LongRangeSet getExpressionRange(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        LongRangeSet rangeSet = LongRangeSet.fromConstant(value2);
        if (rangeSet != null) {
            return rangeSet;
        }
        DfType dfType = CommonDataflow.getDfType(expression2);
        return dfType instanceof DfIntegralType ? ((DfIntegralType)dfType).getRange() : null;
    }

    @Contract(value="null -> null")
    public static Object computeValue(@Nullable PsiExpression expression2) {
        PsiExpression expressionToAnalyze = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (expressionToAnalyze == null) {
            return null;
        }
        Object computed = ExpressionUtils.computeConstantExpression(expressionToAnalyze);
        if (computed != null) {
            return computed;
        }
        return DfConstantType.getConstantOfType(CommonDataflow.getDfType(expressionToAnalyze), Object.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/CommonDataflow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runDFA";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CommonDataflowVisitor
    extends StandardInstructionVisitor {
        private DataflowResult myResult = new DataflowResult(RunnerResult.OK);
        private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();

        private CommonDataflowVisitor() {
        }

        @Override
        public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
            if (!instruction.isStatic()) {
                this.myEndOfInitializerStates.add(state.createCopy());
            }
            return super.visitEndOfInitializer(instruction, runner, state);
        }

        @Override
        protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
            if (value2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(2);
            }
            if (range == null) {
                this.myResult.add(expression2, state, value2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$CommonDataflowVisitor";
            objectArray[2] = "beforeExpressionPush";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DataflowResult {
        @NotNull
        private final Map<PsiExpression, DataflowPoint> myData = new HashMap<PsiExpression, DataflowPoint>();
        @NotNull
        private Map<PsiExpression, DataflowPoint> myDataAssertionsDisabled = this.myData;
        private final RunnerResult myResult;

        public DataflowResult(RunnerResult result) {
            this.myResult = result;
        }

        @NotNull
        DataflowResult copy() {
            DataflowResult copy = new DataflowResult(this.myResult);
            this.myData.forEach((expression2, point) -> copy.myData.put((PsiExpression)expression2, new DataflowPoint((DataflowPoint)point)));
            DataflowResult dataflowResult = copy;
            if (dataflowResult == null) {
                DataflowResult.$$$reportNull$$$0(0);
            }
            return dataflowResult;
        }

        void add(PsiExpression expression2, DfaMemoryState memState, DfaValue value2) {
            DfaVariableValue assertionDisabled = value2.getFactory().getAssertionDisabled();
            if (assertionDisabled == null) {
                assert (this.myData == this.myDataAssertionsDisabled);
                this.updateDataPoint(this.myData, expression2, memState, value2);
            } else {
                DfType type2 = memState.getDfType(assertionDisabled);
                if (type2 == DfTypes.TRUE || type2 == DfTypes.FALSE) {
                    if (this.myData == this.myDataAssertionsDisabled) {
                        this.myDataAssertionsDisabled = new HashMap<PsiExpression, DataflowPoint>(this.myData);
                    }
                    this.updateDataPoint(type2 == DfTypes.TRUE ? this.myDataAssertionsDisabled : this.myData, expression2, memState, value2);
                } else {
                    this.updateDataPoint(this.myData, expression2, memState, value2);
                    if (this.myData != this.myDataAssertionsDisabled) {
                        this.updateDataPoint(this.myDataAssertionsDisabled, expression2, memState, value2);
                    }
                }
            }
        }

        private void updateDataPoint(Map<PsiExpression, DataflowPoint> data, PsiExpression expression2, DfaMemoryState memState, DfaValue value2) {
            PsiElement parent;
            DataflowPoint point = data.computeIfAbsent(expression2, e -> new DataflowPoint());
            if (DfaTypeValue.isContractFail(value2)) {
                point.myMayFailByContract = true;
                return;
            }
            if (point.myDfType != DfTypes.TOP && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression2, (boolean)false)) {
                this.add((PsiExpression)parent, memState, value2);
            }
            point.addFacts(memState, value2);
            point.addValue(memState, value2);
        }

        public boolean expressionWasAnalyzed(PsiExpression expression2) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                throw new IllegalArgumentException("Should not pass parenthesized expression");
            }
            return this.myData.containsKey(expression2);
        }

        public boolean cannotFailByContract(PsiCallExpression call) {
            DataflowPoint point = this.myData.get(call);
            return point != null && !point.myMayFailByContract;
        }

        @NotNull
        public Set<Object> getExpressionValues(@Nullable PsiExpression expression2) {
            DataflowPoint point = this.myData.get(expression2);
            if (point == null) {
                Set<Object> set = Collections.emptySet();
                if (set == null) {
                    DataflowResult.$$$reportNull$$$0(1);
                }
                return set;
            }
            Set<Object> values = point.myPossibleValues;
            Set<Object> set = values == null ? Collections.emptySet() : Collections.unmodifiableSet(values);
            if (set == null) {
                DataflowResult.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public DfType getDfType(PsiExpression expression2) {
            DataflowPoint point = this.myData.get(expression2);
            DfType dfType = point == null ? DfTypes.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(3);
            }
            return dfType;
        }

        @NotNull
        public DfType getDfTypeNoAssertions(PsiExpression expression2) {
            DataflowPoint point = this.myDataAssertionsDisabled.get(expression2);
            DfType dfType = point == null ? DfTypes.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(4);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/CommonDataflow$DataflowResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionValues";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfTypeNoAssertions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DataflowPoint {
        @NotNull
        DfType myDfType = DfTypes.BOTTOM;
        @Nullable
        Set<Object> myPossibleValues = Collections.emptySet();
        boolean myMayFailByContract = false;

        DataflowPoint() {
        }

        DataflowPoint(DataflowPoint other) {
            this.myDfType = other.myDfType;
            this.myPossibleValues = other.myPossibleValues;
            this.myMayFailByContract = other.myMayFailByContract;
        }

        void addValue(DfaMemoryState memState, DfaValue value2) {
            if (this.myPossibleValues == null) {
                return;
            }
            DfType dfType = memState.getDfType(value2);
            if (!(dfType instanceof DfConstantType)) {
                this.myPossibleValues = null;
                return;
            }
            Object newValue = ((DfConstantType)dfType).getValue();
            if (this.myPossibleValues.contains(newValue)) {
                return;
            }
            if (this.myPossibleValues.isEmpty()) {
                this.myPossibleValues = Collections.singleton(newValue);
            } else {
                this.myPossibleValues = new HashSet<Object>(this.myPossibleValues);
                this.myPossibleValues.add(newValue);
            }
        }

        void addFacts(DfaMemoryState memState, DfaValue value2) {
            SpecialField field;
            if (this.myDfType == DfTypes.TOP) {
                return;
            }
            DfType newType = memState.getDfType(value2);
            if (value2 instanceof DfaVariableValue && (field = SpecialField.fromQualifier(value2)) != null && newType instanceof DfReferenceType) {
                DfaValue specialField = field.createValue(value2.getFactory(), value2);
                DfType withSpecialField = field.asDfType(memState.getDfType(specialField));
                newType = newType.meet(withSpecialField instanceof DfReferenceType ? ((DfReferenceType)withSpecialField).dropNullability() : withSpecialField);
            }
            this.myDfType = this.myDfType.join(newType);
        }
    }
}

