/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatingPointType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance(DfaMemoryStateImpl.class);
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final MyIdMap myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final DistinctPairSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfType> myVariableTypes;
    private boolean myEphemeral;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myEqClasses = new ArrayList<EqClass>();
        this.myVariableTypes = new LinkedHashMap();
        this.myDistinctClasses = new DistinctPairSet(this);
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap();
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new DistinctPairSet(this, toCopy.myDistinctClasses);
        this.myEqClasses = new ArrayList<EqClass>(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = (MyIdMap)toCopy.myIdToEqClassesIndices.clone();
        this.myVariableTypes = new LinkedHashMap<DfaVariableValue, DfType>(toCopy.myVariableTypes);
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        return new DfaMemoryStateImpl(this);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        this.forRecordedVariableTypes((value2, dfType) -> {
            if (dfType instanceof DfReferenceType) {
                copy.setDfType((DfaValue)value2, ((DfReferenceType)dfType).dropLocality());
            }
        });
        copy.flushFields();
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.myEphemeral == that.myEphemeral && this.myStack.equals(that.myStack) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs()) && this.myVariableTypes.equals(that.myVariableTypes);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    DistinctPairSet getDistinctClassPairs() {
        return this.myDistinctClasses;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet<EqClass> result = new LinkedHashSet<EqClass>();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = ((this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode()) * 31 + this.myVariableTypes.hashCode();
        this.myCachedHash = hash;
        return this.myCachedHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass set : this.getNonTrivialEqClasses()) {
            result.append(set);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of((Collection)this.getDistinctClassPairs()).map(DistinctPairSet.DistinctPair::toString).sorted()).joining((CharSequence)" ");
            result.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableTypes.isEmpty()) {
            result.append("\n  vars: ");
            this.myVariableTypes.forEach((key2, value2) -> result.append("[").append(key2).append("->").append(value2).append("] "));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    @NotNull
    public DfaValue pop() {
        this.myCachedHash = null;
        DfaValue dfaValue = (DfaValue)this.myStack.pop();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue peek() {
        DfaValue dfaValue = (DfaValue)this.myStack.peek();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @Override
    @Nullable
    public DfaValue getStackValue(int offset) {
        int index = this.myStack.size() - 1 - offset;
        return index < 0 ? null : (DfaValue)this.myStack.get(index);
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myCachedHash = null;
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleStackValueOnVariableFlush(value2, var, null);
        this.flushVariable(var, var.getInherentNullability() != Nullability.UNKNOWN);
        this.flushQualifiedMethods(var);
        if (DfaTypeValue.isUnknown(value2)) {
            this.recordVariableType(var, DfaMemoryStateImpl.withNotNull(this.getDfType(var)));
            return;
        }
        DfType dfType = this.filterDfTypeOnAssignment(var, this.getDfType(value2)).meet(var.getDfType());
        if (dfType == DfTypes.BOTTOM) {
            return;
        }
        if (!(!(value2 instanceof DfaVariableValue) || ControlFlowAnalyzer.isTempVariable(var) || ControlFlowAnalyzer.isTempVariable((DfaVariableValue)value2) || var.getQualifier() != null && ControlFlowAnalyzer.isTempVariable(var.getQualifier()))) {
            this.checkEphemeral(var, value2);
        }
        this.recordVariableType(var, dfType);
        this.applyRelation(var, value2, false);
        Couple<DfaValue> specialFields = this.getSpecialEquivalencePair(var, value2);
        if (specialFields != null && specialFields.getFirst() instanceof DfaVariableValue) {
            this.setVarValue((DfaVariableValue)specialFields.getFirst(), (DfaValue)specialFields.getSecond());
        }
    }

    protected DfType filterDfTypeOnAssignment(DfaVariableValue var, @NotNull DfType dfType) {
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        return dfType;
    }

    private DfaValue handleStackValueOnVariableFlush(DfaValue value2, DfaVariableValue flushed, DfaVariableValue replacement) {
        if (value2.dependsOn(flushed)) {
            DfaVariableValue target;
            DfType dfType = this.getDfType(value2);
            if (value2 instanceof DfaVariableValue && replacement != null && (target = DfaMemoryStateImpl.replaceQualifier((DfaVariableValue)value2, flushed, replacement)) != value2) {
                return target;
            }
            return this.myFactory.fromDfType(dfType);
        }
        return value2;
    }

    private int getOrCreateEqClassIndex(@NotNull DfaVariableValue dfaValue) {
        int i;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        if ((i = this.getEqClassIndex(dfaValue)) != -1) {
            return i;
        }
        dfaValue = this.canonicalize(dfaValue);
        EqClass eqClass = new EqClass(this.myFactory);
        eqClass.add(dfaValue.getID());
        int resultIndex = this.storeClass(eqClass);
        this.checkInvariants();
        return resultIndex;
    }

    private int storeClass(EqClass eqClass) {
        int resultIndex;
        int freeIndex = this.myEqClasses.indexOf(null);
        int n = resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, eqClass);
        } else {
            this.myEqClasses.add(eqClass);
        }
        eqClass.forEach(id -> {
            this.myIdToEqClassesIndices.put(id, resultIndex);
            return true;
        });
        return resultIndex;
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        DfType thatType;
        if (this.myEphemeral && !that.myEphemeral) {
            return false;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return false;
        }
        for (int i = 0; i < this.myStack.size(); ++i) {
            if (DfaMemoryStateImpl.isSuperValue((DfaValue)this.myStack.get(i), (DfaValue)that.myStack.get(i))) continue;
            return false;
        }
        int[] thisToThat = this.getClassesMap(that);
        if (thisToThat == null) {
            return false;
        }
        for (DistinctPairSet.DistinctPair distinctPair : this.myDistinctClasses) {
            int firstIndex = thisToThat[distinctPair.getFirstIndex()];
            int secondIndex = thisToThat[distinctPair.getSecondIndex()];
            if (firstIndex == -1 || secondIndex == -1 || firstIndex == secondIndex) {
                return false;
            }
            RelationType relation = that.myDistinctClasses.getRelation(firstIndex, secondIndex);
            if (relation != null && (!distinctPair.isOrdered() || relation == RelationType.LT)) continue;
            return false;
        }
        for (Map.Entry entry : this.myVariableTypes.entrySet()) {
            DfaVariableValue value2 = (DfaVariableValue)entry.getKey();
            DfType thisType = (DfType)entry.getValue();
            if (thisType.isMergeable(thatType = that.getDfType(value2))) continue;
            return false;
        }
        for (Map.Entry entry : that.myVariableTypes.entrySet()) {
            DfType thisType;
            DfaVariableValue value3 = (DfaVariableValue)entry.getKey();
            if (this.myVariableTypes.containsKey(value3) || (thisType = this.getDfType(value3)).isMergeable(thatType = (DfType)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private int @Nullable [] getClassesMap(DfaMemoryStateImpl that) {
        List<EqClass> thisClasses = this.myEqClasses;
        List<EqClass> thatClasses = that.myEqClasses;
        int thisSize = thisClasses.size();
        int thatSize = thatClasses.size();
        int[] thisToThat = new int[thisSize];
        for (int thisIdx = 0; thisIdx < thisSize; ++thisIdx) {
            EqClass thisClass = thisClasses.get(thisIdx);
            thisToThat[thisIdx] = -1;
            if (thisClass == null) continue;
            boolean found = false;
            for (int thatIdx = 0; thatIdx < thatSize; ++thatIdx) {
                EqClass thatClass = thatClasses.get(thatIdx);
                if (thatClass == null || !thatClass.containsAll(thisClass)) continue;
                thisToThat[thisIdx] = thatIdx;
                found = true;
                break;
            }
            if (found || thisClass.size() <= 1) continue;
            return null;
        }
        return thisToThat;
    }

    @Override
    public boolean shouldCompareByEquals(DfaValue dfaLeft, DfaValue dfaRight) {
        if (dfaLeft == dfaRight && !(dfaLeft instanceof DfaBoxedValue) && !(dfaLeft.getDfType() instanceof DfConstantType)) {
            return false;
        }
        return !this.isNull(dfaLeft) && !this.isNull(dfaRight) && TypeConstraint.fromDfType(this.getDfType(dfaLeft)).isComparedByEquals() && TypeConstraint.fromDfType(this.getDfType(dfaRight)).isComparedByEquals();
    }

    private static boolean isSuperValue(DfaValue superValue, DfaValue subValue) {
        if (DfaTypeValue.isUnknown(superValue) || superValue == subValue) {
            return true;
        }
        if (superValue instanceof DfaTypeValue && subValue instanceof DfaTypeValue) {
            return superValue.getDfType().isMergeable(subValue.getDfType());
        }
        return false;
    }

    List<EqClass> getEqClasses() {
        return this.myEqClasses;
    }

    @Nullable
    private EqClass getEqClass(DfaValue value2) {
        int index = this.getEqClassIndex(value2);
        return index == -1 ? null : this.myEqClasses.get(index);
    }

    int getEqClassIndex(@NotNull DfaValue dfaValue) {
        Integer classIndex;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(7);
        }
        if ((classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID())) == null) {
            dfaValue = this.canonicalize(dfaValue);
            classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID());
        }
        if (classIndex == null) {
            return -1;
        }
        EqClass aClass = this.myEqClasses.get(classIndex);
        assert (aClass.contains(dfaValue.getID()));
        return classIndex;
    }

    DfaVariableValue getCanonicalVariable(DfaValue val) {
        EqClass eqClass = this.getEqClass(val);
        return eqClass == null ? null : eqClass.getCanonicalVariable();
    }

    private boolean uniteClasses(DfaVariableValue val1, DfaVariableValue val2) {
        int c2Index;
        DfaVariableValue var1 = this.getCanonicalVariable(val1);
        DfaVariableValue var2 = this.getCanonicalVariable(val2);
        int c1Index = this.getOrCreateEqClassIndex(val1);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex(val2))) {
            return true;
        }
        if (!this.myDistinctClasses.unite(c1Index, c2Index)) {
            return false;
        }
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (int i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.myIdToEqClassesIndices.put(c, c1Index);
        }
        this.myEqClasses.set(c2Index, null);
        this.checkInvariants();
        if (var1 == null || var2 == null || var1 == var2) {
            return true;
        }
        int compare = EqClass.CANONICAL_VARIABLE_COMPARATOR.compare(var1, var2);
        return compare < 0 ? this.convertQualifiers(var2, var1) : this.convertQualifiers(var1, var2);
    }

    private static DfaVariableValue replaceQualifier(DfaVariableValue variable, DfaVariableValue from, DfaVariableValue to) {
        DfaVariableValue qualifier = variable.getQualifier();
        if (qualifier != null) {
            return variable.withQualifier(DfaMemoryStateImpl.replaceQualifier(qualifier == from ? to : qualifier, from, to));
        }
        return variable;
    }

    private boolean convertQualifiers(DfaVariableValue from, DfaVariableValue to) {
        assert (from != to);
        if (from.getDependentVariables().isEmpty()) {
            return true;
        }
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableTypes.keySet());
        for (DfaVariableValue var : vars) {
            DfType fromType;
            DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
            if (target == var || (fromType = (DfType)this.myVariableTypes.remove(var)) == null) continue;
            DfType toType = this.myVariableTypes.get(target);
            if (toType == null) {
                toType = fromType;
            } else if ((toType = fromType.meet(toType)) == DfTypes.BOTTOM) {
                return false;
            }
            this.recordVariableType(target, toType);
        }
        for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
            DfaValue value2 = this.myFactory.getValue((int)valueId);
            DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
            if (var == null || var.getQualifier() != from) continue;
            DfaVariableValue target = var.withQualifier(to);
            if (!this.uniteClasses(var, target)) {
                return false;
            }
            this.removeEquivalence(var);
        }
        return true;
    }

    private void checkInvariants() {
        if (!LOG.isDebugEnabled() && !ApplicationManager.getApplication().isEAP()) {
            return;
        }
        this.myIdToEqClassesIndices.forEachEntry((id, classIndex) -> {
            EqClass eqClass = this.myEqClasses.get((int)classIndex);
            if (eqClass == null || !eqClass.contains(id)) {
                LOG.error("Invariant violated: null-class for id=" + this.myFactory.getValue(id));
            }
            return true;
        });
        TIntObjectHashMap graph = new TIntObjectHashMap();
        for (DistinctPairSet.DistinctPair pair2 : this.myDistinctClasses) {
            if (pair2.isOrdered()) {
                BitSet set = (BitSet)graph.get(pair2.getFirstIndex());
                if (set == null) {
                    set = new BitSet();
                    graph.put(pair2.getFirstIndex(), (Object)set);
                }
                set.set(pair2.getSecondIndex());
            }
            pair2.check();
        }
        BitSet visited = new BitSet();
        BitSet stack = new BitSet();
        for (int v : graph.keys()) {
            if (!DfaMemoryStateImpl.isCycle(v, (TIntObjectHashMap<BitSet>)graph, visited, stack)) continue;
            throw new IllegalStateException("Cycle in distinct pairs involving " + this.myEqClasses.get(v));
        }
    }

    private static boolean isCycle(int v, TIntObjectHashMap<BitSet> graph, BitSet visited, BitSet stack) {
        if (!visited.get(v)) {
            visited.set(v);
            stack.set(v);
            BitSet set = (BitSet)graph.get(v);
            if (set != null && set.stream().anyMatch(i -> !visited.get(i) && DfaMemoryStateImpl.isCycle(i, graph, visited, stack) || stack.get(i))) {
                return true;
            }
        }
        stack.clear(v);
        return false;
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        return this.getDfType(dfaValue) == DfTypes.NULL;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        return !this.getDfType(dfaVar).isSuperType(DfTypes.NULL);
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean isEmptyStack() {
        return this.myStack.isEmpty();
    }

    private void convertReferenceEqualityToValueEquality(DfaValue value2) {
        int id = this.canonicalize(value2).getID();
        Integer index = (Integer)this.myIdToEqClassesIndices.get(id);
        if (index == null) {
            return;
        }
        Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
        while (iterator.hasNext()) {
            DistinctPairSet.DistinctPair pair2 = iterator.next();
            EqClass otherClass = pair2.getOtherClass(index);
            if (otherClass == null || this.isNull(otherClass.getVariable(0))) continue;
            iterator.remove();
        }
    }

    @Override
    public void setDfType(@NotNull DfaValue value2, @NotNull DfType dfType) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(9);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value2;
            DfType type2 = this.getDfType(var);
            if (DfaNullability.fromDfType(type2) != DfaNullability.fromDfType(dfType)) {
                this.removeEquivalence(var);
            }
            this.recordVariableType(var, dfType);
        }
    }

    @NotNull
    private static DfType sanitizeNullability(@NotNull DfType dfType) {
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        if (!(dfType instanceof DfReferenceType)) {
            DfType dfType2 = dfType;
            if (dfType2 == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(11);
            }
            return dfType2;
        }
        DfaNullability nullability = ((DfReferenceType)dfType).getNullability();
        if (nullability == DfaNullability.NULLABLE) {
            DfReferenceType dfReferenceType = ((DfReferenceType)dfType).dropNullability();
            if (dfReferenceType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(12);
            }
            return dfReferenceType;
        }
        DfType dfType3 = dfType;
        if (dfType3 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        return dfType3;
    }

    @Override
    public boolean meetDfType(@NotNull DfaValue value2, @NotNull DfType dfType) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        if (dfType == DfTypes.TOP) {
            return true;
        }
        if (dfType == DfTypes.BOTTOM) {
            return false;
        }
        if (value2 instanceof DfaBinOpValue) {
            return this.propagateRangeBack(DfLongType.extractRange(dfType), (DfaBinOpValue)value2);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value2;
            DfType type2 = this.getDfType(var);
            DfType result = type2.meet(dfType);
            if (result.equals(type2)) {
                return true;
            }
            if (result == DfTypes.BOTTOM) {
                return false;
            }
            this.recordVariableType(var, result);
            TypeConstraint newConstraint = TypeConstraint.fromDfType(result);
            if (newConstraint.isComparedByEquals() && !newConstraint.equals(TypeConstraint.fromDfType(type2))) {
                this.convertReferenceEqualityToValueEquality(value2);
            }
            this.updateEquivalentVariables(var, result);
            if (result instanceof DfConstantType && !this.propagateConstant(var, (DfConstantType)result)) {
                return false;
            }
            if (result instanceof DfAntiConstantType) {
                for (Object notValue : ((DfAntiConstantType)result).getNotValues()) {
                    if (!(notValue instanceof PsiType) || this.processGetClass(var, (PsiType)notValue, true)) continue;
                    return false;
                }
            }
            return !(result instanceof DfIntegralType) || this.applyRangeToRelatedValues(var, ((DfIntegralType)result).getRange());
        }
        return value2.getDfType().meet(dfType) != DfTypes.BOTTOM;
    }

    private boolean propagateRangeBack(@NotNull LongRangeSet factValue, @NotNull DfaBinOpValue binOp) {
        boolean isLong;
        if (factValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        if (binOp == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        LongRangeSet appliedRange = (isLong = PsiType.LONG.equals((Object)binOp.getType())) ? factValue : factValue.intersect(Objects.requireNonNull(LongRangeSet.fromType((PsiType)PsiType.INT)));
        DfaVariableValue left = binOp.getLeft();
        DfaValue right = binOp.getRight();
        DfIntegralType leftDfType = (DfIntegralType)ObjectUtils.tryCast((Object)this.getDfType(left), DfIntegralType.class);
        DfIntegralType rightDfType = (DfIntegralType)ObjectUtils.tryCast((Object)this.getDfType(right), DfIntegralType.class);
        if (leftDfType == null || rightDfType == null) {
            return true;
        }
        LongRangeSet leftRange = leftDfType.getRange();
        LongRangeSet rightRange = rightDfType.getRange();
        LongRangeSet result = this.getBinOpRange(binOp);
        assert (result != null);
        if (!result.intersects(appliedRange)) {
            return false;
        }
        LongRangeSet leftConstraint = LongRangeSet.all();
        LongRangeSet rightConstraint = LongRangeSet.all();
        switch (binOp.getOperation()) {
            case PLUS: {
                leftConstraint = appliedRange.minus(rightRange, isLong);
                rightConstraint = appliedRange.minus(leftRange, isLong);
                break;
            }
            case MINUS: {
                leftConstraint = rightRange.plus(appliedRange, isLong);
                rightConstraint = leftRange.minus(appliedRange, isLong);
                break;
            }
            case REM: {
                Long value2 = rightRange.getConstantValue();
                if (value2 == null) break;
                leftConstraint = LongRangeSet.fromRemainder(value2, appliedRange.intersect(result));
            }
        }
        return this.meetDfType(left, leftDfType.meetRange(leftConstraint)) && this.meetDfType(right, rightDfType.meetRange(rightConstraint));
    }

    @Override
    public boolean applyContractCondition(DfaCondition condition2) {
        DfaRelation relation;
        if (condition2 instanceof DfaRelation && (relation = (DfaRelation)condition2).isEquality()) {
            this.checkEphemeral(relation.getLeftOperand(), relation.getRightOperand());
        }
        return this.applyCondition(condition2);
    }

    @Override
    public boolean areEqual(@NotNull DfaValue value1, @NotNull DfaValue value2) {
        if (value1 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (value1 instanceof DfaBinOpValue && value2 instanceof DfaBinOpValue) {
            DfaBinOpValue binOp1 = (DfaBinOpValue)value1;
            DfaBinOpValue binOp2 = (DfaBinOpValue)value2;
            return binOp1.getOperation() == binOp2.getOperation() && this.areEqual(binOp1.getLeft(), binOp2.getLeft()) && this.areEqual(binOp1.getRight(), binOp2.getRight());
        }
        DfType dfType1 = this.getDfType(value1);
        DfType dfType2 = this.getDfType(value2);
        if (dfType1 instanceof DfConstantType && dfType2 instanceof DfConstantType && dfType1.equals(dfType2)) {
            return true;
        }
        if (!(value1 instanceof DfaVariableValue)) {
            return false;
        }
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        int index1 = this.getEqClassIndex(value1);
        int index2 = this.getEqClassIndex(value2);
        return index1 != -1 && index1 == index2;
    }

    @Override
    @Nullable
    public RelationType getRelation(DfaValue left, DfaValue right) {
        int leftClass = this.getEqClassIndex(left);
        int rightClass = this.getEqClassIndex(right);
        if (leftClass == -1 || rightClass == -1) {
            return null;
        }
        if (leftClass == rightClass) {
            return RelationType.EQ;
        }
        return this.myDistinctClasses.getRelation(leftClass, rightClass);
    }

    @Override
    public boolean applyCondition(DfaCondition dfaCond) {
        if (!(dfaCond instanceof DfaRelation)) {
            return dfaCond != DfaCondition.getFalse();
        }
        return this.applyRelationCondition((DfaRelation)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelation dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        RelationType relationType = dfaRelation.getRelation();
        if (DfaTypeValue.isUnknown(dfaLeft) || DfaTypeValue.isUnknown(dfaRight)) {
            return true;
        }
        DfType leftType = this.getDfType(dfaLeft);
        DfType rightType = this.getDfType(dfaRight);
        if (leftType instanceof DfIntegralType && rightType instanceof DfIntegralType && relationType.getFlipped() != null) {
            if (!this.meetDfType(dfaLeft, ((DfIntegralType)leftType).meetRelation(relationType, rightType)) || !this.meetDfType(dfaRight, ((DfIntegralType)rightType).meetRelation(relationType.getFlipped(), leftType))) {
                return false;
            }
            if (!this.applyBinOpRelations(dfaLeft, relationType, dfaRight)) {
                return false;
            }
            if (!(dfaRight instanceof DfaVariableValue)) {
                return true;
            }
            return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
        }
        if (leftType instanceof DfFloatingPointType && rightType instanceof DfFloatingPointType && relationType.getFlipped() != null) {
            if (DfaMemoryStateImpl.isNaN(leftType) || DfaMemoryStateImpl.isNaN(rightType)) {
                this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
                return relationType == RelationType.NE;
            }
            RelationType constantRelation = DfaMemoryStateImpl.getFloatingConstantRelation(leftType, rightType);
            if (constantRelation != null) {
                return relationType.isSubRelation(constantRelation);
            }
            if (DfaMemoryStateImpl.canBeNaN(leftType) || DfaMemoryStateImpl.canBeNaN(rightType)) {
                if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(dfaLeft.getType() instanceof PsiPrimitiveType)) {
                    return !dfaRelation.isNonEquality();
                }
                this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
                return true;
            }
            return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
        }
        if (dfaRight instanceof DfaTypeValue) {
            if ((relationType == RelationType.EQ || relationType.isInequality()) && !this.applyUnboxedRelation(dfaLeft, dfaRight, relationType.isInequality())) {
                return false;
            }
            if (relationType == RelationType.EQ && !this.applySpecialFieldEquivalence(dfaLeft, dfaRight)) {
                return false;
            }
            if (relationType == RelationType.IS || relationType == RelationType.EQ) {
                return this.meetDfType(dfaLeft, DfaMemoryStateImpl.sanitizeNullability(rightType));
            }
            if (relationType == RelationType.IS_NOT || relationType == RelationType.NE && rightType instanceof DfConstantType) {
                if (rightType.isSuperType(leftType)) {
                    return false;
                }
                DfType antiType = rightType.tryNegate();
                if (antiType != null && !this.meetDfType(dfaLeft, antiType)) {
                    return leftType.meet(rightType) == DfTypes.BOTTOM;
                }
            }
            return true;
        }
        return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
    }

    private boolean applyBinOpRelations(DfaValue left, RelationType type2, DfaValue right) {
        if (type2 != RelationType.LT && type2 != RelationType.GT && type2 != RelationType.NE && type2 != RelationType.EQ) {
            return true;
        }
        if (left instanceof DfaBinOpValue) {
            DfaBinOpValue sum = (DfaBinOpValue)left;
            DfaBinOpValue.BinOp op = sum.getOperation();
            if (op != DfaBinOpValue.BinOp.PLUS && op != DfaBinOpValue.BinOp.MINUS) {
                return true;
            }
            LongRangeSet leftRange = DfLongType.extractRange(this.getDfType(sum.getLeft()));
            LongRangeSet rightRange = DfLongType.extractRange(this.getDfType(sum.getRight()));
            boolean isLong = PsiType.LONG.equals((Object)sum.getType());
            LongRangeSet rightNegated = rightRange.negate(isLong);
            LongRangeSet rightCorrected = op == DfaBinOpValue.BinOp.MINUS ? rightNegated : rightRange;
            LongRangeSet resultRange = DfLongType.extractRange(this.getDfType(right));
            RelationType correctedRelation = DfaMemoryStateImpl.correctRelation(type2, leftRange, rightCorrected, resultRange, isLong);
            if (op == DfaBinOpValue.BinOp.MINUS) {
                long min = resultRange.min();
                long max = resultRange.max();
                if (min == 0L && max == 0L) {
                    if (!this.applyCondition(sum.getLeft().cond(correctedRelation, sum.getRight()))) {
                        return false;
                    }
                } else if (min == 0L && type2 == RelationType.GT || min >= 1L && RelationType.GE.isSubRelation(type2)) {
                    RelationType correctedGt = DfaMemoryStateImpl.correctRelation(RelationType.GT, leftRange, rightCorrected, resultRange, isLong);
                    if (!this.applyCondition(sum.getLeft().cond(correctedGt, sum.getRight()))) {
                        return false;
                    }
                } else if (max == 0L && type2 == RelationType.LT || max <= -1L && RelationType.LE.isSubRelation(type2)) {
                    RelationType correctedLt = DfaMemoryStateImpl.correctRelation(RelationType.LT, leftRange, rightCorrected, resultRange, isLong);
                    if (!this.applyCondition(sum.getLeft().cond(correctedLt, sum.getRight()))) {
                        return false;
                    }
                }
                if (RelationType.EQ.equals((Object)type2) && !resultRange.contains(0L) && !this.applyRelation(sum.getLeft(), sum.getRight(), true)) {
                    return false;
                }
            }
            if (op == DfaBinOpValue.BinOp.PLUS && RelationType.EQ == type2 && !resultRange.intersects(LongRangeSet.all().mul(LongRangeSet.point(2L), true)) && !this.applyRelation(sum.getLeft(), sum.getRight(), true)) {
                return false;
            }
            if (right instanceof DfaVariableValue) {
                if (this.areEqual(sum.getLeft(), right)) {
                    RelationType finalRelation;
                    RelationType relationType = finalRelation = op == DfaBinOpValue.BinOp.MINUS ? Objects.requireNonNull(correctedRelation.getFlipped()) : correctedRelation;
                    if (!this.applyCondition(sum.getRight().cond(finalRelation, this.myFactory.getInt(0)))) {
                        return false;
                    }
                }
                if (op == DfaBinOpValue.BinOp.PLUS && this.areEqual(sum.getRight(), right) && !this.applyCondition(sum.getLeft().cond(correctedRelation, this.myFactory.getInt(0)))) {
                    return false;
                }
                if (!leftRange.subtractionMayOverflow(op == DfaBinOpValue.BinOp.MINUS ? rightRange : rightNegated, isLong)) {
                    if (rightCorrected.max() < 0L && RelationType.GE.isSubRelation(type2) && !this.applyLessThanRelation(right, sum.getLeft())) {
                        return false;
                    }
                    if (rightCorrected.min() > 0L && RelationType.LE.isSubRelation(type2) && !this.applyLessThanRelation(sum.getLeft(), right)) {
                        return false;
                    }
                }
                if (RelationType.EQ == type2 && !rightRange.contains(0L) && !this.applyRelation(sum.getLeft(), right, true)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static RelationType correctRelation(RelationType relation, LongRangeSet summand1, LongRangeSet summand2, LongRangeSet resultRange, boolean isLong) {
        if (relation != RelationType.LT && relation != RelationType.GT) {
            return relation;
        }
        boolean overflowPossible = true;
        if (!isLong) {
            LongRangeSet overflowRange = DfaMemoryStateImpl.getIntegerSumOverflowValues(summand1, summand2);
            overflowPossible = !overflowRange.isEmpty() && (resultRange == null || resultRange.fromRelation(relation).intersects(overflowRange));
        }
        return overflowPossible ? RelationType.NE : relation;
    }

    @NotNull
    private static LongRangeSet getIntegerSumOverflowValues(LongRangeSet left, LongRangeSet right) {
        if (left.isEmpty() || right.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(21);
            }
            return longRangeSet;
        }
        long sumMin = left.min() + right.min();
        long sumMax = left.max() + right.max();
        LongRangeSet result = LongRangeSet.empty();
        if (sumMin < Integer.MIN_VALUE) {
            result = result.unite(LongRangeSet.range((int)sumMin, Integer.MAX_VALUE));
        }
        if (sumMax > Integer.MAX_VALUE) {
            result = result.unite(LongRangeSet.range(Integer.MIN_VALUE, (int)sumMax));
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        return longRangeSet;
    }

    private boolean applyEquivalenceRelation(RelationType type2, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean isNegated;
        RelationType currentRelation = this.getRelation(dfaLeft, dfaRight);
        if (currentRelation != null && (type2 = type2.meet(currentRelation)) == null) {
            return false;
        }
        boolean bl = isNegated = type2 == RelationType.NE || type2 == RelationType.GT || type2 == RelationType.LT;
        if (!isNegated && type2 != RelationType.EQ) {
            return true;
        }
        DfType leftType = this.getDfType(dfaLeft);
        DfType rightType = this.getDfType(dfaRight);
        if (type2 == RelationType.EQ) {
            if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
                this.checkEphemeral(dfaLeft, dfaRight);
                this.checkEphemeral(dfaRight, dfaLeft);
            }
            if (!this.meetDfType(dfaLeft, DfaMemoryStateImpl.sanitizeNullability(rightType))) {
                return false;
            }
            if (!this.meetDfType(dfaRight, DfaMemoryStateImpl.sanitizeNullability(leftType))) {
                return false;
            }
            if (!this.applySpecialFieldEquivalence(dfaLeft, dfaRight)) {
                return false;
            }
        } else {
            DfType antiType;
            if (leftType instanceof DfConstantType && (antiType = leftType.tryNegate()) != null && !this.meetDfType(dfaRight, antiType)) {
                return false;
            }
            if (rightType instanceof DfConstantType && (antiType = rightType.tryNegate()) != null && !this.meetDfType(dfaLeft, antiType)) {
                return false;
            }
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue && !isNegated && !this.equalizeTypesOnGetClass((DfaVariableValue)dfaLeft, (DfaVariableValue)dfaRight)) {
            return false;
        }
        if (dfaLeft == dfaRight) {
            return !isNegated || dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue && (type2 == RelationType.LT ? !this.applyLessThanRelation(dfaLeft, dfaRight) : (type2 == RelationType.GT ? !this.applyLessThanRelation(dfaRight, dfaLeft) : !this.applyRelation(dfaLeft, dfaRight, isNegated)))) {
            return false;
        }
        return this.applyUnboxedRelation(dfaLeft, dfaRight, isNegated);
    }

    private void checkEphemeral(DfaValue left, DfaValue right) {
        DfaNullability nullability;
        if (this.getDfType(right) == DfTypes.NULL && ((nullability = DfaNullability.fromDfType(this.getDfType(left))) == DfaNullability.UNKNOWN || nullability == DfaNullability.FLUSHED)) {
            this.markEphemeral();
        }
    }

    private boolean equalizeTypesOnGetClass(DfaVariableValue dfaLeft, DfaVariableValue dfaRight) {
        PsiModifierListOwner rightPsi;
        PsiModifierListOwner leftPsi = dfaLeft.getPsiVariable();
        if (leftPsi != (rightPsi = dfaRight.getPsiVariable()) || !(leftPsi instanceof PsiMethod) || !PsiTypesUtil.isGetClass((PsiMethod)((PsiMethod)leftPsi))) {
            return true;
        }
        DfaVariableValue leftQualifier = dfaLeft.getQualifier();
        DfaVariableValue rightQualifier = dfaRight.getQualifier();
        if (leftQualifier == null || rightQualifier == null || leftQualifier == rightQualifier) {
            return true;
        }
        TypeConstraint leftType = TypeConstraint.fromDfType(this.getDfType(leftQualifier));
        TypeConstraint rightType = TypeConstraint.fromDfType(this.getDfType(rightQualifier));
        return this.meetDfType(leftQualifier, rightType.asDfType()) && this.meetDfType(rightQualifier, leftType.asDfType());
    }

    private boolean processGetClass(DfaVariableValue variable, PsiType value2, boolean negated) {
        EqClass eqClass = this.getEqClass(variable);
        List<DfaVariableValue> variables = eqClass == null ? Collections.singletonList(variable) : eqClass.asList();
        for (DfaVariableValue var : variables) {
            DfaTypeValue typeValue;
            PsiModifierListOwner psi = var.getPsiVariable();
            DfaVariableValue qualifier = var.getQualifier();
            if (qualifier == null || !(psi instanceof PsiMethod) || !PsiTypesUtil.isGetClass((PsiMethod)((PsiMethod)psi)) || this.applyCondition(qualifier.cond(negated ? RelationType.IS_NOT : RelationType.IS, typeValue = this.getFactory().fromDfType(TypeConstraints.exact(value2).asDfType())))) continue;
            return false;
        }
        return true;
    }

    private boolean propagateConstant(DfaVariableValue value2, DfConstantType<?> constant) {
        if (constant.getValue() instanceof PsiType && !this.processGetClass(value2, (PsiType)constant.getValue(), false)) {
            return false;
        }
        SpecialField field = SpecialField.fromQualifierType(constant.getPsiType());
        if (field != null && !this.meetDfType(field.createValue(this.getFactory(), value2), field.fromConstant(constant.getValue()))) {
            return false;
        }
        DfType dfType = constant.tryNegate();
        if (dfType == null) {
            return true;
        }
        EqClass eqClass = this.getEqClass(value2);
        if (eqClass == null) {
            return true;
        }
        for (DistinctPairSet.DistinctPair pair2 : this.getDistinctClassPairs().toArray(new DistinctPairSet.DistinctPair[0])) {
            EqClass other;
            EqClass eqClass2 = pair2.getFirst() == eqClass ? pair2.getSecond() : (other = pair2.getSecond() == eqClass ? pair2.getFirst() : null);
            if (other == null) continue;
            for (DfaVariableValue var : other.asList()) {
                if (this.meetDfType(var, dfType)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean applyRangeToRelatedValues(DfaValue value2, LongRangeSet appliedRange) {
        EqClass eqClass = this.getEqClass(value2);
        if (eqClass == null) {
            return true;
        }
        for (DistinctPairSet.DistinctPair pair2 : this.getDistinctClassPairs().toArray(new DistinctPairSet.DistinctPair[0])) {
            if (!pair2.isOrdered() || !(pair2.getFirst() == eqClass ? !this.applyRelationRangeToClass(pair2.getSecond(), appliedRange, RelationType.GT) : pair2.getSecond() == eqClass && !this.applyRelationRangeToClass(pair2.getFirst(), appliedRange, RelationType.LT))) continue;
            return false;
        }
        return true;
    }

    private boolean applyRelationRangeToClass(EqClass eqClass, LongRangeSet range, RelationType relationType) {
        LongRangeSet appliedRange = range.fromRelation(relationType);
        for (DfaVariableValue var : eqClass.asList()) {
            DfType rangeType;
            if (this.meetDfType(var, rangeType = DfTypes.rangeClamped(appliedRange, PsiType.LONG.equals((Object)var.getType())))) continue;
            return false;
        }
        return true;
    }

    private Couple<DfaValue> getSpecialEquivalencePair(DfaVariableValue left, DfaValue right) {
        if (right instanceof DfaVariableValue) {
            return null;
        }
        SpecialField field = SpecialField.fromQualifier(left);
        if (field == null) {
            return null;
        }
        DfaValue leftValue = field.createValue(this.myFactory, left);
        DfaValue rightValue = field.createValue(this.myFactory, right);
        return Couple.of((Object)leftValue, (Object)rightValue);
    }

    private boolean applySpecialFieldEquivalence(@NotNull DfaValue left, @NotNull DfaValue right) {
        Couple<DfaValue> pair2;
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        if (right == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(24);
        }
        Couple<DfaValue> couple = left instanceof DfaVariableValue ? this.getSpecialEquivalencePair((DfaVariableValue)left, right) : (pair2 = right instanceof DfaVariableValue ? this.getSpecialEquivalencePair((DfaVariableValue)right, left) : null);
        if (pair2 == null || DfaMemoryStateImpl.isNaN((DfaValue)pair2.getFirst()) || DfaMemoryStateImpl.isNaN((DfaValue)pair2.getSecond())) {
            return true;
        }
        return this.applyCondition(((DfaValue)pair2.getFirst()).eq((DfaValue)pair2.getSecond()));
    }

    private boolean applyUnboxedRelation(@NotNull DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        if (dfaLeft instanceof DfaVariableValue && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaLeft.getType()) || dfaRight instanceof DfaVariableValue && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaRight.getType())) {
            return true;
        }
        PsiType leftType = this.getPsiType(dfaLeft);
        PsiType rightType = this.getPsiType(dfaRight);
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)leftType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)rightType) && !leftType.equals(rightType)) {
            return negated;
        }
        DfaValue unboxedLeft = SpecialField.UNBOX.createValue(this.myFactory, dfaLeft);
        DfaValue unboxedRight = SpecialField.UNBOX.createValue(this.myFactory, dfaRight);
        DfType leftDfType = this.getDfType(unboxedLeft);
        DfType rightDfType = this.getDfType(unboxedRight);
        if (leftDfType instanceof DfConstantType && rightDfType instanceof DfConstantType) {
            return leftDfType.equals(rightDfType) != negated;
        }
        if (negated && (PsiType.FLOAT.equals((Object)unboxedLeft.getType()) || PsiType.DOUBLE.equals((Object)unboxedLeft.getType()))) {
            return true;
        }
        return this.applyRelation(unboxedLeft, unboxedRight, negated);
    }

    @Override
    @Nullable
    public PsiType getPsiType(@NotNull DfaValue value2) {
        PsiType type2;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        return (type2 = DfaTypeValue.toPsiType(this.getFactory().getProject(), this.getDfType(value2))) == null ? value2.getType() : type2;
    }

    private static boolean isNaN(DfaValue dfa) {
        return dfa != null && DfaMemoryStateImpl.isNaN(dfa.getDfType());
    }

    private static boolean canBeNaN(@NotNull DfType dfType) {
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        return dfType.isSuperType(DfTypes.floatValue(Float.NaN)) || dfType.isSuperType(DfTypes.doubleValue(Double.NaN));
    }

    private static boolean isNaN(DfType type2) {
        return type2 instanceof DfConstantType && DfaUtil.isNaN(((DfConstantType)type2).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        int c2Index;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        if (!(dfaLeft instanceof DfaVariableValue) || !(dfaRight instanceof DfaVariableValue)) {
            return true;
        }
        int c1Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaLeft);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaRight))) {
            return !isNegated;
        }
        if (!isNegated) {
            if (this.isUnstableValue(dfaLeft) || this.isUnstableValue(dfaRight)) {
                return true;
            }
            if (!this.uniteClasses((DfaVariableValue)dfaLeft, (DfaVariableValue)dfaRight)) {
                return false;
            }
        } else {
            this.myDistinctClasses.addUnordered(c1Index, c2Index);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
        return true;
    }

    private boolean applyLessThanRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        int c2Index;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(30);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(31);
        }
        if (!(dfaLeft instanceof DfaVariableValue) || !(dfaRight instanceof DfaVariableValue)) {
            return true;
        }
        int c1Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaLeft);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaRight))) {
            return false;
        }
        this.myCachedHash = null;
        return this.myDistinctClasses.addOrdered(c1Index, c2Index);
    }

    private boolean isUnstableValue(DfaValue value2) {
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        PsiModifierListOwner owner2 = var.getPsiVariable();
        if (!(owner2 instanceof PsiMethod)) {
            return false;
        }
        if (var.getType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)owner2))) {
            return false;
        }
        return !this.isNull(var);
    }

    @Nullable
    private static RelationType getFloatingConstantRelation(DfType leftType, DfType rightType) {
        Number value1 = DfConstantType.getConstantOfType(leftType, Number.class);
        Number value2 = DfConstantType.getConstantOfType(rightType, Number.class);
        if (value1 == null || value2 == null) {
            return null;
        }
        double double1 = value1.doubleValue();
        double double2 = value2.doubleValue();
        if (double1 == 0.0 && double2 == 0.0) {
            return RelationType.EQ;
        }
        int cmp = Double.compare(double1, double2);
        return cmp == 0 ? RelationType.EQ : (cmp < 0 ? RelationType.LT : RelationType.GT);
    }

    @Override
    public boolean checkNotNullable(@NotNull DfaValue value2) {
        DfaNullability nullability;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(32);
        }
        return (nullability = DfaNullability.fromDfType(this.getDfType(value2))) != DfaNullability.NULL && nullability != DfaNullability.NULLABLE;
    }

    @Nullable
    public LongRangeSet getBinOpRange(DfaBinOpValue binOp) {
        LongRangeSet left = DfLongType.extractRange(this.getDfType(binOp.getLeft()));
        LongRangeSet right = DfLongType.extractRange(this.getDfType(binOp.getRight()));
        boolean isLong = PsiType.LONG.equals((Object)binOp.getType());
        LongRangeSet result = left.binOpFromToken(binOp.getTokenType(), right, isLong);
        if (result != null && binOp.getOperation() == DfaBinOpValue.BinOp.MINUS) {
            RelationType rel = this.getRelation(binOp.getLeft(), binOp.getRight());
            if (rel == RelationType.NE) {
                return result.without(0L);
            }
            if (!left.subtractionMayOverflow(right, isLong)) {
                if (rel == RelationType.GT) {
                    return result.intersect(LongRangeSet.range(1L, isLong ? Long.MAX_VALUE : Integer.MAX_VALUE));
                }
                if (rel == RelationType.LT) {
                    return result.intersect(LongRangeSet.range(isLong ? Long.MIN_VALUE : Integer.MIN_VALUE, -1L));
                }
            }
        }
        if (binOp.getOperation() == DfaBinOpValue.BinOp.PLUS && this.areEqual(binOp.getLeft(), binOp.getRight())) {
            return LongRangeSet.point(2L).mul(left, isLong);
        }
        return result;
    }

    @Override
    @NotNull
    public DfType getUnboxedDfType(@NotNull DfaValue value2) {
        DfReferenceType refType;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(33);
        }
        if (value2 instanceof DfaBoxedValue) {
            DfType dfType = this.getDfType(((DfaBoxedValue)value2).getWrappedValue());
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(34);
            }
            return dfType;
        }
        if (value2 instanceof DfaVariableValue && TypeConversionUtil.isPrimitiveWrapper((PsiType)value2.getType())) {
            DfType dfType = this.getDfType(SpecialField.UNBOX.createValue(this.myFactory, value2));
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(35);
            }
            return dfType;
        }
        if (value2 instanceof DfaTypeValue && (refType = (DfReferenceType)ObjectUtils.tryCast((Object)value2.getDfType(), DfReferenceType.class)) != null && refType.getSpecialField() == SpecialField.UNBOX) {
            DfType dfType = refType.getSpecialFieldType();
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(36);
            }
            return dfType;
        }
        DfType dfType = this.getDfType(value2);
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(37);
        }
        return dfType;
    }

    @Override
    @NotNull
    public DfType getDfType(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(38);
        }
        if (value2 instanceof DfaBinOpValue) {
            LongRangeSet range = this.getBinOpRange((DfaBinOpValue)value2);
            if (range == null) {
                range = LongRangeSet.all();
            }
            DfType dfType = ((DfaBinOpValue)value2).getDfType().meetRange(range);
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(39);
            }
            return dfType;
        }
        if (value2 instanceof DfaVariableValue) {
            DfType type2 = this.getRecordedType((DfaVariableValue)value2);
            DfType dfType = type2 != null ? type2 : ((DfaVariableValue)value2).getInherentType();
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(40);
            }
            return dfType;
        }
        DfType dfType = value2.getDfType();
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(41);
        }
        return dfType;
    }

    void recordVariableType(@NotNull DfaVariableValue dfaVar, @NotNull DfType type2) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(42);
        }
        if (type2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(43);
        }
        dfaVar = this.canonicalize(dfaVar);
        if (type2 instanceof DfReferenceType) {
            type2 = ((DfReferenceType)type2).dropSpecialField();
        }
        if (type2.equals(dfaVar.getInherentType())) {
            this.myVariableTypes.remove(dfaVar);
        } else {
            this.myVariableTypes.put(dfaVar, type2);
        }
        this.myCachedHash = null;
    }

    protected void updateEquivalentVariables(DfaVariableValue dfaVar, DfType type2) {
        EqClass eqClass = this.getEqClass(dfaVar);
        if (eqClass != null) {
            for (DfaVariableValue value2 : eqClass.asList()) {
                if (value2 == dfaVar) continue;
                this.recordVariableType(value2, type2);
            }
        }
    }

    @NotNull
    private DfaValue canonicalize(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(44);
        }
        if (value2 instanceof DfaVariableValue) {
            return this.canonicalize((DfaVariableValue)value2);
        }
        if (value2 instanceof DfaBoxedValue) {
            DfaBoxedValue boxedValue = (DfaBoxedValue)value2;
            DfaVariableValue canonicalized = this.canonicalize(boxedValue.getWrappedValue());
            DfaValue dfaValue = Objects.requireNonNull(this.myFactory.getBoxedFactory().createBoxed(canonicalized, boxedValue.getType()));
            if (dfaValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(45);
            }
            return dfaValue;
        }
        DfaValue dfaValue = value2;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(46);
        }
        return dfaValue;
    }

    @NotNull
    private DfaVariableValue canonicalize(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            Integer index = (Integer)this.myIdToEqClassesIndices.get(qualifier.getID());
            if (index == null && (index = (Integer)this.myIdToEqClassesIndices.get((qualifier = this.canonicalize(qualifier)).getID())) == null) {
                DfaVariableValue dfaVariableValue = var.withQualifier(qualifier);
                if (dfaVariableValue == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(47);
                }
                return dfaVariableValue;
            }
            DfaVariableValue dfaVariableValue = var.withQualifier(Objects.requireNonNull(this.myEqClasses.get(index).getCanonicalVariable()));
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(48);
            }
            return dfaVariableValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(49);
        }
        return dfaVariableValue;
    }

    private DfType getRecordedType(DfaVariableValue var) {
        DfType type2 = this.myVariableTypes.get(var);
        if (type2 != null) {
            return type2;
        }
        DfaVariableValue canonicalized = this.canonicalize(var);
        return canonicalized == var ? null : this.myVariableTypes.get(canonicalized);
    }

    public void forRecordedVariableTypes(BiConsumer<? super DfaVariableValue, ? super DfType> consumer) {
        this.myVariableTypes.forEach(consumer);
    }

    @Override
    public void flushFieldsQualifiedBy(@NotNull Set<DfaValue> qualifiers) {
        if (qualifiers == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(50);
        }
        this.flushFields(new QualifierStatusMap(qualifiers));
    }

    @Override
    public void flushFields() {
        this.flushFields(new QualifierStatusMap(null));
    }

    public void flushFields(@NotNull QualifierStatusMap qualifierStatusMap) {
        if (qualifierStatusMap == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(51);
        }
        LinkedHashSet<DfaVariableValue> vars = new LinkedHashSet<DfaVariableValue>();
        for (DfaVariableValue value2 : this.myVariableTypes.keySet()) {
            if (!value2.isFlushableByCalls() || !qualifierStatusMap.shouldFlush(value2.getQualifier(), value2.containsCalls())) continue;
            vars.add(value2);
        }
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            for (DfaVariableValue value3 : aClass) {
                if (!value3.isFlushableByCalls() || !qualifierStatusMap.shouldFlush(value3.getQualifier(), value3.containsCalls())) continue;
                vars.add(value3);
            }
        }
        for (DfaVariableValue value2 : vars) {
            this.doFlush(value2, this.shouldMarkFlushed(value2));
        }
        this.myStack.replaceAll(val -> {
            SpecialField field;
            DfType type2 = val.getDfType();
            if (type2 instanceof DfReferenceType && (field = ((DfReferenceType)type2).getSpecialField()) != null && !field.isStable() && qualifierStatusMap.shouldFlush((DfaValue)val, field.isCall())) {
                return this.myFactory.fromDfType(((DfReferenceType)type2).dropSpecialField());
            }
            return val;
        });
    }

    private boolean shouldMarkFlushed(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(52);
        }
        if (value2.getInherentNullability() != Nullability.NULLABLE) {
            return false;
        }
        return DfaNullability.fromDfType(this.getDfType(value2)) == DfaNullability.FLUSHED || this.isNull(value2) || this.isNotNull(value2);
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(53);
        }
        this.flushVariable(variable, false);
    }

    protected void flushVariable(@NotNull DfaVariableValue variable, boolean shouldMarkFlushed) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(54);
        }
        EqClass eqClass = variable.getDependentVariables().isEmpty() ? null : this.getEqClass(variable);
        DfaVariableValue newCanonical = eqClass == null ? null : (DfaVariableValue)StreamEx.of(eqClass.iterator()).without((Object)variable).min(EqClass.CANONICAL_VARIABLE_COMPARATOR).filter(candidate -> !candidate.dependsOn(variable)).orElse(null);
        this.myStack.replaceAll(value2 -> this.handleStackValueOnVariableFlush((DfaValue)value2, variable, newCanonical));
        this.doFlush(variable, shouldMarkFlushed);
        this.flushDependencies(variable);
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(55);
        }
        for (DfaVariableValue dependent : variable.getDependentVariables().toArray(new DfaVariableValue[0])) {
            this.doFlush(dependent, false);
        }
    }

    private void flushQualifiedMethods(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(56);
        }
        PsiModifierListOwner psiVariable = variable.getPsiVariable();
        DfaVariableValue qualifier = variable.getQualifier();
        if (psiVariable instanceof PsiField && qualifier != null) {
            List toFlush = ContainerUtil.filter(qualifier.getDependentVariables(), DfaVariableValue::containsCalls);
            toFlush.forEach(val -> this.doFlush((DfaVariableValue)val, this.shouldMarkFlushed((DfaVariableValue)val)));
        }
    }

    void doFlush(@NotNull DfaVariableValue var, boolean markFlushed) {
        DfType type2;
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(57);
        }
        if (this.isNull(var)) {
            this.myStack.replaceAll(val -> val == var ? this.myFactory.getNull() : val);
        }
        this.removeEquivalence(var);
        this.myVariableTypes.remove(var);
        if (markFlushed && (type2 = this.getDfType(var)) instanceof DfReferenceType) {
            this.recordVariableType(var, ((DfReferenceType)type2).dropNullability().meet(DfaNullability.FLUSHED.asDfType()));
        }
        this.myCachedHash = null;
    }

    void removeEquivalence(DfaVariableValue var) {
        int varID = var.getID();
        Integer varClassIndex = (Integer)this.myIdToEqClassesIndices.get(varID);
        if (varClassIndex == null && (varClassIndex = (Integer)this.myIdToEqClassesIndices.get(varID = (var = this.canonicalize(var)).getID())) == null) {
            return;
        }
        EqClass varClass = this.myEqClasses.get(varClassIndex);
        varClass = new EqClass(varClass);
        DfaVariableValue previousCanonical = varClass.getCanonicalVariable();
        this.myEqClasses.set(varClassIndex, varClass);
        varClass.removeValue(varID);
        this.myIdToEqClassesIndices.remove(varID);
        this.checkInvariants();
        if (varClass.isEmpty()) {
            this.myEqClasses.set(varClassIndex, null);
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair2 = iterator.next();
                if (pair2.getOtherClass(varClassIndex) == null) continue;
                iterator.remove();
            }
        } else {
            DfaVariableValue newCanonical = varClass.getCanonicalVariable();
            if (newCanonical != null && previousCanonical != null && previousCanonical != newCanonical && (ControlFlowAnalyzer.isTempVariable(previousCanonical) && !newCanonical.dependsOn(previousCanonical) || newCanonical.getDepth() <= previousCanonical.getDepth())) {
                boolean successfullyConverted = this.convertQualifiers(previousCanonical, newCanonical);
                assert (successfullyConverted);
            }
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
    }

    Object getMergeabilityKey() {
        return StreamEx.of(this.myStack).mapLastOrElse(val -> ObjectUtils.tryCast((Object)val, DfaControlTransferValue.class), Function.identity()).append((Object)this.isEphemeral()).toImmutableList();
    }

    void merge(DfaMemoryStateImpl other) {
        assert (other.isEphemeral() == this.isEphemeral());
        assert (other.myStack.size() == this.myStack.size());
        ProgressManager.checkCanceled();
        this.retainEquivalences(other);
        this.mergeDistinctPairs(other);
        this.mergeVariableTypes(other);
        this.mergeStacks(other);
        this.myCachedHash = null;
        this.myCachedNonTrivialEqClasses = null;
        this.afterMerge(other);
    }

    protected void afterMerge(DfaMemoryStateImpl other) {
    }

    private void mergeStacks(DfaMemoryStateImpl other) {
        List values = StreamEx.zip(this.myStack, other.myStack, DfaValue::unite).toList();
        this.myStack.clear();
        values.forEach(arg_0 -> this.myStack.push(arg_0));
    }

    private void mergeDistinctPairs(DfaMemoryStateImpl other) {
        ArrayList<DistinctPairSet.DistinctPair> pairs = new ArrayList<DistinctPairSet.DistinctPair>(this.myDistinctClasses);
        for (DistinctPairSet.DistinctPair pair2 : pairs) {
            EqClass first = pair2.getFirst();
            EqClass second = pair2.getSecond();
            RelationType relation = other.getRelation(this.myFactory.getValue(first.get(0)), this.myFactory.getValue(second.get(0)));
            if (relation == null || relation == RelationType.EQ) {
                this.myDistinctClasses.remove(pair2);
                continue;
            }
            if (!pair2.isOrdered() || relation == RelationType.LT) continue;
            this.myDistinctClasses.dropOrder(pair2);
        }
    }

    private void mergeVariableTypes(DfaMemoryStateImpl other) {
        Set vars = (Set)StreamEx.of((Object[])new LinkedHashMap[]{this.myVariableTypes, other.myVariableTypes}).toFlatCollection(Map::keySet, HashSet::new);
        for (DfaVariableValue var : vars) {
            Nullability otherNullability;
            DfType type2 = this.getDfType(var);
            DfType otherType = other.getDfType(var);
            DfType result = type2.join(otherType);
            Nullability nullability = DfaNullability.toNullability(DfaNullability.fromDfType(type2));
            if (nullability != (otherNullability = DfaNullability.toNullability(DfaNullability.fromDfType(otherType))) && (nullability == Nullability.NULLABLE || otherNullability == Nullability.NULLABLE) && result instanceof DfReferenceType) {
                result = ((DfReferenceType)result).dropNullability().meet(DfaNullability.FLUSHED.asDfType());
            }
            this.recordVariableType(var, result);
        }
    }

    private void retainEquivalences(DfaMemoryStateImpl other) {
        boolean needRestart = true;
        block0: while (needRestart) {
            ProgressManager.checkCanceled();
            needRestart = false;
            for (EqClass eqClass : new ArrayList<EqClass>(this.myEqClasses)) {
                if (eqClass == null || !this.retainEquivalences(eqClass, other)) continue;
                needRestart = true;
                continue block0;
            }
        }
    }

    private boolean retainEquivalences(EqClass eqClass, DfaMemoryStateImpl other) {
        if (eqClass.size() <= 1) {
            return false;
        }
        List<EqClass> groups = this.splitEqClass(eqClass, other);
        if (groups.size() == 1) {
            return false;
        }
        TIntArrayList addedClasses = new TIntArrayList();
        int origIndex = (Integer)this.myIdToEqClassesIndices.get(eqClass.get(0));
        for (EqClass group : groups) {
            addedClasses.add(this.storeClass(group));
        }
        int[] addedClassesArray = addedClasses.toNativeArray();
        this.myDistinctClasses.splitClass(origIndex, addedClassesArray);
        this.myEqClasses.set(origIndex, null);
        DfaVariableValue from = eqClass.getCanonicalVariable();
        boolean otherClassChanged = false;
        if (from != null && !from.getDependentVariables().isEmpty()) {
            ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableTypes.keySet());
            for (int classIndex : addedClassesArray) {
                DfaVariableValue to = this.myEqClasses.get(classIndex).getCanonicalVariable();
                if (to == null || to == from || to.getDepth() > from.getDepth()) continue;
                for (DfaVariableValue var : vars) {
                    DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
                    if (target == var) continue;
                    this.recordVariableType(target, this.getDfType(var));
                }
                for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
                    DfaValue value2 = this.myFactory.getValue((int)valueId);
                    DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
                    if (var == null || var.getQualifier() != from) continue;
                    DfaVariableValue target = var.withQualifier(to);
                    boolean united = this.uniteClasses(var, target);
                    assert (united);
                    otherClassChanged = true;
                }
            }
        }
        this.checkInvariants();
        return otherClassChanged;
    }

    @NotNull
    private List<EqClass> splitEqClass(EqClass eqClass, DfaMemoryStateImpl other) {
        TIntObjectHashMap groupsInClasses = new TIntObjectHashMap();
        ArrayList<EqClass> groups = new ArrayList<EqClass>();
        for (DfaVariableValue value2 : eqClass.asList()) {
            EqClass list;
            int otherClass = other.getEqClassIndex(value2);
            if (otherClass == -1) {
                list = new EqClass(this.myFactory);
                groups.add(list);
            } else {
                list = (EqClass)groupsInClasses.get(otherClass);
                if (list == null) {
                    list = new EqClass(this.myFactory);
                    groupsInClasses.put(otherClass, (Object)list);
                }
            }
            list.add(value2.getID());
        }
        groupsInClasses.forEachValue(groups::add);
        ArrayList<EqClass> arrayList = groups;
        if (arrayList == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    private static DfType withNotNull(DfType type2) {
        if (type2 instanceof DfReferenceType) {
            return ((DfReferenceType)type2).getNullability() == DfaNullability.NOT_NULL ? type2 : ((DfReferenceType)type2).dropNullability();
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 26: 
            case 32: 
            case 33: 
            case 38: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factValue";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiers";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierStatusMap";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeNullability";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntegerSumOverflowValues";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnboxedDfType";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "splitEqClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterDfTypeOnAssignment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDfType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeNullability";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "meetDfType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "propagateRangeBack";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applySpecialFieldEquivalence";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyUnboxedRelation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPsiType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canBeNaN";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "applyLessThanRelation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUnboxedDfType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDfType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "recordVariableType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "flushFieldsQualifiedBy";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "flushFields";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkFlushed";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "flushQualifiedMethods";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class QualifierStatusMap {
        private final TIntObjectHashMap<QualifierStatus> myMap = new TIntObjectHashMap();
        @Nullable
        private final Set<DfaValue> myQualifiersToFlush;

        private QualifierStatusMap(Set<DfaValue> qualifiersToFlush) {
            this.myQualifiersToFlush = qualifiersToFlush;
        }

        boolean shouldFlush(@Nullable DfaValue qualifier, boolean hasCall) {
            if (qualifier == null) {
                return true;
            }
            QualifierStatus status = (QualifierStatus)((Object)this.myMap.get(qualifier.getID()));
            if (status == null) {
                DfaVariableValue qualifierQualifier;
                DfaVariableValue qualifierVar;
                status = this.calculate(qualifier);
                if (status != QualifierStatus.SHOULD_FLUSH_ALWAYS && qualifier instanceof DfaVariableValue && (qualifierVar = (DfaVariableValue)qualifier).isFlushableByCalls() && this.shouldFlush(qualifierQualifier = qualifierVar.getQualifier(), qualifierVar.containsCalls())) {
                    status = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                }
                this.myMap.put(qualifier.getID(), (Object)status);
            }
            return status == QualifierStatus.SHOULD_FLUSH_ALWAYS || hasCall && status == QualifierStatus.SHOULD_FLUSH_CALLS;
        }

        @NotNull
        private QualifierStatus calculate(@NotNull DfaValue qualifier) {
            DfReferenceType dfType;
            if (qualifier == null) {
                QualifierStatusMap.$$$reportNull$$$0(0);
            }
            if ((dfType = (DfReferenceType)ObjectUtils.tryCast((Object)DfaMemoryStateImpl.this.getDfType(qualifier), DfReferenceType.class)) == null) {
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(1);
                }
                return qualifierStatus;
            }
            if (dfType.getMutability() == Mutability.UNMODIFIABLE) {
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_NOT_FLUSH;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(2);
                }
                return qualifierStatus;
            }
            if (dfType.isLocal()) {
                QualifierStatus qualifierStatus = this.myQualifiersToFlush != null && this.myQualifiersToFlush.contains(qualifier) ? QualifierStatus.SHOULD_FLUSH_ALWAYS : QualifierStatus.SHOULD_NOT_FLUSH;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(3);
                }
                return qualifierStatus;
            }
            if (this.myQualifiersToFlush == null) {
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(4);
                }
                return qualifierStatus;
            }
            boolean flushCalls = false;
            for (DfaValue qualifierToFlush : this.myQualifiersToFlush) {
                RelationType relation = DfaMemoryStateImpl.this.getRelation(qualifier, qualifierToFlush);
                if (relation == RelationType.EQ) {
                    QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                    if (qualifierStatus == null) {
                        QualifierStatusMap.$$$reportNull$$$0(5);
                    }
                    return qualifierStatus;
                }
                DfType typeToFlush = DfaMemoryStateImpl.this.getDfType(qualifierToFlush);
                if (typeToFlush instanceof DfReferenceType && ((DfReferenceType)typeToFlush).isLocal()) continue;
                flushCalls = true;
                if (relation != null || typeToFlush.meet(dfType) == DfTypes.BOTTOM) continue;
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(6);
                }
                return qualifierStatus;
            }
            QualifierStatus qualifierStatus = flushCalls ? QualifierStatus.SHOULD_FLUSH_CALLS : QualifierStatus.SHOULD_NOT_FLUSH;
            if (qualifierStatus == null) {
                QualifierStatusMap.$$$reportNull$$$0(7);
            }
            return qualifierStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl$QualifierStatusMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl$QualifierStatusMap";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculate";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum QualifierStatus {
        SHOULD_FLUSH_ALWAYS,
        SHOULD_FLUSH_CALLS,
        SHOULD_NOT_FLUSH;

    }

    private class MyIdMap
    extends TIntObjectHashMap<Integer> {
        private MyIdMap() {
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Integer>(){

                public boolean execute(int id, Integer index) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(index).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

