/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BoxingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ClosureInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ObjectOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.instructions.UnwrapSpecialFieldInstruction;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstructionVisitor {
    protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
        if (value2 == null) {
            InstructionVisitor.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            InstructionVisitor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(2);
        }
    }

    protected void beforeMethodReferenceResultPush(@NotNull DfaValue value2, @NotNull PsiMethodReferenceExpression methodRef, @NotNull DfaMemoryState state) {
        if (value2 == null) {
            InstructionVisitor.$$$reportNull$$$0(3);
        }
        if (methodRef == null) {
            InstructionVisitor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(5);
        }
    }

    protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner context, @NotNull DfaMemoryState state) {
        if (value2 == null) {
            InstructionVisitor.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            InstructionVisitor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            InstructionVisitor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(9);
        }
    }

    protected void beforeConditionalJump(ConditionalGotoInstruction instruction, boolean isTrueBranch) {
    }

    void pushExpressionResult(@NotNull DfaValue value2, @NotNull ExpressionPushingInstruction<?> instruction, @NotNull DfaMemoryState state) {
        Object anchor;
        if (value2 == null) {
            InstructionVisitor.$$$reportNull$$$0(10);
        }
        if (instruction == null) {
            InstructionVisitor.$$$reportNull$$$0(11);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(12);
        }
        if (InstructionVisitor.isExpressionPush(instruction, anchor = instruction.getExpression())) {
            if (anchor instanceof PsiMethodReferenceExpression && !(instruction instanceof MethodReferenceInstruction)) {
                this.beforeMethodReferenceResultPush(value2, (PsiMethodReferenceExpression)anchor, state);
            } else {
                this.callBeforeExpressionPush(value2, instruction, state, (PsiExpression)anchor);
            }
        }
        state.push(value2);
    }

    private static boolean isExpressionPush(@NotNull ExpressionPushingInstruction<?> instruction, PsiExpression anchor) {
        PsiAssignmentExpression assignment;
        if (instruction == null) {
            InstructionVisitor.$$$reportNull$$$0(13);
        }
        if (anchor == null) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent());
        if (parent instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ) && PsiTreeUtil.isAncestor((PsiElement)assignment.getLExpression(), (PsiElement)anchor, (boolean)false)) {
            return false;
        }
        if (instruction instanceof PushInstruction) {
            return !((PushInstruction)instruction).isReferenceWrite();
        }
        return true;
    }

    private void callBeforeExpressionPush(@NotNull DfaValue value2, @NotNull ExpressionPushingInstruction<?> instruction, @NotNull DfaMemoryState state, PsiExpression anchor) {
        PsiPolyadicExpression polyadic;
        if (value2 == null) {
            InstructionVisitor.$$$reportNull$$$0(14);
        }
        if (instruction == null) {
            InstructionVisitor.$$$reportNull$$$0(15);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(16);
        }
        this.beforeExpressionPush(value2, anchor, instruction.getExpressionRange(), state);
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent());
        if (parent instanceof PsiLambdaExpression) {
            this.checkReturnValue(value2, (PsiExpression)Objects.requireNonNull(instruction.getExpression()), (PsiParameterListOwner)((PsiLambdaExpression)parent), state);
        } else if (parent instanceof PsiReturnStatement) {
            PsiParameterListOwner context = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (context != null) {
                this.checkReturnValue(value2, (PsiExpression)Objects.requireNonNull(instruction.getExpression()), context, state);
            }
        } else if (anchor instanceof PsiArrayInitializerExpression && parent instanceof PsiNewExpression) {
            this.callBeforeExpressionPush(value2, instruction, state, (PsiExpression)parent);
        } else if (parent instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)anchor, (boolean)false)) {
            this.callBeforeExpressionPush(value2, instruction, state, (PsiExpression)((PsiConditionalExpression)parent));
        } else if (parent instanceof PsiPolyadicExpression && ((polyadic = (PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) || polyadic.getOperationTokenType().equals(JavaTokenType.OROR)) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArrayUtil.getLastElement((Object[])polyadic.getOperands())), (PsiElement)anchor, (boolean)false)) {
            this.callBeforeExpressionPush(value2, instruction, state, (PsiExpression)polyadic);
        }
    }

    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        DfaValue dest = memState.pop();
        memState.push(dest);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dest, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitBox(BoxingInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue boxed;
        DfaValue value2 = state.pop();
        DfaValueFactory factory = runner.getFactory();
        if (value2 instanceof DfaBinOpValue) {
            value2 = factory.fromDfType(state.getDfType(value2));
        }
        state.push((boxed = factory.getBoxedFactory().createBoxed(value2, instruction.getTargetType())) == null ? factory.getObjectType(instruction.getTargetType(), Nullability.NOT_NULL) : boxed);
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitUnwrapField(UnwrapSpecialFieldInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue value2 = state.pop();
        DfaValue field = instruction.getSpecialField().createValue(runner.getFactory(), value2);
        state.push(field);
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitConvertPrimitive(PrimitiveConversionInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        state.pop();
        this.pushExpressionResult(runner.getFactory().getUnknown(), instruction, state);
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    protected void flushArrayOnUnknownAssignment(AssignInstruction instruction, DfaValueFactory factory, DfaValue dest, DfaMemoryState memState) {
        PsiExpression array;
        DfaValue value2;
        if (dest instanceof DfaVariableValue) {
            return;
        }
        PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression()), PsiArrayAccessExpression.class);
        if (arrayAccess != null && (value2 = factory.createValue(array = arrayAccess.getArrayExpression())) instanceof DfaVariableValue) {
            for (DfaVariableValue qualified : ((DfaVariableValue)value2).getDependentVariables().toArray(new DfaVariableValue[0])) {
                if (!qualified.isFlushableByCalls()) continue;
                memState.flushVariable(qualified);
            }
        }
    }

    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState @NotNull [] visitControlTransfer(@NotNull ControlTransferInstruction controlTransferInstruction, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState state) {
        if (controlTransferInstruction == null) {
            InstructionVisitor.$$$reportNull$$$0(17);
        }
        if (runner == null) {
            InstructionVisitor.$$$reportNull$$$0(18);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(19);
        }
        DfaInstructionState[] dfaInstructionStateArray = controlTransferInstruction.getTransfer().dispatch(state, runner).toArray(DfaInstructionState.EMPTY_ARRAY);
        if (dfaInstructionStateArray == null) {
            InstructionVisitor.$$$reportNull$$$0(20);
        }
        return dfaInstructionStateArray;
    }

    public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitEscapeInstruction(EscapeInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitResultOf(ResultOfInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        this.pushExpressionResult(state.pop(), instruction, state);
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    protected static DfaInstructionState[] nextInstruction(Instruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
    }

    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return this.visitBinop(instruction, runner, memState);
    }

    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        this.pushExpressionResult(runner.getFactory().getUnknown(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitObjectOfInstruction(ObjectOfInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue value2 = state.pop();
        PsiType type2 = DfConstantType.getConstantOfType(state.getDfType(value2), PsiType.class);
        state.push(runner.getFactory().getObjectType(type2, Nullability.NOT_NULL));
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitConditionalGoto(ConditionalGotoInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaCondition condTrue = memState.pop().eq(runner.getFactory().getBoolean(!instruction.isNegated()));
        DfaCondition condFalse = condTrue.negate();
        if (condTrue == DfaCondition.getTrue()) {
            this.beforeConditionalJump(instruction, true);
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getOffset()), memState)};
        }
        if (condFalse == DfaCondition.getTrue()) {
            this.beforeConditionalJump(instruction, false);
            return InstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        DfaMemoryState elseState = memState.createCopy();
        if (memState.applyCondition(condTrue)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getOffset()), memState));
            this.beforeConditionalJump(instruction, true);
        }
        if (elseState.applyCondition(condFalse)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), elseState));
            this.beforeConditionalJump(instruction, false);
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    public DfaInstructionState[] visitMethodReference(MethodReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        this.pushExpressionResult(runner.getFactory().getUnknown(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFlushVariable(FlushVariableInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.flushVariable(instruction.getVariable());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFlushFields(FlushFieldsInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.flushFields();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        for (int i = instruction.getArgCount(); i > 0; --i) {
            memState.pop();
        }
        memState.pop();
        this.pushExpressionResult(runner.getFactory().getUnknown(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        this.pushExpressionResult(runner.getFactory().getUnknown(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitPush(ExpressionPushingInstruction<?> instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue value2) {
        this.pushExpressionResult(value2, instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        this.pushExpressionResult(instruction.getValue(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.pushExpressionResult(memState.pop(), instruction, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitClosureInstruction(ClosureInstruction instruction, DataFlowRunner runner, DfaMemoryState before) {
        return InstructionVisitor.nextInstruction(instruction, runner, before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlTransferInstruction";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/InstructionVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/InstructionVisitor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "visitControlTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeExpressionPush";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeMethodReferenceResultPush";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pushExpressionResult";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionPush";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "callBeforeExpressionPush";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitControlTransfer";
                break;
            }
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

