/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class MethodContract {
    private final ContractReturnValue myReturnValue;

    MethodContract(ContractReturnValue returnValue) {
        this.myReturnValue = returnValue;
    }

    public ContractReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    public boolean isTrivial() {
        return this.getConditions().isEmpty();
    }

    abstract String getArgumentsPresentation();

    public abstract List<ContractValue> getConditions();

    public String toString() {
        return this.getArgumentsPresentation() + " -> " + this.getReturnValue();
    }

    public static MethodContract trivialContract(ContractReturnValue value2) {
        return new MethodContract(value2){

            @Override
            String getArgumentsPresentation() {
                return "()";
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.emptyList();
            }
        };
    }

    @NotNull
    public static MethodContract singleConditionContract(ContractValue left, RelationType relationType, ContractValue right, ContractReturnValue returnValue) {
        return MethodContract.singleConditionContract(ContractValue.condition(left, relationType, right), returnValue);
    }

    @NotNull
    private static MethodContract singleConditionContract(final ContractValue condition2, ContractReturnValue returnValue) {
        return new MethodContract(returnValue){

            @Override
            String getArgumentsPresentation() {
                return "(" + condition2.toString() + ")";
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.singletonList(condition2);
            }
        };
    }

    public static List<? extends MethodContract> toNonIntersectingContracts(List<? extends MethodContract> contracts2) {
        if (contracts2.size() == 1) {
            return contracts2;
        }
        if (contracts2.stream().allMatch(StandardMethodContract.class::isInstance)) {
            List<? extends MethodContract> standardContracts = contracts2;
            return StandardMethodContract.toNonIntersectingStandardContracts(standardContracts);
        }
        if (contracts2.size() == 2 && contracts2.get(1).isTrivial()) {
            ArrayList<MethodContract> result = new ArrayList<MethodContract>();
            result.add(contracts2.get(0));
            List<ContractValue> conditions = contracts2.get(0).getConditions();
            for (ContractValue condition2 : conditions) {
                ContractValue inverted = condition2.invert();
                if (inverted == null) {
                    return null;
                }
                result.add(MethodContract.singleConditionContract(inverted, contracts2.get(1).getReturnValue()));
            }
            return result;
        }
        return null;
    }
}

