/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    static final MutationSignature UNKNOWN = new MutationSignature(false, new boolean[0]);
    static final MutationSignature PURE = new MutationSignature(false, new boolean[0]);
    private static final MutationSignature MUTATES_THIS_ONLY = new MutationSignature(true, new boolean[0]);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid token: %s; supported are 'this', 'param1', 'param2', etc.";
    private final boolean myThis;
    private final boolean[] myParameters;

    private MutationSignature(boolean mutatesThis, boolean[] params) {
        this.myThis = mutatesThis;
        this.myParameters = params;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean mutatesArg(int n) {
        return n < this.myParameters.length && this.myParameters[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public MutationSignature alsoMutatesThis() {
        return this == UNKNOWN || this.myThis ? this : (this.isPure() ? MUTATES_THIS_ONLY : new MutationSignature(true, this.myParameters));
    }

    public MutationSignature alsoMutatesArg(int n) {
        if (this.myParameters.length > n && this.myParameters[n]) {
            return this;
        }
        boolean[] params = Arrays.copyOf(this.myParameters, Math.max(n + 1, this.myParameters.length));
        params[n] = true;
        return new MutationSignature(this.myThis, params);
    }

    public boolean isPure() {
        return this == PURE;
    }

    public int hashCode() {
        return (this.myThis ? 137 : 731) + Arrays.hashCode(this.myParameters);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this == UNKNOWN != (obj == UNKNOWN)) {
            return false;
        }
        return obj instanceof MutationSignature && ((MutationSignature)obj).myThis == this.myThis && Arrays.equals(((MutationSignature)obj).myParameters, this.myParameters);
    }

    public String toString() {
        if (this.isPure()) {
            return "(pure)";
        }
        if (this == UNKNOWN) {
            return "(unknown)";
        }
        return IntStreamEx.range((int)this.myParameters.length).mapToEntry(idx -> "param" + (idx + 1), idx -> this.myParameters[idx]).prepend((Object)"this", (Object)this.myThis).filterValues(b -> b).keys().joining((CharSequence)",");
    }

    public Stream<PsiExpression> mutatedExpressions(PsiMethodCallExpression call) {
        PsiExpression qualifier;
        Object[] args = call.getArgumentList().getExpressions();
        StreamEx elements = IntStreamEx.range((int)Math.min(this.myParameters.length, MethodCallUtils.isVarArgCall((PsiCall)call) ? args.length - 1 : args.length)).filter(idx -> this.myParameters[idx]).elements(args);
        if (this.myThis && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null) {
            return elements.prepend((Object)qualifier);
        }
        return elements;
    }

    public boolean mutatesAnything() {
        if (this.myThis) {
            return true;
        }
        for (boolean parameter2 : this.myParameters) {
            if (!parameter2) continue;
            return true;
        }
        return false;
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(0);
        }
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("param")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("param")) {
                int argNum = Integer.parseInt(part.substring("param".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
        }
        return new MutationSignature(mutatesThis, args);
    }

    @Nullable
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(1);
        }
        if (method == null) {
            MutationSignature.$$$reportNull$$$0(2);
        }
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return "Static method cannot mutate 'this'";
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (ms.myParameters.length > parameters2.length) {
                return "Reference to parameter #" + ms.myParameters.length + " is invalid";
            }
            for (int i = 0; i < ms.myParameters.length; ++i) {
                PsiType type2;
                if (!ms.myParameters[i] || !ClassUtils.isImmutable(type2 = parameters2[i].getType())) continue;
                return "Parameter #" + (i + 1) + " has immutable type '" + type2.getPresentableText() + "'";
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(3);
            }
            return mutationSignature;
        }
        MutationSignature mutationSignature = JavaMethodContractUtil.getContractInfo(method).getMutationSignature();
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(4);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature fromCall(@Nullable PsiCall call) {
        if (call == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(5);
            }
            return mutationSignature;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null) {
            if (SpecialField.findSpecialField((PsiElement)method) != null) {
                MutationSignature mutationSignature = PURE;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(6);
                }
                return mutationSignature;
            }
            return MutationSignature.fromMethod(method);
        }
        if (call instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)call;
            if (newExpression.isArrayCreation()) {
                MutationSignature mutationSignature = PURE;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(7);
                }
                return mutationSignature;
            }
            if (newExpression.getArgumentList() == null || !newExpression.getArgumentList().isEmpty()) {
                MutationSignature mutationSignature = UNKNOWN;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(8);
                }
                return mutationSignature;
            }
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassOrAnonymousClassReference();
            if (classReference2 == null) {
                MutationSignature mutationSignature = UNKNOWN;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(9);
                }
                return mutationSignature;
            }
            PsiClass clazz = (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
            if (clazz == null) {
                MutationSignature mutationSignature = UNKNOWN;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(10);
                }
                return mutationSignature;
            }
            HashSet<PsiClass> visited = new HashSet<PsiClass>();
            do {
                for (PsiField psiField : clazz.getFields()) {
                    if (psiField.hasModifierProperty("static") || !psiField.hasInitializer()) continue;
                    MutationSignature mutationSignature = UNKNOWN;
                    if (mutationSignature == null) {
                        MutationSignature.$$$reportNull$$$0(11);
                    }
                    return mutationSignature;
                }
                for (PsiField psiField : clazz.getInitializers()) {
                    if (psiField.hasModifierProperty("static")) continue;
                    MutationSignature mutationSignature = UNKNOWN;
                    if (mutationSignature == null) {
                        MutationSignature.$$$reportNull$$$0(12);
                    }
                    return mutationSignature;
                }
                for (PsiField psiField : clazz.getConstructors()) {
                    if (!psiField.getParameterList().isEmpty()) continue;
                    return MutationSignature.fromMethod((PsiMethod)psiField);
                }
            } while ((clazz = clazz.getSuperClass()) != null && visited.add(clazz));
            return MutationSignature.unknown();
        }
        MutationSignature mutationSignature = UNKNOWN;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(13);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature pure() {
        MutationSignature mutationSignature = PURE;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(14);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature unknown() {
        MutationSignature mutationSignature = UNKNOWN;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(15);
        }
        return mutationSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromCall";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "pure";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unknown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

