/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullabilityUtil {
    @NotNull
    public static DfaNullability calcCanBeNull(DfaVariableValue value2) {
        PsiType itemType;
        PsiExpression iteratedValue2;
        if (value2.getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor) {
            DfaNullability dfaNullability = DfaNullability.NOT_NULL;
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(0);
            }
            return dfaNullability;
        }
        if (value2.getDescriptor() == SpecialField.OPTIONAL_VALUE) {
            DfaNullability dfaNullability = DfaNullability.NULLABLE;
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(1);
            }
            return dfaNullability;
        }
        PsiModifierListOwner var = value2.getPsiVariable();
        if (value2.getType() instanceof PsiPrimitiveType) {
            DfaNullability dfaNullability = DfaNullability.UNKNOWN;
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(2);
            }
            return dfaNullability;
        }
        Nullability nullability = DfaPsiUtil.getElementNullabilityIgnoringParameterInference(value2.getType(), var);
        if (nullability != Nullability.UNKNOWN) {
            DfaNullability dfaNullability = DfaNullability.fromNullability(nullability);
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(3);
            }
            return dfaNullability;
        }
        if (var == null) {
            DfaNullability dfaNullability = DfaNullability.UNKNOWN;
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(4);
            }
            return dfaNullability;
        }
        Nullability defaultNullability = value2.getFactory().suggestNullabilityForNonAnnotatedMember(var);
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue2 = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2)) != null) {
            DfaNullability dfaNullability = DfaNullability.fromNullability(DfaPsiUtil.getElementNullability(itemType, var));
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(5);
            }
            return dfaNullability;
        }
        if (var instanceof PsiField && value2.getFactory().canTrustFieldInitializer((PsiField)var)) {
            DfaNullability dfaNullability = DfaNullability.fromNullability((Nullability)NullabilityUtil.getNullabilityFromFieldInitializers((PsiField)((PsiField)var), (Nullability)defaultNullability).second);
            if (dfaNullability == null) {
                NullabilityUtil.$$$reportNull$$$0(6);
            }
            return dfaNullability;
        }
        DfaNullability dfaNullability = DfaNullability.fromNullability(defaultNullability);
        if (dfaNullability == null) {
            NullabilityUtil.$$$reportNull$$$0(7);
        }
        return dfaNullability;
    }

    static Pair<PsiExpression, Nullability> getNullabilityFromFieldInitializers(PsiField field, Nullability defaultNullability) {
        if (DfaPsiUtil.isFinalField((PsiVariable)field)) {
            PsiExpression initializer = field.getInitializer();
            if (initializer != null) {
                return Pair.create((Object)initializer, (Object)NullabilityUtil.getExpressionNullability(initializer));
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return Pair.create(null, (Object)defaultNullability);
            }
            for (PsiExpression expression2 : initializers) {
                Nullability nullability = NullabilityUtil.getExpressionNullability(expression2);
                if (nullability != Nullability.NULLABLE) continue;
                return Pair.create((Object)expression2, (Object)Nullability.NULLABLE);
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Pair.create((Object)((PsiExpression)ContainerUtil.getOnlyItem(initializers)), (Object)Nullability.NOT_NULL);
            }
        } else if (NullabilityUtil.isOnlyImplicitlyInitialized(field)) {
            return Pair.create(null, (Object)Nullability.NOT_NULL);
        }
        return Pair.create(null, (Object)defaultNullability);
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)(NullabilityUtil.isImplicitlyInitializedNotNull(field) && NullabilityUtil.weAreSureThereAreNoExplicitWrites(field) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists((Iterable)ImplicitUsageProvider.EP_NAME.getExtensionList(), p -> p.isImplicitlyNotNullInitialized((PsiElement)field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        String name2 = field.getName();
        if (field.getInitializer() != null) {
            return false;
        }
        if (!NullabilityUtil.isCheapEnoughToSearch(field, name2)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)field).allMatch(reference -> reference instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)reference)));
    }

    private static boolean isCheapEnoughToSearch(PsiField field, String name2) {
        SearchScope scope = field.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)field.getProject());
        PsiSearchHelper.SearchCostResult result = helper.isCheapEnoughToSearch(name2, (GlobalSearchScope)scope, field.getContainingFile(), null);
        return result != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression2) {
        return NullabilityUtil.getExpressionNullability(expression2, false);
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression2, boolean useDataflow) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return Nullability.UNKNOWN;
        }
        if (PsiType.NULL.equals((Object)expression2.getType())) {
            return Nullability.NULLABLE;
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiPolyadicExpression || expression2 instanceof PsiFunctionalExpression || expression2.getType() instanceof PsiPrimitiveType) {
            return Nullability.NOT_NULL;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                return Nullability.UNKNOWN;
            }
            PsiExpression condition2 = ((PsiConditionalExpression)expression2).getCondition();
            PsiReferenceExpression ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, true);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, elseExpression2)) {
                return NullabilityUtil.getExpressionNullability(thenExpression2, useDataflow);
            }
            ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, false);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, thenExpression2)) {
                return NullabilityUtil.getExpressionNullability(elseExpression2, useDataflow);
            }
            if (useDataflow) {
                return DfaNullability.toNullability(DfaNullability.fromDfType(CommonDataflow.getDfType(expression2)));
            }
            Nullability left = NullabilityUtil.getExpressionNullability(thenExpression2, false);
            if (left == Nullability.UNKNOWN) {
                return Nullability.UNKNOWN;
            }
            Nullability right = NullabilityUtil.getExpressionNullability(elseExpression2, false);
            return left == right ? left : Nullability.UNKNOWN;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            return NullabilityUtil.getExpressionNullability(((PsiTypeCastExpression)expression2).getOperand(), useDataflow);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                return NullabilityUtil.getExpressionNullability(assignment.getRExpression(), useDataflow);
            }
            return Nullability.NOT_NULL;
        }
        if (useDataflow) {
            return DfaNullability.toNullability(DfaNullability.fromDfType(CommonDataflow.getDfType(expression2)));
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement block;
            PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
            PsiElement target = ref.resolve();
            if (target instanceof PsiPatternVariable) {
                return Nullability.NOT_NULL;
            }
            if (!(!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter) || (block = PsiUtil.getVariableCodeBlock((PsiVariable)((PsiVariable)target), null)) != null && HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)target, block, (PsiJavaCodeReferenceElement)ref))) {
                return Nullability.UNKNOWN;
            }
            return DfaPsiUtil.getElementNullabilityIgnoringParameterInference(expression2.getType(), (PsiModifierListOwner)target);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression2).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)method) : Nullability.UNKNOWN;
        }
        return Nullability.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullabilityUtil", "calcCanBeNull"));
    }
}

