/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance(StandardInstructionVisitor.class);
    private final boolean myStopAnalysisOnNpe;
    final Set<InstanceofInstruction> myReachable = new THashSet();
    final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();

    public StandardInstructionVisitor() {
        this.myStopAnalysisOnNpe = false;
    }

    protected StandardInstructionVisitor(boolean stopAnalysisOnNpe) {
        this.myStopAnalysisOnNpe = stopAnalysisOnNpe;
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (!(dfaDest instanceof DfaVariableValue) && instruction.getAssignedValue() != null) {
            dfaDest = instruction.getAssignedValue();
        }
        if (dfaSource == dfaDest) {
            memState.push(dfaDest);
            this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
            return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        if (!(dfaDest instanceof DfaVariableValue && ((DfaVariableValue)dfaDest).getPsiVariable() instanceof PsiLocalVariable && dfaSource instanceof DfaVariableValue && (ControlFlowAnalyzer.isTempVariable((DfaVariableValue)dfaSource) || ((DfaVariableValue)dfaSource).getDescriptor().isCall()))) {
            StandardInstructionVisitor.dropLocality(dfaSource, memState);
        }
        PsiExpression lValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression());
        PsiExpression rValue = instruction.getRExpression();
        if (lValue instanceof PsiArrayAccessExpression) {
            this.checkArrayElementAssignability(memState, dfaSource, dfaDest, lValue, rValue);
        }
        if (dfaDest instanceof DfaVariableValue) {
            DfType dfType;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            if (dfaSource instanceof DfaTypeValue && (psi instanceof PsiField && psi.hasModifierProperty("static") || var.getQualifier() != null && !DfReferenceType.isLocal(memState.getDfType(var.getQualifier()))) && (dfType = dfaSource.getDfType()) instanceof DfReferenceType) {
                dfaSource = dfaSource.getFactory().fromDfType(((DfReferenceType)dfType).dropLocality());
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullability.NULLABLE && DfaNullability.fromDfType(memState.getDfType(var)) == DfaNullability.UNKNOWN && instruction.isVariableInitializer()) {
                memState.meetDfType(var, DfaNullability.NULLABLE.asDfType());
            }
        }
        this.pushExpressionResult(dfaDest, instruction, memState);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void checkArrayElementAssignability(@NotNull DfaMemoryState memState, @NotNull DfaValue dfaSource, @NotNull DfaValue dfaDest, @NotNull PsiExpression lValue, @Nullable PsiExpression rValue) {
        TypeConstraint fromType;
        TypeConstraint meet;
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (dfaSource == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(1);
        }
        if (dfaDest == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (lValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (rValue == null) {
            return;
        }
        PsiType rCodeType = rValue.getType();
        PsiType lCodeType = lValue.getType();
        if (rCodeType == null || lCodeType == null || !TypeConversionUtil.areTypesConvertible((PsiType)rCodeType, (PsiType)lCodeType)) {
            return;
        }
        if (!(dfaDest instanceof DfaVariableValue)) {
            return;
        }
        DfaVariableValue qualifier = ((DfaVariableValue)dfaDest).getQualifier();
        if (qualifier == null) {
            return;
        }
        TypeConstraint toType = TypeConstraint.fromDfType(memState.getDfType(qualifier)).getArrayComponent();
        if (toType == TypeConstraints.BOTTOM) {
            return;
        }
        if (toType instanceof TypeConstraint.Exact) {
            toType = ((TypeConstraint.Exact)toType).instanceOf();
        }
        if ((meet = (fromType = TypeConstraint.fromDfType(memState.getDfType(dfaSource))).meet(toType)) != TypeConstraints.BOTTOM) {
            return;
        }
        Project project = lValue.getProject();
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)rValue, PsiAssignmentExpression.class);
        PsiType psiFromType = fromType.getPsiType(project);
        PsiType psiToType = toType.getPsiType(project);
        if (psiFromType == null || psiToType == null) {
            return;
        }
        this.processArrayStoreTypeMismatch(assignmentExpression, psiFromType, psiToType);
    }

    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
    }

    @Override
    public DfaInstructionState[] visitEscapeInstruction(EscapeInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        instruction.getEscapedVars().forEach(var -> StandardInstructionVisitor.dropLocality(var, state));
        return super.visitEscapeInstruction(instruction, runner, state);
    }

    private static DfaValue dropLocality(DfaValue value2, DfaMemoryState state) {
        if (!(value2 instanceof DfaVariableValue)) {
            if (DfReferenceType.isLocal(value2.getDfType())) {
                return value2.getFactory().fromDfType(((DfReferenceType)value2.getDfType()).dropLocality());
            }
            return value2;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        DfType dfType = state.getDfType(var);
        if (dfType instanceof DfReferenceType) {
            state.setDfType(var, ((DfReferenceType)dfType).dropLocality());
        }
        for (DfaVariableValue v : new ArrayList<DfaVariableValue>(var.getDependentVariables())) {
            dfType = state.getDfType(v);
            if (!(dfType instanceof DfReferenceType)) continue;
            state.setDfType(v, ((DfReferenceType)dfType).dropLocality());
        }
        return value2;
    }

    @Override
    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiArrayAccessExpression arrayExpression = (PsiArrayAccessExpression)instruction.getExpression();
        DfaValue index = memState.pop();
        DfaValue array = memState.pop();
        boolean alwaysOutOfBounds = false;
        DfaValueFactory factory = runner.getFactory();
        if (!DfaTypeValue.isUnknown(index)) {
            DfaValue dfaLength;
            DfaCondition indexLessThanLength;
            DfaCondition indexNonNegative = index.cond(RelationType.GE, factory.getInt(0));
            if (!memState.applyCondition(indexNonNegative)) {
                alwaysOutOfBounds = true;
            }
            if (!memState.applyCondition(indexLessThanLength = index.cond(RelationType.LT, dfaLength = SpecialField.ARRAY_LENGTH.createValue(factory, array)))) {
                alwaysOutOfBounds = true;
            }
        }
        this.processArrayAccess(arrayExpression, alwaysOutOfBounds);
        if (alwaysOutOfBounds) {
            return DfaInstructionState.EMPTY_ARRAY;
        }
        DfaValue result = instruction.getValue();
        LongRangeSet rangeSet = DfIntType.extractRange(memState.getDfType(index));
        DfaValue arrayElementValue = runner.getFactory().getExpressionFactory().getArrayElementValue(array, rangeSet);
        if (!DfaTypeValue.isUnknown(arrayElementValue)) {
            result = arrayElementValue;
        }
        if (!(result instanceof DfaVariableValue) && array instanceof DfaVariableValue) {
            for (DfaVariableValue value2 : ((DfaVariableValue)array).getDependentVariables().toArray(new DfaVariableValue[0])) {
                if (value2.getQualifier() != array) continue;
                StandardInstructionVisitor.dropLocality(value2, memState);
            }
        }
        this.pushExpressionResult(result, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
    }

    @Override
    public DfaInstructionState[] visitMethodReference(MethodReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiMethodReferenceExpression expression2 = instruction.getExpression();
        DfaValue qualifier = memState.pop();
        StandardInstructionVisitor.dropLocality(qualifier, memState);
        this.handleMethodReference(qualifier, expression2, runner, memState);
        this.pushExpressionResult(runner.getFactory().getObjectType(expression2.getFunctionalInterfaceType(), Nullability.NOT_NULL), instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void handleMethodReference(DfaValue qualifier, PsiMethodReferenceExpression methodRef, DataFlowRunner runner, DfaMemoryState state) {
        PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (sam2 == null || PsiType.VOID.equals((Object)sam2.getReturnType())) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        if (method == null || !JavaMethodContractUtil.isPure(method)) {
            return;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = StandardInstructionVisitor.getMethodReferenceCallArguments(methodRef, qualifier, runner, sam2, method, substitutor);
        this.dereference(state, callArguments.myQualifier, NullabilityProblemKind.callMethodRefNPE.problem(methodRef, null));
        if (contracts2.isEmpty()) {
            return;
        }
        PsiType returnType = substitutor.substitute(method.getReturnType());
        DfaTypeValue defaultResult = runner.getFactory().getObjectType(returnType, DfaPsiUtil.getElementNullability(returnType, (PsiModifierListOwner)method));
        Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(state.createClosureState(), callArguments));
        for (MethodContract methodContract : contracts2) {
            HashSet<DfaMemoryState> results = new HashSet<DfaMemoryState>();
            currentStates = this.addContractResults(methodContract, currentStates, runner.getFactory(), results, defaultResult, (PsiExpression)methodRef);
            for (DfaMemoryState result : results) {
                this.pushExpressionResult(result.pop(), new ResultOfInstruction((PsiExpression)methodRef), result);
            }
        }
        for (DfaCallState dfaCallState : currentStates) {
            this.pushExpressionResult(defaultResult, new ResultOfInstruction((PsiExpression)methodRef), dfaCallState.myMemoryState);
        }
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(PsiMethodReferenceExpression methodRef, DfaValue qualifier, DataFlowRunner runner, PsiMethod sam2, PsiMethod method, PsiSubstitutor substitutor) {
        PsiParameter[] samParameters = sam2.getParameterList().getParameters();
        boolean isStatic = method.hasModifierProperty("static");
        boolean instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        Object[] arguments = new DfaValue[parameters2.length];
        Arrays.fill(arguments, runner.getFactory().getUnknown());
        for (int i = 0; i < samParameters.length; ++i) {
            DfaTypeValue value2 = runner.getFactory().getObjectType(substitutor.substitute(samParameters[i].getType()), DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)methodRef, i));
            if (i == 0 && !isStatic && !instanceBound) {
                qualifier = value2;
                continue;
            }
            int idx = i - (isStatic || instanceBound ? 0 : 1);
            if (idx >= arguments.length) break;
            if (parameters2[idx].getType() instanceof PsiEllipsisType) continue;
            arguments[idx] = value2;
        }
        return new DfaCallArguments(qualifier, (DfaValue[])arguments, MutationSignature.fromMethod(method));
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiType type2 = instruction.getCastTo();
        DfaControlTransferValue transfer = instruction.getCastExceptionTransfer();
        DfaValueFactory factory = runner.getFactory();
        PsiType fromType = instruction.getCasted().getType();
        TypeConstraint constraint = TypeConstraints.instanceOf(type2);
        boolean castPossible = true;
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
        if (transfer != null) {
            DfaValue value2;
            DfaMemoryState castFail = memState.createCopy();
            if (fromType != null && type2.isConvertibleFrom(fromType)) {
                if (!StandardInstructionVisitor.castTopOfStack(factory, memState, constraint)) {
                    castPossible = false;
                } else {
                    result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
                    value2 = memState.pop();
                    this.pushExpressionResult(value2, instruction, memState);
                }
            }
            value2 = castFail.peek();
            DfaCondition notNullCondition = value2.cond(RelationType.NE, factory.getNull());
            DfaCondition notTypeCondition = value2.cond(RelationType.IS_NOT, factory.getObjectType(type2, Nullability.NOT_NULL));
            if (castFail.applyCondition(notNullCondition) && castFail.applyCondition(notTypeCondition)) {
                List<DfaInstructionState> states = transfer.dispatch(castFail, runner);
                for (DfaInstructionState cceState : states) {
                    cceState.getMemoryState().markEphemeral();
                }
                result.addAll(states);
            }
        } else {
            if (fromType != null && type2.isConvertibleFrom(fromType) && !StandardInstructionVisitor.castTopOfStack(factory, memState, constraint)) {
                castPossible = false;
            }
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
            DfaValue value3 = memState.pop();
            this.pushExpressionResult(value3, instruction, memState);
        }
        this.onTypeCast((PsiTypeCastExpression)instruction.getExpression(), memState, castPossible);
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static boolean castTopOfStack(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, @NotNull TypeConstraint type2) {
        DfaValue value2;
        DfType dfType;
        DfType result;
        if (factory == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(6);
        }
        if (!(result = (dfType = state.getDfType(value2 = state.peek())).meet(type2.asDfType())).equals(dfType)) {
            if (result == DfTypes.NULL || !state.meetDfType(value2, result)) {
                return false;
            }
            if (!(value2 instanceof DfaVariableValue)) {
                state.pop();
                state.push(factory.fromDfType(result));
            }
        }
        return true;
    }

    protected void onTypeCast(PsiTypeCastExpression castExpression, DfaMemoryState state, boolean castPossible) {
    }

    protected void onMethodCall(@NotNull DfaValue result, @NotNull PsiExpression expression2, @NotNull DfaCallArguments arguments, @NotNull DfaMemoryState memState) {
        if (result == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(7);
        }
        if (expression2 == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(9);
        }
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(10);
        }
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaCallArguments callArguments = this.popCall(instruction, factory, memState);
        LinkedHashSet<DfaMemoryState> finalStates = new LinkedHashSet<DfaMemoryState>();
        Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
        DfaValue defaultResult = StandardInstructionVisitor.getMethodResultValue(instruction, callArguments, memState, factory);
        Object expression2 = instruction.getExpression();
        if (callArguments.myArguments != null && !(defaultResult.getDfType() instanceof DfConstantType)) {
            for (MethodContract contract : instruction.getContracts()) {
                currentStates = this.addContractResults(contract, currentStates, factory, (Set<DfaMemoryState>)finalStates, defaultResult, (PsiExpression)expression2);
                if (currentStates.size() + finalStates.size() <= 300) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                }
                finalStates.clear();
                currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
                break;
            }
        }
        for (DfaCallState callState : currentStates) {
            callState.myMemoryState.push(defaultResult);
            finalStates.add(callState.myMemoryState);
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (expression2 != null) {
                this.onMethodCall(state.peek(), (PsiExpression)expression2, callArguments, state);
            }
            callArguments.flush(state);
            this.pushExpressionResult(state.pop(), instruction, state);
            result[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @NotNull
    protected DfaCallArguments popCall(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState) {
        DfaValue[] argValues = this.popCallArguments(instruction, factory, memState);
        DfaValue qualifier = this.popQualifier(instruction, memState, argValues);
        return new DfaCallArguments(qualifier, argValues, instruction.getMutationSignature());
    }

    private DfaValue @Nullable [] popCallArguments(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState) {
        int paramCount;
        int argCount = instruction.getArgCount();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        DfaValue[] argValues = null;
        PsiParameterList paramList = null;
        if (method != null && ((paramCount = (paramList = method.getParameterList()).getParametersCount()) == argCount || method.isVarArgs() && argCount >= paramCount - 1)) {
            argValues = new DfaValue[paramCount];
            if (varargCall) {
                PsiType arrayType = Objects.requireNonNull(paramList.getParameter(paramCount - 1)).getType();
                DfType dfType = SpecialField.ARRAY_LENGTH.asDfType(DfTypes.intValue(argCount - paramCount + 1), arrayType);
                argValues[paramCount - 1] = factory.fromDfType(dfType);
            }
        }
        for (int i = 0; i < argCount; ++i) {
            DfaValue arg = memState.pop();
            int paramIndex = argCount - i - 1;
            if (!instruction.getMutationSignature().isPure() && !instruction.getMutationSignature().equals(MutationSignature.pure().alsoMutatesArg(paramIndex)) || StandardInstructionVisitor.mayLeakFromType(instruction.getResultType())) {
                arg = StandardInstructionVisitor.dropLocality(arg, memState);
            }
            PsiElement anchor = instruction.getArgumentAnchor(paramIndex);
            if (instruction.getContext() instanceof PsiMethodReferenceExpression) {
                Nullability nullability;
                PsiParameter parameter2;
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)instruction.getContext();
                if (paramList != null && (parameter2 = paramList.getParameter(paramIndex)) != null) {
                    arg = DfaUtil.boxUnbox(arg, parameter2.getType());
                }
                if ((nullability = instruction.getArgRequiredNullability(paramIndex)) == Nullability.NOT_NULL) {
                    arg = this.dereference(memState, arg, NullabilityProblemKind.passingToNotNullMethodRefParameter.problem(methodRef, null));
                } else if (nullability == Nullability.UNKNOWN) {
                    this.checkNotNullable(memState, arg, NullabilityProblemKind.passingToNonAnnotatedMethodRefParameter.problem(methodRef, null));
                }
            }
            if (instruction.getMutationSignature().mutatesArg(paramIndex) && Mutability.fromDfType(memState.getDfType(arg)).isUnmodifiable()) {
                this.reportMutabilityViolation(false, anchor);
                DfType dfType = memState.getDfType(arg);
                if (dfType instanceof DfReferenceType) {
                    memState.setDfType(arg, ((DfReferenceType)dfType).dropMutability().meet(Mutability.MUTABLE.asDfType()));
                }
            }
            if (argValues == null || paramIndex >= argValues.length - 1 && varargCall) continue;
            argValues[paramIndex] = arg;
        }
        return argValues;
    }

    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(11);
        }
    }

    private DfaValue popQualifier(@NotNull MethodCallInstruction instruction, @NotNull DfaMemoryState memState, DfaValue @Nullable [] argValues) {
        PsiMethod method;
        if (instruction == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(12);
        }
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(13);
        }
        DfaValue value2 = memState.pop();
        if (instruction.getContext() instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression context = (PsiMethodReferenceExpression)instruction.getContext();
            value2 = this.dereference(memState, value2, NullabilityProblemKind.callMethodRefNPE.problem(context, null));
        }
        DfType dfType = memState.getDfType(value2);
        if (instruction.getMutationSignature().mutatesThis() && Mutability.fromDfType(dfType).isUnmodifiable() && (method = instruction.getTargetMethod()) != null && JavaMethodContractUtil.getContractInfo(method).isExplicit()) {
            this.reportMutabilityViolation(true, instruction.getContext());
            if (dfType instanceof DfReferenceType) {
                memState.setDfType(value2, ((DfReferenceType)dfType).dropMutability().meet(Mutability.MUTABLE.asDfType()));
            }
        }
        if (!(value2.getType() instanceof PsiArrayType) && (TypeConstraint.fromDfType(dfType).isComparedByEquals() || StandardInstructionVisitor.mayLeakThis(instruction, memState, argValues))) {
            value2 = StandardInstructionVisitor.dropLocality(value2, memState);
        }
        return value2;
    }

    private static boolean mayLeakThis(@NotNull MethodCallInstruction instruction, @NotNull DfaMemoryState memState, DfaValue @Nullable [] argValues) {
        MutationSignature signature;
        if (instruction == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(14);
        }
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(15);
        }
        if ((signature = instruction.getMutationSignature()) == MutationSignature.unknown()) {
            return true;
        }
        if (StandardInstructionVisitor.mayLeakFromType(instruction.getResultType())) {
            return true;
        }
        if (argValues == null) {
            return signature.isPure() || signature.equals(MutationSignature.pure().alsoMutatesThis());
        }
        for (int i = 0; i < argValues.length; ++i) {
            PsiType type2;
            if (!signature.mutatesArg(i) || !StandardInstructionVisitor.mayLeakFromType(type2 = memState.getPsiType(argValues[i]))) continue;
            return true;
        }
        return false;
    }

    private static boolean mayLeakFromType(PsiType type2) {
        if (type2 == null) {
            return true;
        }
        return !((type2 = type2.getDeepComponentType()) instanceof PsiPrimitiveType) && !TypeUtils.isJavaLangString(type2);
    }

    @Override
    public DfaInstructionState[] visitPush(ExpressionPushingInstruction<?> instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue value2) {
        DfaVariableValue qualifier;
        if (value2 instanceof DfaVariableValue && StandardInstructionVisitor.mayLeakFromType(value2.getType()) && (qualifier = ((DfaVariableValue)value2).getQualifier()) != null) {
            StandardInstructionVisitor.dropLocality(qualifier, memState);
        }
        return super.visitPush(instruction, runner, memState, value2);
    }

    private Set<DfaCallState> addContractResults(MethodContract contract, Set<DfaCallState> states, DfaValueFactory factory, Set<DfaMemoryState> finalStates, DfaValue defaultResult, PsiExpression expression2) {
        if (contract.isTrivial()) {
            for (DfaCallState callState : states) {
                DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, callState);
                this.pushExpressionResult(result, new ResultOfInstruction(expression2), callState.myMemoryState);
                finalStates.add(callState.myMemoryState);
            }
            return Collections.emptySet();
        }
        LinkedHashSet<DfaCallState> falseStates = new LinkedHashSet<DfaCallState>();
        for (DfaCallState callState : states) {
            DfaMemoryState state = callState.myMemoryState;
            DfaCallArguments arguments = callState.myCallArguments;
            for (ContractValue contractValue : contract.getConditions()) {
                DfaCondition condition2 = contractValue.makeCondition(factory, callState.myCallArguments);
                DfaMemoryState falseState = state.createCopy();
                DfaCondition falseCondition = condition2.negate();
                if (contract.getReturnValue().isFail() ? falseState.applyCondition(falseCondition) : falseState.applyContractCondition(falseCondition)) {
                    DfaCallArguments falseArguments = contractValue.updateArguments(arguments, true);
                    falseStates.add(new DfaCallState(falseState, falseArguments));
                }
                if (!state.applyContractCondition(condition2)) {
                    state = null;
                    break;
                }
                arguments = contractValue.updateArguments(arguments, false);
            }
            if (state == null) continue;
            DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, new DfaCallState(state, arguments));
            result = DfaUtil.boxUnbox(result, expression2.getType());
            state.push(result);
            finalStates.add(state);
        }
        return falseStates;
    }

    private <T extends PsiElement> DfaValue dereference(DfaMemoryState memState, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<T> problem) {
        boolean ok = this.checkNotNullable(memState, value2, problem);
        if (value2 instanceof DfaTypeValue) {
            DfType dfType = value2.getDfType().meet(DfTypes.NOT_NULL_OBJECT);
            return value2.getFactory().fromDfType(dfType == DfTypes.BOTTOM ? DfTypes.NOT_NULL_OBJECT : dfType);
        }
        if (ok) {
            return value2;
        }
        if (memState.isNull(value2) && problem != null && problem.getKind() == NullabilityProblemKind.nullableFunctionReturn) {
            return value2.getFactory().fromDfType(DfTypes.NOT_NULL_OBJECT);
        }
        if (value2 instanceof DfaVariableValue) {
            DfType dfType = memState.getDfType(value2);
            if (dfType == DfTypes.NULL) {
                memState.setDfType(value2, DfTypes.NOT_NULL_OBJECT);
            } else {
                memState.meetDfType(value2, DfTypes.NOT_NULL_OBJECT);
            }
        }
        return value2;
    }

    @NotNull
    private static PsiMethod findSpecificMethod(PsiElement context, @NotNull PsiMethod method, @NotNull DfaMemoryState state, @Nullable DfaValue qualifier) {
        if (method == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(16);
        }
        if (state == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(17);
        }
        if (qualifier == null || !PsiUtil.canBeOverridden((PsiMethod)method)) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(18);
            }
            return psiMethod;
        }
        PsiExpression qualifierExpression2 = null;
        if (context instanceof PsiMethodCallExpression) {
            qualifierExpression2 = ((PsiMethodCallExpression)context).getMethodExpression().getQualifierExpression();
        } else if (context instanceof PsiMethodReferenceExpression) {
            qualifierExpression2 = ((PsiMethodReferenceExpression)context).getQualifierExpression();
        }
        if (qualifierExpression2 instanceof PsiSuperExpression) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(19);
            }
            return psiMethod;
        }
        PsiType type2 = state.getPsiType(qualifier);
        PsiMethod psiMethod = MethodUtils.findSpecificMethod(method, type2);
        if (psiMethod == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(20);
        }
        return psiMethod;
    }

    @NotNull
    private static DfaValue getMethodResultValue(MethodCallInstruction instruction, @NotNull DfaCallArguments callArguments, DfaMemoryState state, DfaValueFactory factory) {
        PsiMethod method;
        VariableDescriptor descriptor;
        DfType dfType;
        CustomMethodHandlers.CustomMethodHandler handler;
        PsiMethod method2;
        if (callArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(21);
        }
        if (callArguments.myArguments != null && (method2 = instruction.getTargetMethod()) != null && (handler = CustomMethodHandlers.find(method2)) != null && (dfType = handler.getMethodResult(callArguments, state, factory, method2)) != DfTypes.TOP) {
            DfaTypeValue dfaTypeValue = factory.fromDfType(dfType);
            if (dfaTypeValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(22);
            }
            return dfaTypeValue;
        }
        DfaValue qualifierValue = callArguments.myQualifier;
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        PsiType type2 = instruction.getResultType();
        if (precalculated != null) {
            DfaValue dfaValue = DfaUtil.boxUnbox(StandardInstructionVisitor.getPrecalculatedResult(qualifierValue, state, factory, precalculated), type2);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(23);
            }
            return dfaValue;
        }
        SpecialField field = SpecialField.findSpecialField((PsiElement)instruction.getTargetMethod());
        if (field != null) {
            DfaValue dfaValue = DfaUtil.boxUnbox(factory.fromDfType(field.getFromQualifier(state.getDfType(qualifierValue))), type2);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(24);
            }
            return dfaValue;
        }
        if (instruction.getContext() instanceof PsiMethodReferenceExpression && qualifierValue instanceof DfaVariableValue && (descriptor = DfaExpressionFactory.getAccessedVariableOrGetter((PsiElement)(method = instruction.getTargetMethod()))) != null) {
            DfaValue dfaValue = descriptor.createValue(factory, qualifierValue, true);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(25);
            }
            return dfaValue;
        }
        if (type2 != null && !(type2 instanceof PsiPrimitiveType)) {
            DfType dfType2;
            Nullability nullability = instruction.getReturnNullability();
            PsiMethod targetMethod = instruction.getTargetMethod();
            Mutability mutable = Mutability.UNKNOWN;
            if (targetMethod != null) {
                mutable = Mutability.getMutability((PsiModifierListOwner)targetMethod);
                PsiMethod realMethod = StandardInstructionVisitor.findSpecificMethod(instruction.getContext(), targetMethod, state, qualifierValue);
                if (realMethod != targetMethod) {
                    nullability = DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)realMethod);
                    mutable = Mutability.getMutability((PsiModifierListOwner)realMethod);
                    PsiType returnType = realMethod.getReturnType();
                    if (returnType != null && TypeConversionUtil.erasure((PsiType)type2).isAssignableFrom(returnType)) {
                        type2 = returnType;
                    }
                }
                if (nullability == Nullability.UNKNOWN) {
                    nullability = factory.suggestNullabilityForNonAnnotatedMember((PsiModifierListOwner)targetMethod);
                }
            }
            DfType dfType3 = dfType2 = instruction.getContext() instanceof PsiNewExpression ? TypeConstraints.exact(type2).asDfType().meet(DfTypes.NOT_NULL_OBJECT) : TypeConstraints.instanceOf(type2).asDfType().meet(DfaNullability.fromNullability(nullability).asDfType());
            if (instruction.getMutationSignature().isPure() && instruction.getContext() instanceof PsiNewExpression && !TypeConstraint.fromDfType(dfType2).isComparedByEquals()) {
                dfType2 = dfType2.meet(DfTypes.LOCAL_OBJECT);
            }
            DfaTypeValue dfaTypeValue = factory.fromDfType(dfType2.meet(mutable.asDfType()));
            if (dfaTypeValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(26);
            }
            return dfaTypeValue;
        }
        LongRangeSet range = LongRangeSet.fromType(type2);
        if (range != null) {
            PsiCall call = instruction.getCallExpression();
            if (call instanceof PsiMethodCallExpression) {
                range = range.intersect(LongRangeSet.fromPsiElement((PsiModifierListOwner)call.resolveMethod()));
            }
            DfaTypeValue dfaTypeValue = factory.fromDfType(DfTypes.rangeClamped(range, PsiType.LONG.equals((Object)type2)));
            if (dfaTypeValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(27);
            }
            return dfaTypeValue;
        }
        DfaTypeValue dfaTypeValue = factory.getUnknown();
        if (dfaTypeValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(28);
        }
        return dfaTypeValue;
    }

    private static DfaValue getPrecalculatedResult(@Nullable DfaValue qualifierValue, DfaMemoryState state, DfaValueFactory factory, DfaValue precalculated) {
        PsiType javaLangClass;
        TypeConstraint fact;
        PsiModifierListOwner psi;
        if (precalculated instanceof DfaVariableValue && qualifierValue != null && (psi = ((DfaVariableValue)precalculated).getPsiVariable()) instanceof PsiMethod && PsiTypesUtil.isGetClass((PsiMethod)((PsiMethod)psi)) && (fact = TypeConstraint.fromDfType(state.getDfType(qualifierValue))) instanceof TypeConstraint.Exact && (javaLangClass = precalculated.getType()) != null) {
            return factory.getConstant(fact.getPsiType(factory.getProject()), javaLangClass);
        }
        return precalculated;
    }

    protected boolean checkNotNullable(DfaMemoryState state, @NotNull DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        boolean notNullable;
        if (value2 == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(29);
        }
        if ((notNullable = state.checkNotNullable(value2)) && problem != null && problem.thrownException() != null) {
            state.applyCondition(value2.cond(RelationType.NE, value2.getFactory().getNull()));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitConvertPrimitive(PrimitiveConversionInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue value2 = state.pop();
        DfaValue result = StandardInstructionVisitor.getConversionResult(value2, instruction.getTargetType(), runner.getFactory(), state);
        this.pushExpressionResult(result, instruction, state);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, state);
    }

    private static DfaValue getConversionResult(DfaValue value2, PsiPrimitiveType type2, DfaValueFactory factory, DfaMemoryState state) {
        if (value2 instanceof DfaBinOpValue) {
            value2 = ((DfaBinOpValue)value2).tryReduceOnCast(state, type2);
        }
        if (value2 instanceof DfaVariableValue && type2 != null && (type2.equals((Object)value2.getType()) || TypeConversionUtil.isSafeConversion((PsiType)type2, (PsiType)value2.getType()) && TypeConversionUtil.isSafeConversion((PsiType)PsiType.INT, (PsiType)type2))) {
            return value2;
        }
        DfType dfType = state.getDfType(value2);
        if (dfType instanceof DfConstantType && type2 != null) {
            Object casted = TypeConversionUtil.computeCastTo(((DfConstantType)dfType).getValue(), (PsiType)type2);
            return factory.getConstant(casted, (PsiType)type2);
        }
        if (TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
            LongRangeSet range = DfLongType.extractRange(dfType);
            return factory.fromDfType(DfTypes.rangeClamped(range.castTo(type2), PsiType.LONG.equals((Object)type2)));
        }
        return factory.getUnknown();
    }

    @Override
    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        NullabilityProblemKind.NullabilityProblem<?> problem = instruction.getProblem();
        if (problem.thrownException() == null) {
            this.checkNotNullable(memState, memState.peek(), problem);
        } else {
            boolean isNull;
            DfaControlTransferValue transfer = instruction.getOnNullTransfer();
            DfaValue value2 = memState.pop();
            boolean bl = isNull = this.myStopAnalysisOnNpe && memState.isNull(value2);
            if (transfer == null) {
                memState.push(this.dereference(memState, value2, problem));
                if (isNull) {
                    return DfaInstructionState.EMPTY_ARRAY;
                }
            } else {
                DfaValueFactory factory;
                ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
                DfaMemoryState nullState = memState.createCopy();
                memState.push(this.dereference(memState, value2, problem));
                if (!isNull) {
                    result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
                }
                if (nullState.applyCondition(value2.eq((factory = runner.getFactory()).getNull()))) {
                    List<DfaInstructionState> dispatched = transfer.dispatch(nullState, runner);
                    for (DfaInstructionState npeState : dispatched) {
                        npeState.getMemoryState().markEphemeral();
                    }
                    result.addAll(dispatched);
                }
                return result.toArray(DfaInstructionState.EMPTY_ARRAY);
            }
        }
        return super.visitCheckNotNull(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue = memState.pop();
        DfaMemoryState falseState = memState.createCopy();
        DfaValueFactory factory = runner.getFactory();
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        if (memState.applyCondition(dfaValue.eq(factory.getBoolean(false)))) {
            this.pushExpressionResult(factory.getBoolean(true), instruction, memState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
        }
        if (falseState.applyCondition(dfaValue.eq(factory.getBoolean(true)))) {
            this.pushExpressionResult(factory.getBoolean(false), instruction, falseState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), falseState));
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        RelationType relationType = RelationType.fromElementType(opSign == BinopInstruction.STRING_EQUALITY_BY_CONTENT ? JavaTokenType.EQEQ : opSign);
        if (relationType != null) {
            return this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft, relationType);
        }
        PsiType type2 = instruction.getResultType();
        if (PsiType.BOOLEAN.equals((Object)type2)) {
            return this.handleAndOrBinop(instruction, runner, memState, dfaRight, dfaLeft);
        }
        DfaValue result = runner.getFactory().getUnknown();
        if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            boolean isLong = PsiType.LONG.equals((Object)type2);
            if (instruction.isWidened()) {
                LongRangeSet rightRange;
                LongRangeSet leftRange = DfLongType.extractRange(memState.getDfType(dfaLeft));
                LongRangeSet range = leftRange.wideBinOpFromToken(opSign, rightRange = DfLongType.extractRange(memState.getDfType(dfaRight)), isLong);
                if (range == null) {
                    range = LongRangeSet.all();
                }
                result = runner.getFactory().fromDfType(DfTypes.rangeClamped(range, isLong));
            } else {
                result = runner.getFactory().getBinOpFactory().create(dfaLeft, dfaRight, memState, isLong, opSign);
            }
        }
        if (DfaTypeValue.isUnknown(result) && JavaTokenType.PLUS == opSign && TypeUtils.isJavaLangString(type2)) {
            result = instruction.isWidened() ? runner.getFactory().getObjectType(type2, Nullability.NOT_NULL) : StandardInstructionVisitor.concatStrings(dfaLeft, dfaRight, memState, type2, runner.getFactory());
        }
        this.pushExpressionResult(result, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private DfaInstructionState @NotNull [] handleAndOrBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft) {
        IElementType opSign = instruction.getOperationSign();
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        if (opSign == JavaTokenType.AND || opSign == JavaTokenType.OR) {
            DfaCondition cond;
            boolean or = opSign == JavaTokenType.OR;
            DfaMemoryState copy = memState.createCopy();
            if (copy.applyCondition(cond = dfaRight.eq(runner.getFactory().getBoolean(or)))) {
                result.add(this.makeBooleanResult(instruction, runner, copy, ThreeState.fromBoolean((boolean)or)));
            }
            if (memState.applyCondition(cond.negate())) {
                this.pushExpressionResult(dfaLeft, instruction, memState);
                result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
            }
        } else {
            result.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.UNSURE));
        }
        DfaInstructionState[] dfaInstructionStateArray = result.toArray(DfaInstructionState.EMPTY_ARRAY);
        if (dfaInstructionStateArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(30);
        }
        return dfaInstructionStateArray;
    }

    @NotNull
    private static DfaValue concatStrings(DfaValue left, DfaValue right, DfaMemoryState memState, PsiType stringType, DfaValueFactory factory) {
        String leftString = DfConstantType.getConstantOfType(memState.getDfType(left), String.class);
        String rightString = DfConstantType.getConstantOfType(memState.getDfType(right), String.class);
        if (leftString != null && rightString != null && leftString.length() + rightString.length() <= 256) {
            DfaTypeValue dfaTypeValue = factory.getConstant(leftString + rightString, stringType);
            if (dfaTypeValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(31);
            }
            return dfaTypeValue;
        }
        DfaValue leftLength = SpecialField.STRING_LENGTH.createValue(factory, left);
        DfaValue rightLength = SpecialField.STRING_LENGTH.createValue(factory, right);
        LongRangeSet leftRange = DfIntType.extractRange(memState.getDfType(leftLength));
        LongRangeSet rightRange = DfIntType.extractRange(memState.getDfType(rightLength));
        LongRangeSet resultRange = leftRange.plus(rightRange, false);
        DfaTypeValue dfaTypeValue = factory.fromDfType(SpecialField.STRING_LENGTH.asDfType(DfTypes.intRange(resultRange), stringType));
        if (dfaTypeValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(32);
        }
        return dfaTypeValue;
    }

    private DfaInstructionState @NotNull [] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, RelationType relationType) {
        DfaValueFactory factory = runner.getFactory();
        if ((relationType == RelationType.EQ || relationType == RelationType.NE) && instruction.getOperationSign() != BinopInstruction.STRING_EQUALITY_BY_CONTENT && memState.shouldCompareByEquals(dfaLeft, dfaRight)) {
            DfaCondition condition2;
            ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
            DfaMemoryState equality = memState.createCopy();
            if (equality.applyCondition(condition2 = dfaLeft.eq(dfaRight))) {
                states.add(this.makeBooleanResult(instruction, runner, equality, ThreeState.UNSURE));
            }
            if (memState.applyCondition(condition2.negate())) {
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((relationType == RelationType.NE ? 1 : 0) != 0)));
            }
            DfaInstructionState[] dfaInstructionStateArray = states.toArray(DfaInstructionState.EMPTY_ARRAY);
            if (dfaInstructionStateArray == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(33);
            }
            return dfaInstructionStateArray;
        }
        RelationType[] relations = StandardInstructionVisitor.splitRelation(relationType);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(relations.length);
        for (int i = 0; i < relations.length; ++i) {
            DfaMemoryState copy;
            RelationType relation = relations[i];
            DfaCondition condition3 = dfaLeft.cond(relation, dfaRight);
            if (condition3 == DfaCondition.getFalse()) continue;
            if (condition3 == DfaCondition.getTrue()) {
                DfaInstructionState state = this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((boolean)relationType.isSubRelation(relation)));
                DfaInstructionState[] dfaInstructionStateArray = new DfaInstructionState[]{state};
                if (dfaInstructionStateArray == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(34);
                }
                return dfaInstructionStateArray;
            }
            DfaMemoryState dfaMemoryState = copy = i == relations.length - 1 && !states.isEmpty() ? memState : memState.createCopy();
            if (!copy.applyCondition(condition3)) continue;
            boolean isTrue = relationType.isSubRelation(relation);
            states.add(this.makeBooleanResult(instruction, runner, copy, ThreeState.fromBoolean((boolean)isTrue)));
        }
        if (states.isEmpty()) {
            this.pushExpressionResult(factory.getBoolean(false), instruction, memState);
            DfaInstructionState[] dfaInstructionStateArray = StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
            if (dfaInstructionStateArray == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(35);
            }
            return dfaInstructionStateArray;
        }
        DfaInstructionState[] dfaInstructionStateArray = states.toArray(DfaInstructionState.EMPTY_ARRAY);
        if (dfaInstructionStateArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(36);
        }
        return dfaInstructionStateArray;
    }

    private static RelationType @NotNull [] splitRelation(RelationType relationType) {
        switch (relationType) {
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                RelationType[] relationTypeArray = new RelationType[]{RelationType.LT, RelationType.GT, RelationType.EQ};
                if (relationTypeArray == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(37);
                }
                return relationTypeArray;
            }
        }
        RelationType[] relationTypeArray = new RelationType[]{relationType, relationType.getNegated()};
        if (relationTypeArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(38);
        }
        return relationTypeArray;
    }

    @Override
    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        boolean useful;
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        DfaValueFactory factory = runner.getFactory();
        boolean unknownTargetType = false;
        DfaCondition condition2 = null;
        if (instruction.isClassObjectCheck()) {
            PsiType type2 = DfConstantType.getConstantOfType(memState.getDfType(dfaRight), PsiType.class);
            if (type2 == null || type2 instanceof PsiPrimitiveType) {
                condition2 = dfaLeft.cond(RelationType.NE, factory.getNull());
                unknownTargetType = true;
            } else {
                dfaRight = factory.getObjectType(type2, Nullability.NOT_NULL);
            }
        }
        if (condition2 == null) {
            condition2 = dfaLeft.cond(RelationType.IS, dfaRight);
        }
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
        DfType leftType = memState.getDfType(dfaLeft);
        if (condition2 == DfaCondition.getUnknown()) {
            if (leftType != DfTypes.TOP && dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
                TypeConstraint left = TypeConstraint.fromDfType(leftType);
                TypeConstraint right = TypeConstraint.fromDfType(dfaRight.getDfType());
                useful = !right.isSuperConstraintOf(left);
            } else {
                useful = true;
            }
            states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.UNSURE));
        } else {
            DfaMemoryState trueState = memState.createCopy();
            useful = unknownTargetType;
            if (trueState.applyCondition(condition2)) {
                states.add(this.makeBooleanResult(instruction, runner, trueState, unknownTargetType ? ThreeState.UNSURE : ThreeState.YES));
            }
            DfaCondition negated = condition2.negate();
            if (unknownTargetType ? memState.applyContractCondition(negated) : memState.applyCondition(negated)) {
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.NO));
                if (!memState.isNull(dfaLeft)) {
                    useful = true;
                } else if (DfaNullability.fromDfType(leftType) == DfaNullability.UNKNOWN) {
                    memState.markEphemeral();
                }
            }
        }
        if (useful) {
            this.myUsefulInstanceofs.add(instruction);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private DfaInstructionState makeBooleanResult(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, @NotNull ThreeState result) {
        if (result == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(39);
        }
        DfaTypeValue value2 = result == ThreeState.UNSURE ? runner.getFactory().getUnknown() : runner.getFactory().getBoolean(result.toBoolean());
        this.pushExpressionResult(value2, instruction, memState);
        return new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaDest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpecificMethod";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultValue";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAndOrBinop";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "concatStrings";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "handleRelationBinop";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayElementAssignability";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "castTopOfStack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onMethodCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportMutabilityViolation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "popQualifier";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mayLeakThis";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMethodResultValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "makeBooleanResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

