/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u0014J/\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001c\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u001a\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "", "mutatesThis", "", "mutatedRefs", "", "Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "singleCall", "(ZLjava/util/List;Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;)V", "getMutatedRefs$intellij_java_analysis_impl", "()Ljava/util/List;", "getMutatesThis$intellij_java_analysis_impl", "()Z", "getSingleCall$intellij_java_analysis_impl", "()Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "component1", "component1$intellij_java_analysis_impl", "component2", "component2$intellij_java_analysis_impl", "component3", "component3$intellij_java_analysis_impl", "copy", "equals", "other", "fromCalls", "Lcom/intellij/codeInspection/dataFlow/MutationSignature;", "currentMethod", "Lcom/intellij/psi/PsiMethod;", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "getMutationSignature", "method", "hashCode", "", "isLocalVarReference", "expression", "Lcom/intellij/psi/PsiExpression;", "scope", "isLocallyCreatedArray", "target", "Lcom/intellij/psi/PsiLocalVariable;", "mutatesNonLocals", "toString", "", "intellij.java.analysis.impl"})
public final class PurityInferenceResult {
    private final boolean mutatesThis;
    @NotNull
    private final List<ExpressionRange> mutatedRefs;
    @Nullable
    private final ExpressionRange singleCall;

    @NotNull
    public final MutationSignature getMutationSignature(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body2) {
        MutationSignature mutationSignature;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        if (this.mutatesNonLocals(method, body2)) {
            MutationSignature mutationSignature2 = MutationSignature.unknown();
            mutationSignature = mutationSignature2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature2, (String)"MutationSignature.unknown()");
        } else if (this.mutatesThis) {
            MutationSignature mutationSignature3 = this.fromCalls(method, body2).alsoMutatesThis();
            mutationSignature = mutationSignature3;
            Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature3, (String)"fromCalls(method, body).alsoMutatesThis()");
        } else {
            mutationSignature = this.fromCalls(method, body2);
        }
        return mutationSignature;
    }

    private final boolean mutatesNonLocals(PsiMethod method, Function0<? extends PsiCodeBlock> body2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.mutatedRefs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ExpressionRange range = (ExpressionRange)element$iv;
                    boolean bl2 = false;
                    if (!(!this.isLocalVarReference(range.restoreExpression((PsiCodeBlock)body2.invoke()), method))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final MutationSignature fromCalls(PsiMethod currentMethod, Function0<? extends PsiCodeBlock> body2) {
        PsiMethod method;
        PsiCall psiCall;
        if (this.singleCall == null) {
            MutationSignature mutationSignature = MutationSignature.pure();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature, (String)"MutationSignature.pure()");
            return mutationSignature;
        }
        PsiExpression psiExpression = this.singleCall.restoreExpression((PsiCodeBlock)body2.invoke());
        if (!(psiExpression instanceof PsiCall)) {
            psiExpression = null;
        }
        PsiCall psiCall2 = psiCall = (PsiCall)psiExpression;
        Object object = method = psiCall2 != null ? psiCall2.resolveMethod() : null;
        if (Intrinsics.areEqual((Object)method, (Object)currentMethod)) {
            if (!this.mutatesThis || psiCall instanceof PsiMethodCallExpression && ExpressionUtil.isEffectivelyUnqualified(((PsiMethodCallExpression)psiCall).getMethodExpression())) {
                MutationSignature mutationSignature = MutationSignature.pure();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature, (String)"MutationSignature.pure()");
                return mutationSignature;
            }
            MutationSignature mutationSignature = MutationSignature.unknown();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature, (String)"MutationSignature.unknown()");
            return mutationSignature;
        }
        MutationSignature mutationSignature = MutationSignature.fromCall(psiCall);
        Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature, (String)"MutationSignature.fromCall(psiCall)");
        MutationSignature signature = mutationSignature;
        if (Intrinsics.areEqual((Object)signature, (Object)MutationSignature.pure()) || Intrinsics.areEqual((Object)signature, (Object)MutationSignature.pure().alsoMutatesThis()) && psiCall instanceof PsiMethodCallExpression && ExpressionUtil.isEffectivelyUnqualified(((PsiMethodCallExpression)psiCall).getMethodExpression())) {
            MutationSignature mutationSignature2;
            if (currentMethod.isConstructor()) {
                MutationSignature mutationSignature3 = MutationSignature.pure();
                mutationSignature2 = mutationSignature3;
                Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature3, (String)"MutationSignature.pure()");
            } else {
                mutationSignature2 = signature;
            }
            return mutationSignature2;
        }
        MutationSignature mutationSignature4 = MutationSignature.unknown();
        Intrinsics.checkExpressionValueIsNotNull((Object)mutationSignature4, (String)"MutationSignature.unknown()");
        return mutationSignature4;
    }

    private final boolean isLocalVarReference(PsiExpression expression2, PsiMethod scope) {
        boolean bl;
        PsiExpression psiExpression = expression2;
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiElement psiElement = ((PsiReferenceExpression)expression2).resolve();
            boolean bl2 = false;
            boolean bl3 = false;
            PsiElement it = psiElement;
            boolean bl4 = false;
            bl = it instanceof PsiLocalVariable || it instanceof PsiParameter;
        } else if (psiExpression instanceof PsiArrayAccessExpression) {
            PsiExpression psiExpression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            if (!(psiExpression2 instanceof PsiReferenceExpression)) {
                psiExpression2 = null;
            }
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiExpression2;
            PsiElement psiElement = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
            boolean bl5 = false;
            boolean bl6 = false;
            PsiElement target = psiElement;
            boolean bl7 = false;
            bl = target instanceof PsiLocalVariable && this.isLocallyCreatedArray(scope, (PsiLocalVariable)target);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isLocallyCreatedArray(PsiMethod scope, PsiLocalVariable target) {
        PsiExpression initializer = target.getInitializer();
        if (initializer != null && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)((PsiElement)target), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)scope))).findAll()) {
            PsiAssignmentExpression assign;
            if (!(ref instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)ref)) || (assign = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ref), PsiAssignmentExpression.class)) != null && assign.getRExpression() instanceof PsiNewExpression) continue;
            return false;
        }
        return true;
    }

    public final boolean getMutatesThis$intellij_java_analysis_impl() {
        return this.mutatesThis;
    }

    @NotNull
    public final List<ExpressionRange> getMutatedRefs$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange getSingleCall$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    public PurityInferenceResult(boolean mutatesThis, @NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkParameterIsNotNull(mutatedRefs, (String)"mutatedRefs");
        this.mutatesThis = mutatesThis;
        this.mutatedRefs = mutatedRefs;
        this.singleCall = singleCall;
    }

    public final boolean component1$intellij_java_analysis_impl() {
        return this.mutatesThis;
    }

    @NotNull
    public final List<ExpressionRange> component2$intellij_java_analysis_impl() {
        return this.mutatedRefs;
    }

    @Nullable
    public final ExpressionRange component3$intellij_java_analysis_impl() {
        return this.singleCall;
    }

    @NotNull
    public final PurityInferenceResult copy(boolean mutatesThis, @NotNull List<ExpressionRange> mutatedRefs, @Nullable ExpressionRange singleCall) {
        Intrinsics.checkParameterIsNotNull(mutatedRefs, (String)"mutatedRefs");
        return new PurityInferenceResult(mutatesThis, mutatedRefs, singleCall);
    }

    public static /* synthetic */ PurityInferenceResult copy$default(PurityInferenceResult purityInferenceResult, boolean bl, List list, ExpressionRange expressionRange, int n, Object object) {
        if ((n & 1) != 0) {
            bl = purityInferenceResult.mutatesThis;
        }
        if ((n & 2) != 0) {
            list = purityInferenceResult.mutatedRefs;
        }
        if ((n & 4) != 0) {
            expressionRange = purityInferenceResult.singleCall;
        }
        return purityInferenceResult.copy(bl, list, expressionRange);
    }

    @NotNull
    public String toString() {
        return "PurityInferenceResult(mutatesThis=" + this.mutatesThis + ", mutatedRefs=" + this.mutatedRefs + ", singleCall=" + this.singleCall + ")";
    }

    public int hashCode() {
        int n = this.mutatesThis ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        List<ExpressionRange> list = this.mutatedRefs;
        ExpressionRange expressionRange = this.singleCall;
        return (n * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (expressionRange != null ? ((Object)expressionRange).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PurityInferenceResult)) break block3;
                PurityInferenceResult purityInferenceResult = (PurityInferenceResult)object;
                if (this.mutatesThis != purityInferenceResult.mutatesThis || !Intrinsics.areEqual(this.mutatedRefs, purityInferenceResult.mutatedRefs) || !Intrinsics.areEqual((Object)this.singleCall, (Object)purityInferenceResult.singleCall)) break block3;
            }
            return true;
        }
        return false;
    }
}

