/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfGenericObjectType
extends DfAntiConstantType<Object>
implements DfReferenceType {
    @NotNull
    private final TypeConstraint myConstraint;
    @NotNull
    private final DfaNullability myNullability;
    @NotNull
    private final Mutability myMutability;
    @Nullable
    private final SpecialField mySpecialField;
    @NotNull
    private final DfType mySpecialFieldType;
    private final boolean myLocal;

    DfGenericObjectType(@NotNull Set<Object> notValues, @NotNull TypeConstraint constraint, @NotNull DfaNullability nullability, @NotNull Mutability mutability, @Nullable SpecialField field, @NotNull DfType type2, boolean local) {
        if (notValues == null) {
            DfGenericObjectType.$$$reportNull$$$0(0);
        }
        if (constraint == null) {
            DfGenericObjectType.$$$reportNull$$$0(1);
        }
        if (nullability == null) {
            DfGenericObjectType.$$$reportNull$$$0(2);
        }
        if (mutability == null) {
            DfGenericObjectType.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            DfGenericObjectType.$$$reportNull$$$0(4);
        }
        super(notValues);
        assert (constraint != TypeConstraints.BOTTOM);
        this.myConstraint = constraint;
        this.myNullability = nullability;
        this.myMutability = mutability;
        this.mySpecialField = field;
        this.mySpecialFieldType = type2 instanceof DfReferenceType ? ((DfReferenceType)type2).dropSpecialField() : type2;
        this.myLocal = local;
    }

    @Override
    @NotNull
    public DfaNullability getNullability() {
        DfaNullability dfaNullability = this.myNullability;
        if (dfaNullability == null) {
            DfGenericObjectType.$$$reportNull$$$0(5);
        }
        return dfaNullability;
    }

    @Override
    @NotNull
    public TypeConstraint getConstraint() {
        TypeConstraint typeConstraint = this.myConstraint;
        if (typeConstraint == null) {
            DfGenericObjectType.$$$reportNull$$$0(6);
        }
        return typeConstraint;
    }

    @Override
    @NotNull
    public Mutability getMutability() {
        Mutability mutability = this.myMutability;
        if (mutability == null) {
            DfGenericObjectType.$$$reportNull$$$0(7);
        }
        return mutability;
    }

    @Override
    public boolean isLocal() {
        return this.myLocal;
    }

    @Override
    @Nullable
    public SpecialField getSpecialField() {
        return this.mySpecialField;
    }

    @Override
    @NotNull
    public DfType getSpecialFieldType() {
        DfType dfType = this.mySpecialFieldType;
        if (dfType == null) {
            DfGenericObjectType.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    @Override
    public DfType tryNegate() {
        if (this.myMutability != Mutability.UNKNOWN || this.myLocal || this.mySpecialField != null) {
            return null;
        }
        TypeConstraint negated = this.myConstraint.tryNegate();
        if (negated == null) {
            return null;
        }
        DfType result = negated.asDfType();
        return this.myNullability == DfaNullability.NOT_NULL ? result.join(DfTypes.NULL) : result.meet(DfTypes.NOT_NULL_OBJECT);
    }

    @Override
    @NotNull
    public Set<Object> getNotValues() {
        if (this.myNullability == DfaNullability.NOT_NULL) {
            HashSet<Object> values = new HashSet<Object>(this.myNotValues);
            values.add(null);
            Set<Object> set = Collections.unmodifiableSet(values);
            if (set == null) {
                DfGenericObjectType.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<Object> set = super.getNotValues();
        if (set == null) {
            DfGenericObjectType.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    @NotNull
    public DfReferenceType dropTypeConstraint() {
        return this.myConstraint == TypeConstraints.TOP ? this : new DfGenericObjectType(this.myNotValues, TypeConstraints.TOP, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropMutability() {
        return this.myMutability == Mutability.UNKNOWN ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, Mutability.UNKNOWN, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropLocality() {
        DfGenericObjectType dfGenericObjectType = this.myLocal ? new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, false) : this;
        if (dfGenericObjectType == null) {
            DfGenericObjectType.$$$reportNull$$$0(11);
        }
        return dfGenericObjectType;
    }

    @Override
    @NotNull
    public DfReferenceType dropNullability() {
        return this.myNullability == DfaNullability.UNKNOWN ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, DfaNullability.UNKNOWN, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropSpecialField() {
        return this.mySpecialField == null ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, null, DfTypes.BOTTOM, this.myLocal);
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(12);
        }
        if (other == DfTypes.BOTTOM) {
            return true;
        }
        if (other instanceof DfNullConstantType) {
            return this.getNullability() != DfaNullability.NOT_NULL;
        }
        if (!(other instanceof DfReferenceType)) {
            return false;
        }
        if (!this.myNotValues.isEmpty()) {
            if (other instanceof DfReferenceConstantType) {
                if (this.myNotValues.contains(((DfReferenceConstantType)other).getValue())) {
                    return false;
                }
            } else if (other instanceof DfGenericObjectType) {
                if (!((DfGenericObjectType)other).myNotValues.containsAll(this.myNotValues)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        DfReferenceType type2 = (DfReferenceType)other;
        if (this.isLocal() && !type2.isLocal()) {
            return false;
        }
        if (type2.getNullability() != this.getNullability() && this.getNullability() != DfaNullability.UNKNOWN && type2.getNullability() != DfaNullability.NOT_NULL) {
            return false;
        }
        if (!this.getConstraint().isSuperConstraintOf(type2.getConstraint())) {
            return false;
        }
        if (this.getMutability().ordinal() > type2.getMutability().ordinal()) {
            return false;
        }
        SpecialField sf = this.getSpecialField();
        if (sf != null) {
            if (sf != type2.getSpecialField()) {
                return false;
            }
            if (!this.getSpecialFieldType().isSuperType(type2.getSpecialFieldType())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMergeable(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(13);
        }
        if (!this.isSuperType(other)) {
            return false;
        }
        if (this.getNullability() == DfaNullability.UNKNOWN) {
            DfaNullability otherNullability = DfaNullability.fromDfType(other);
            return otherNullability != DfaNullability.NULL && otherNullability != DfaNullability.NULLABLE;
        }
        return true;
    }

    @Override
    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(14);
        }
        if (this.isSuperType(other)) {
            DfGenericObjectType dfGenericObjectType = this;
            if (dfGenericObjectType == null) {
                DfGenericObjectType.$$$reportNull$$$0(15);
            }
            return dfGenericObjectType;
        }
        if (other.isSuperType(this)) {
            DfType dfType = other;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        if (!(other instanceof DfReferenceType)) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(17);
            }
            return dfType;
        }
        if (other instanceof DfNullConstantType) {
            DfType dfType = other.join(this);
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(18);
            }
            return dfType;
        }
        DfReferenceType type2 = (DfReferenceType)other;
        TypeConstraint constraint = this.getConstraint().join(type2.getConstraint());
        DfaNullability nullability = this.getNullability().unite(type2.getNullability());
        Mutability mutability = this.getMutability().unite(type2.getMutability());
        boolean locality = this.isLocal() && type2.isLocal();
        SpecialField sf = Objects.equals(this.getSpecialField(), type2.getSpecialField()) ? this.getSpecialField() : null;
        DfType sfType = sf == null ? DfTypes.BOTTOM : this.getSpecialFieldType().join(type2.getSpecialFieldType());
        Set notValues = this.myNotValues;
        if (type2 instanceof DfGenericObjectType) {
            notValues = new THashSet((Collection)this.myNotValues);
            notValues.retainAll(((DfGenericObjectType)other).myNotValues);
        }
        if (type2 instanceof DfReferenceConstantType) {
            notValues = new THashSet((Collection)this.myNotValues);
            notValues.remove(((DfReferenceConstantType)type2).getValue());
        }
        return new DfGenericObjectType(notValues, constraint, nullability, mutability, sf, sfType, locality);
    }

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        DfType sfType;
        SpecialField sf;
        boolean locality;
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(19);
        }
        if (other instanceof DfConstantType) {
            DfType dfType = other.meet(this);
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(20);
            }
            return dfType;
        }
        if (this.isSuperType(other)) {
            DfType dfType = other;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(21);
            }
            return dfType;
        }
        if (other.isSuperType(this)) {
            DfGenericObjectType dfGenericObjectType = this;
            if (dfGenericObjectType == null) {
                DfGenericObjectType.$$$reportNull$$$0(22);
            }
            return dfGenericObjectType;
        }
        if (!(other instanceof DfReferenceType)) {
            DfType dfType = DfTypes.BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(23);
            }
            return dfType;
        }
        DfReferenceType type2 = (DfReferenceType)other;
        TypeConstraint constraint = this.getConstraint().meet(type2.getConstraint());
        if (constraint == TypeConstraints.BOTTOM) {
            DfType dfType = this.isSuperType(DfTypes.NULL) && other.isSuperType(DfTypes.NULL) ? DfTypes.NULL : DfTypes.BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(24);
            }
            return dfType;
        }
        DfaNullability nullability = this.getNullability().intersect(type2.getNullability());
        if (nullability == null) {
            DfType dfType = DfTypes.BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(25);
            }
            return dfType;
        }
        Mutability mutability = this.getMutability().intersect(type2.getMutability());
        boolean bl = locality = this.isLocal() || type2.isLocal();
        if (this.getSpecialField() == null) {
            sf = type2.getSpecialField();
            sfType = type2.getSpecialFieldType();
        } else if (type2.getSpecialField() == null) {
            sf = this.getSpecialField();
            sfType = this.getSpecialFieldType();
        } else {
            sf = this.getSpecialField();
            if (sf != type2.getSpecialField()) {
                DfType dfType = DfTypes.BOTTOM;
                if (dfType == null) {
                    DfGenericObjectType.$$$reportNull$$$0(26);
                }
                return dfType;
            }
            DfType dfType = sfType = sf == null ? DfTypes.BOTTOM : this.getSpecialFieldType().meet(type2.getSpecialFieldType());
        }
        if (sf != null && sfType == DfTypes.BOTTOM) {
            DfType dfType = DfTypes.BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(27);
            }
            return dfType;
        }
        Set notValues = this.myNotValues;
        if (type2 instanceof DfGenericObjectType) {
            Set otherNotValues = ((DfGenericObjectType)other).myNotValues;
            if (otherNotValues.containsAll(this.myNotValues)) {
                notValues = otherNotValues;
            } else if (!this.myNotValues.containsAll(otherNotValues)) {
                notValues = new THashSet((Collection)this.myNotValues);
                notValues.addAll(otherNotValues);
            }
        }
        return new DfGenericObjectType(notValues, constraint, nullability, mutability, sf, sfType, locality);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfGenericObjectType type2 = (DfGenericObjectType)o;
        return this.myLocal == type2.myLocal && this.myNullability == type2.myNullability && this.myMutability == type2.myMutability && this.mySpecialField == type2.mySpecialField && this.myConstraint.equals(type2.myConstraint) && this.mySpecialFieldType.equals(type2.mySpecialFieldType) && this.myNotValues.equals(type2.myNotValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal, this.myNotValues});
    }

    @Override
    public String toString() {
        ArrayList<String> components = new ArrayList<String>();
        if (this.myConstraint != TypeConstraints.TOP) {
            components.add(this.myConstraint.toString());
        }
        if (this.myNullability != DfaNullability.UNKNOWN) {
            components.add(this.myNullability.toString());
        }
        if (this.myMutability != Mutability.UNKNOWN) {
            components.add(this.myMutability.name());
        }
        if (this.myLocal) {
            components.add("local object");
        }
        if (this.mySpecialField != null) {
            components.add(this.mySpecialField + "=" + this.mySpecialFieldType);
        }
        if (!this.myNotValues.isEmpty()) {
            components.add("!= " + StreamEx.of((Collection)this.myNotValues).map(DfConstantType::renderValue).joining((CharSequence)", "));
        }
        return String.join((CharSequence)" ", components);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutability";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfGenericObjectType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfGenericObjectType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialFieldType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dropLocality";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMergeable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

