/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateExpressions;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.duplicateExpressions.ComplexityCalculator;
import com.intellij.codeInspection.duplicateExpressions.DuplicateExpressionsContext;
import com.intellij.codeInspection.duplicateExpressions.ExpressionHashingStrategy;
import com.intellij.codeInspection.duplicateExpressions.SideEffectCalculator;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateExpressionsInspection
extends LocalInspectionTool {
    public int complexityThreshold = 70;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                if (expression2 instanceof PsiParenthesizedExpression) {
                    return;
                }
                this.visitExpressionImpl(expression2);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getParent() instanceof PsiCallExpression) {
                    return;
                }
                this.visitExpressionImpl((PsiExpression)expression2);
            }

            public void visitExpressionImpl(PsiExpression expression2) {
                if (ComplexityCalculator.isDefinitelySimple(expression2) || SideEffectCalculator.isDefinitelyWithSideEffect(expression2) || expression2 instanceof PsiLambdaExpression || ExpressionUtils.isVoidContext(expression2)) {
                    return;
                }
                DuplicateExpressionsContext context = DuplicateExpressionsContext.getOrCreateContext(expression2, (UserDataHolder)session);
                if (context == null || context.mayHaveSideEffect(expression2)) {
                    return;
                }
                if (context.getComplexity(expression2) > DuplicateExpressionsInspection.this.complexityThreshold) {
                    context.addOccurrence(expression2);
                }
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                PsiCodeBlock body2 = method.getBody();
                if (body2 != null) {
                    this.registerProblemsForExpressions(body2, (UserDataHolder)session);
                }
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                this.registerProblemsForExpressions(initializer.getBody(), (UserDataHolder)session);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    this.registerProblemsForExpressions((PsiCodeBlock)body2, (UserDataHolder)session);
                }
            }

            public void registerProblemsForExpressions(@NotNull PsiCodeBlock body2, @NotNull UserDataHolder session2) {
                DuplicateExpressionsContext context;
                if (body2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (session2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((context = DuplicateExpressionsContext.getContext(body2, session2)) == null) {
                    return;
                }
                THashSet processed = new THashSet();
                context.forEach((arg_0, arg_1) -> this.lambda$registerProblemsForExpressions$0((Set)processed, body2, arg_0, arg_1));
            }

            public void registerProblems(@NotNull List<? extends PsiExpression> occurrences, @NotNull PsiCodeBlock body2) {
                if (occurrences == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (body2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (occurrences.size() > 1 && DuplicateExpressionsInspection.areSafeToExtract(occurrences, body2)) {
                    Map reusableVariables = DuplicateExpressionsInspection.collectReusableVariables(occurrences);
                    for (PsiExpression psiExpression : occurrences) {
                        PsiVariable variable;
                        ArrayList<Object> fixes = new ArrayList<Object>();
                        List variables = (List)reusableVariables.get(psiExpression);
                        if (variables != null) {
                            for (PsiVariable variable2 : variables) {
                                fixes.add(new ReuseVariableFix(psiExpression, variable2));
                            }
                        }
                        if ((variable = DuplicateExpressionsInspection.findVariableByInitializer(psiExpression)) != null && DuplicateExpressionsInspection.canReplaceOtherOccurrences(psiExpression, occurrences, variable)) {
                            fixes.add(new ReplaceOtherOccurrencesFix(psiExpression, variable));
                        } else if (isOnTheFly) {
                            fixes.add(new IntroduceVariableFix(psiExpression));
                        }
                        holder.registerProblem((PsiElement)psiExpression, JavaBundle.message((String)"inspection.duplicate.expressions.message", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }

            private /* synthetic */ void lambda$registerProblemsForExpressions$0(Set processed, PsiCodeBlock body2, PsiExpression pattern, List occurrences) {
                if (!processed.contains(pattern)) {
                    processed.addAll(occurrences);
                    this.registerProblems(occurrences, body2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "body";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "occurrences";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblemsForExpressions";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblems";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean areSafeToExtract(@NotNull List<? extends PsiExpression> occurrences, @NotNull PsiCodeBlock body2) {
        if (occurrences == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(2);
        }
        if (body2 == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(3);
        }
        if (occurrences.isEmpty()) {
            return false;
        }
        Project project = occurrences.get(0).getProject();
        Set<PsiVariable> variables = DuplicateExpressionsInspection.collectVariablesSafeToExtract(occurrences);
        if (variables == null) {
            return false;
        }
        if (variables.isEmpty()) {
            return true;
        }
        PsiElement anchor = RefactoringUtil.getAnchorElementForMultipleExpressions(occurrences.toArray(PsiExpression.EMPTY_ARRAY), null);
        if (anchor == null) {
            return false;
        }
        PsiElement anchorParent = anchor.getParent();
        if (anchorParent == null) {
            return false;
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(project).getControlFlow((PsiElement)body2, new LocalsControlFlowPolicy((PsiElement)body2));
            int startOffset = flow.getSize();
            int endOffset = 0;
            for (PsiExpression psiExpression : occurrences) {
                PsiElement occurrenceSurroundings = PsiTreeUtil.findFirstParent((PsiElement)psiExpression, (boolean)false, e -> e.getParent() == anchorParent);
                if (occurrenceSurroundings == null) {
                    return false;
                }
                startOffset = Math.min(startOffset, flow.getStartOffset(occurrenceSurroundings));
                endOffset = Math.max(endOffset, flow.getEndOffset(occurrenceSurroundings));
            }
            return ControlFlowUtil.areVariablesUnmodifiedAtLocations(flow, startOffset, endOffset, variables, occurrences);
        }
        catch (AnalysisCanceledException e2) {
            return false;
        }
    }

    @Nullable
    private static Set<PsiVariable> collectVariablesSafeToExtract(@NotNull List<? extends PsiExpression> occurrences) {
        if (occurrences == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(4);
        }
        THashSet variables = new THashSet();
        Ref refFailed = new Ref((Object)Boolean.FALSE);
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor((Set)variables, refFailed){
            final /* synthetic */ Set val$variables;
            final /* synthetic */ Ref val$refFailed;
            {
                this.val$variables = set;
                this.val$refFailed = ref;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolved = reference.resolve();
                if (PsiUtil.isJvmLocalVariable((PsiElement)resolved)) {
                    this.val$variables.add((PsiVariable)resolved);
                } else if (resolved instanceof PsiVariable && !((PsiVariable)resolved).hasModifierProperty("final")) {
                    this.val$refFailed.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
            }
        };
        for (PsiExpression psiExpression : occurrences) {
            psiExpression.accept((PsiElementVisitor)visitor2);
            if (!((Boolean)refFailed.get()).booleanValue()) continue;
            return null;
        }
        return variables;
    }

    @NotNull
    private static Map<PsiExpression, List<PsiVariable>> collectReusableVariables(@NotNull List<? extends PsiExpression> occurrences) {
        if (occurrences == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(5);
        }
        if (occurrences.size() <= 1) {
            Map<PsiExpression, List<PsiVariable>> map2 = Collections.emptyMap();
            if (map2 == null) {
                DuplicateExpressionsInspection.$$$reportNull$$$0(6);
            }
            return map2;
        }
        THashMap initializers = new THashMap();
        for (PsiExpression psiExpression : occurrences) {
            PsiVariable variable = DuplicateExpressionsInspection.findVariableByInitializer(psiExpression);
            if (variable == null) continue;
            initializers.put(variable, psiExpression);
        }
        if (initializers.isEmpty()) {
            Map<PsiExpression, List<PsiVariable>> map3 = Collections.emptyMap();
            if (map3 == null) {
                DuplicateExpressionsInspection.$$$reportNull$$$0(7);
            }
            return map3;
        }
        THashMap result = new THashMap();
        initializers.forEach((arg_0, arg_1) -> DuplicateExpressionsInspection.lambda$collectReusableVariables$2(occurrences, (Map)result, arg_0, arg_1));
        THashMap tHashMap = result;
        if (tHashMap == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(8);
        }
        return tHashMap;
    }

    private static boolean canReplaceOtherOccurrences(@NotNull PsiExpression originalOccurrence, @NotNull List<? extends PsiExpression> occurrences, @NotNull PsiVariable variable) {
        if (originalOccurrence == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(9);
        }
        if (occurrences == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(10);
        }
        if (variable == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(11);
        }
        return occurrences.stream().anyMatch(occurrence -> occurrence != originalOccurrence && DuplicateExpressionsInspection.canReplaceWith(occurrence, variable));
    }

    private static boolean canReplaceWith(@NotNull PsiExpression occurrence, @NotNull PsiVariable variable) {
        PsiExpression refExpr;
        String variableName2;
        if (occurrence == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(12);
        }
        if (variable == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(13);
        }
        if ((variableName2 = variable.getName()) == null) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        try {
            refExpr = factory.createExpressionFromText(variableName2, (PsiElement)occurrence);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return refExpr instanceof PsiReferenceExpression && ((PsiReferenceExpression)refExpr).resolve() == variable;
    }

    @Nullable
    private static PsiVariable findVariableByInitializer(@NotNull PsiExpression expression2) {
        PsiVariable variable;
        PsiElement parent;
        if (expression2 == null) {
            DuplicateExpressionsInspection.$$$reportNull$$$0(14);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiVariable && PsiTreeUtil.isAncestor((PsiElement)(variable = (PsiVariable)parent).getInitializer(), (PsiElement)expression2, (boolean)false)) {
            return variable;
        }
        return null;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(JavaBundle.message((String)"inspection.duplicate.expressions.complexity.threshold", (Object[])new Object[0]), (InspectionProfileEntry)this, "complexityThreshold", 3);
    }

    private static /* synthetic */ void lambda$collectReusableVariables$2(List occurrences, Map result, PsiVariable variable, PsiExpression initializer) {
        for (PsiExpression occurrence : occurrences) {
            if (occurrence == initializer || !DuplicateExpressionsInspection.canReplaceWith(occurrence, variable)) continue;
            result.computeIfAbsent(occurrence, unused -> new ArrayList()).add(variable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalOccurrence";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReusableVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areSafeToExtract";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectVariablesSafeToExtract";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectReusableVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canReplaceOtherOccurrences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canReplaceWith";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findVariableByInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceOtherOccurrencesFix
    implements LocalQuickFix {
        private final String myExpressionText;
        private final String myVariableName;

        private ReplaceOtherOccurrencesFix(@NotNull PsiExpression expression2, @NotNull PsiVariable variable) {
            if (expression2 == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(1);
            }
            this.myExpressionText = expression2.getText();
            this.myVariableName = variable.getName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.replace.other.occurrences.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.replace.other.occurrences.fix.name", (Object[])new Object[]{this.myVariableName, this.myExpressionText});
            if (string == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(5);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiExpression) {
                List<PsiExpression> occurrences = ReplaceOtherOccurrencesFix.collectReplaceableOccurrences((PsiExpression)element);
                for (PsiExpression occurrence : occurrences) {
                    new CommentTracker().replaceAndRestoreComments((PsiElement)occurrence, this.myVariableName);
                }
            }
        }

        @NotNull
        private static List<PsiExpression> collectReplaceableOccurrences(final @NotNull PsiExpression originalExpr) {
            if (originalExpr == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(6);
            }
            final PsiVariable variable = DuplicateExpressionsInspection.findVariableByInitializer(originalExpr);
            PsiCodeBlock nearestBody = DuplicateExpressionsContext.findNearestBody(originalExpr);
            if (variable != null && nearestBody != null) {
                final ArrayList<PsiExpression> replaceableOccurrences = new ArrayList<PsiExpression>();
                nearestBody.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                    final ExpressionHashingStrategy hashingStrategy = new ExpressionHashingStrategy();

                    public void visitExpression(PsiExpression occurrence) {
                        super.visitExpression(occurrence);
                        if (occurrence != originalExpr && this.hashingStrategy.equals(occurrence, originalExpr) && DuplicateExpressionsInspection.canReplaceWith(occurrence, variable)) {
                            replaceableOccurrences.add(occurrence);
                        }
                    }
                });
                ArrayList<PsiExpression> arrayList = replaceableOccurrences;
                if (arrayList == null) {
                    ReplaceOtherOccurrencesFix.$$$reportNull$$$0(7);
                }
                return arrayList;
            }
            List<PsiExpression> list = Collections.emptyList();
            if (list == null) {
                ReplaceOtherOccurrencesFix.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$ReplaceOtherOccurrencesFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalExpr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$ReplaceOtherOccurrencesFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectReplaceableOccurrences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectReplaceableOccurrences";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReuseVariableFix
    implements LocalQuickFix {
        private final String myExpressionText;
        private final String myVariableName;

        private ReuseVariableFix(@NotNull PsiExpression expression2, @NotNull PsiVariable variable) {
            if (expression2 == null) {
                ReuseVariableFix.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                ReuseVariableFix.$$$reportNull$$$0(1);
            }
            this.myExpressionText = expression2.getText();
            this.myVariableName = variable.getName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.reuse.variable.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReuseVariableFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.reuse.variable.fix.name", (Object[])new Object[]{this.myVariableName, this.myExpressionText});
            if (string == null) {
                ReuseVariableFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReuseVariableFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ReuseVariableFix.$$$reportNull$$$0(5);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiExpression) {
                new CommentTracker().replaceAndRestoreComments(element, this.myVariableName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$ReuseVariableFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$ReuseVariableFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntroduceVariableFix
    implements LocalQuickFix {
        private final String myExpressionText;

        private IntroduceVariableFix(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                IntroduceVariableFix.$$$reportNull$$$0(0);
            }
            this.myExpressionText = expression2.getText();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.introduce.variable.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                IntroduceVariableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.expressions.introduce.variable.fix.name", (Object[])new Object[]{this.myExpressionText});
            if (string == null) {
                IntroduceVariableFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                IntroduceVariableFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                IntroduceVariableFix.$$$reportNull$$$0(4);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiExpression) {
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
                if (editor != null) {
                    new MyIntroduceVariableHandler().invoke(project, editor, (PsiExpression)element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$IntroduceVariableFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateExpressions/DuplicateExpressionsInspection$IntroduceVariableFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyIntroduceVariableHandler
        extends IntroduceVariableHandler {
            private MyIntroduceVariableHandler() {
            }

            @Override
            public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr2, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator2, PsiElement anchor, IntroduceVariableBase.JavaReplaceChoice replaceChoice) {
                if (replaceChoice == null && ApplicationManager.getApplication().isUnitTestMode()) {
                    replaceChoice = IntroduceVariableBase.JavaReplaceChoice.ALL;
                }
                return super.getSettings(project, editor, expr2, occurrences, typeSelectorManager, declareFinalIfAll, anyAssignmentLHS, validator2, anchor, replaceChoice);
            }
        }
    }
}

