/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantLabeledSwitchRuleCodeBlockInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(0);
        }
        if (!HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
                super.visitSwitchLabeledRuleStatement(statement);
                PsiStatement body2 = statement.getBody();
                if (body2 instanceof PsiBlockStatement) {
                    PsiCodeBlock codeBlock = ((PsiBlockStatement)body2).getCodeBlock();
                    PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(codeBlock);
                    if (bodyStatement instanceof PsiYieldStatement) {
                        if (((PsiYieldStatement)bodyStatement).getExpression() != null) {
                            this.registerProblem(bodyStatement.getFirstChild());
                        }
                    } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                        this.registerProblem((PsiElement)codeBlock.getLBrace());
                        if (isOnTheFly) {
                            this.registerProblem((PsiElement)codeBlock.getRBrace());
                        }
                    }
                }
            }

            private void registerProblem(@Nullable PsiElement element) {
                if (element != null) {
                    holder.registerProblem(element, JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.block.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new UnwrapCodeBlockFix()});
                }
            }
        };
    }

    @Nullable
    private static PsiStatement getSingleStatement(@NotNull PsiCodeBlock block) {
        PsiStatement firstStatement;
        if (block == null) {
            RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(2);
        }
        if ((firstStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)block.getLBrace(), PsiStatement.class)) != null && PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, PsiStatement.class) == null) {
            return firstStatement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnwrapCodeBlockFix
    implements LocalQuickFix {
        private UnwrapCodeBlockFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.fix.name", (Object[])new Object[0]);
            if (string == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiBlockStatement body2;
            if (project == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(2);
            }
            if ((body2 = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiBlockStatement.class)) != null && body2.getParent() instanceof PsiSwitchLabeledRuleStatement) {
                PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(body2.getCodeBlock());
                if (bodyStatement instanceof PsiYieldStatement) {
                    UnwrapCodeBlockFix.unwrapYieldValue((PsiStatement)body2, (PsiYieldStatement)bodyStatement);
                } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                    UnwrapCodeBlockFix.unwrap((PsiStatement)body2, bodyStatement);
                }
            }
        }

        private static void unwrapYieldValue(PsiStatement body2, PsiYieldStatement yieldStatement) {
            PsiExpression valueExpression = yieldStatement.getExpression();
            if (valueExpression != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)body2.getProject());
                PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("x=1;", (PsiElement)body2);
                statement.getExpression().replace((PsiElement)valueExpression);
                CommentTracker tracker = new CommentTracker();
                tracker.markUnchanged(valueExpression);
                tracker.replaceAndRestoreComments((PsiElement)body2, (PsiElement)statement);
            }
        }

        private static void unwrap(PsiStatement body2, PsiStatement bodyStatement) {
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)body2, (PsiElement)bodyStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection$UnwrapCodeBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection$UnwrapCodeBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

