/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private final String myAnnotation;
    private final String[] myAnnosToRemove;

    AnnotateOverriddenMethodParameterFix(@NotNull String annotationFQN, String ... annosToRemove) {
        if (annotationFQN == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(0);
        }
        if (annosToRemove == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(1);
        }
        this.myAnnotation = annotationFQN;
        this.myAnnosToRemove = annosToRemove;
    }

    @NotNull
    public String getName() {
        String string = JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
        if (string == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(4);
        }
        ArrayList toAnnotate = new ArrayList();
        PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiParameter.class, (boolean)false);
        if (parameter2 == null || !AnnotateOverriddenMethodParameterFix.processParameterInheritorsUnderProgress(parameter2, param -> {
            if (AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)param, this.myAnnotation)) {
                toAnnotate.add(param);
            }
        })) {
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        Throwable exception = null;
        for (PsiParameter psiParam : toAnnotate) {
            assert (psiParam != null) : toAnnotate;
            try {
                if (AnnotationUtil.isAnnotatingApplicable((PsiElement)psiParam, (String)this.myAnnotation)) {
                    AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)psiParam, PsiNameValuePair.EMPTY_ARRAY, this.myAnnosToRemove);
                    PsiFile containingFile = psiParam.getContainingFile();
                    if (psiParam.isValid() && fix.isAvailable(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam)) {
                        fix.invoke(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam);
                    }
                }
            }
            catch (PsiInvalidElementAccessException | IncorrectOperationException e) {
                exception = e;
            }
            if (exception == null) continue;
            throw exception;
        }
    }

    public static boolean processParameterInheritorsUnderProgress(@NotNull PsiParameter parameter2, @NotNull Consumer<? super PsiParameter> consumer) {
        PsiMethod method;
        if (parameter2 == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(6);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class)) == null) {
            return false;
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find((Object[])parameters2, (Object)parameter2);
        return AnnotateMethodFix.processModifiableInheritorsUnderProgress(method, psiMethod -> {
            PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
            if (index < psiParameters.length) {
                consumer.accept(psiParameters[index]);
            }
        });
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters.family.name", (Object[])new Object[0]);
        if (string == null) {
            AnnotateOverriddenMethodParameterFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annosToRemove";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/AnnotateOverriddenMethodParameterFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processParameterInheritorsUnderProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

