/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.numeric.ConvertNumericLiteralQuickFix;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public final class InsertLiteralUnderscoresInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InsertLiteralUnderscoresInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                InsertLiteralUnderscoresInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression literalExpression) {
                PsiType type2;
                if (literalExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(PsiType.INT.equals((Object)(type2 = literalExpression.getType())) || PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2))) {
                    return;
                }
                String text2 = literalExpression.getText();
                if (text2 == null || text2.contains("_")) {
                    return;
                }
                String converted = LiteralFormatUtil.format(text2, type2);
                if (converted.length() == text2.length()) {
                    return;
                }
                String displayMessage = JavaBundle.message((String)"inspection.insert.literal.underscores.display.name", (Object[])new Object[0]);
                String actionText = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{text2, converted});
                String familyName = JavaBundle.message((String)"inspection.insert.literal.underscores.family.name", (Object[])new Object[0]);
                ConvertNumericLiteralQuickFix quickFix = new ConvertNumericLiteralQuickFix(converted, actionText, familyName);
                holder.registerProblem((PsiElement)literalExpression, displayMessage, new LocalQuickFix[]{quickFix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/codeInspection/numeric/InsertLiteralUnderscoresInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/numeric/InsertLiteralUnderscoresInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/numeric/InsertLiteralUnderscoresInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

