/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.optionalToIf.Instruction;
import com.intellij.codeInspection.optionalToIf.IntermediateOperation;
import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.optionalToIf.Simplifier;
import com.intellij.codeInspection.optionalToIf.SourceOperation;
import com.intellij.codeInspection.optionalToIf.TerminalOperation;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalToIfInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> SUPPORTED_TERMINALS = ContainerUtil.set((Object[])new String[]{"get", "orElse", "ifPresent", "orElseGet", "ifPresentOrElse", "isPresent", "isEmpty", "stream", "orElseThrow"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalToIfInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OptionalToIfInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression terminalCall) {
                String methodName;
                if (terminalCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((methodName = terminalCall.getMethodExpression().getReferenceName()) == null || !SUPPORTED_TERMINALS.contains(methodName)) {
                    return;
                }
                List<Operation> operations = OptionalToIfInspection.extractOperations(terminalCall, true);
                if (operations == null || operations.size() < 1 || !(operations.get(0) instanceof SourceOperation)) {
                    return;
                }
                OptionalToIfContext context = OptionalToIfContext.create((PsiExpression)terminalCall);
                if (context == null) {
                    return;
                }
                holder.registerProblem((PsiElement)terminalCall, JavaBundle.message((String)"inspection.message.replace.optional.with.if.statements", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceOptionalWithIfFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalCall", "com/intellij/codeInspection/optionalToIf/OptionalToIfInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    static List<Operation> extractOperations(@NotNull PsiMethodCallExpression lastCall, boolean hasTerminalCall) {
        if (lastCall == null) {
            OptionalToIfInspection.$$$reportNull$$$0(2);
        }
        ArrayList<Operation> operations = new ArrayList<Operation>();
        PsiMethodCallExpression call = lastCall;
        while (call != null) {
            PsiType type2;
            PsiMethod method = call.resolveMethod();
            if (method == null || !OptionalToIfInspection.isOptionalMethod(method)) {
                return null;
            }
            PsiType psiType = type2 = call == lastCall && hasTerminalCall ? call.getType() : OptionalUtil.getOptionalElementType(call.getType());
            if (type2 == null) {
                return null;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            if (name2 == null) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            Operation operation = OptionalToIfInspection.convertToOperation(name2, type2, args);
            if (operation == null) {
                return null;
            }
            operations.add(operation);
            call = MethodCallUtils.getQualifierMethodCall(call);
        }
        Collections.reverse(operations);
        return operations;
    }

    @Nullable
    private static Operation convertToOperation(@NotNull String name2, @NotNull PsiType type2, PsiExpression @NotNull [] args) {
        Operation operation;
        if (name2 == null) {
            OptionalToIfInspection.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            OptionalToIfInspection.$$$reportNull$$$0(4);
        }
        if (args == null) {
            OptionalToIfInspection.$$$reportNull$$$0(5);
        }
        if ((operation = IntermediateOperation.create(name2, args)) != null) {
            return operation;
        }
        operation = TerminalOperation.create(name2, args);
        if (operation != null) {
            return operation;
        }
        return SourceOperation.create(name2, type2, args);
    }

    private static boolean isOptionalMethod(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            OptionalToIfInspection.$$$reportNull$$$0(6);
        }
        return (aClass = method.getContainingClass()) != null && OptionalUtil.isJdkOptionalClassName(aClass.getQualifiedName());
    }

    private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
        return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
    }

    @Nullable
    static String generateCode(@NotNull OptionalToIfContext context, @NotNull List<Operation> operations) {
        if (context == null) {
            OptionalToIfInspection.$$$reportNull$$$0(7);
        }
        if (operations == null) {
            OptionalToIfInspection.$$$reportNull$$$0(8);
        }
        List<OperationRecord> records = OptionalToIfInspection.createRecords(operations);
        OptionalToIfInspection.allOperations(records).forEach(r -> r.myOperation.preprocessVariables(r.myInVar, r.myOutVar, context));
        ((StreamEx)((StreamEx)OptionalToIfInspection.allOperations(records).map(r -> r.myOutVar).distinct()).filter(v -> !v.isRegistered())).forEach(v -> v.register(context));
        return OptionalToIfInspection.wrapCode(context, records, "");
    }

    @Nullable
    static String wrapCode(@NotNull OptionalToIfContext context, @NotNull List<OperationRecord> records, @NotNull String code) {
        if (context == null) {
            OptionalToIfInspection.$$$reportNull$$$0(9);
        }
        if (records == null) {
            OptionalToIfInspection.$$$reportNull$$$0(10);
        }
        if (code == null) {
            OptionalToIfInspection.$$$reportNull$$$0(11);
        }
        for (int i = records.size() - 1; i >= 0; --i) {
            OperationRecord record = records.get(i);
            Operation operation = record.myOperation;
            ChainVariable inVar = record.myInVar;
            ChainVariable outVar = record.myOutVar;
            if ((code = operation.generate(inVar, outVar, code, context)) == null) {
                return null;
            }
            if (!(operation instanceof IntermediateOperation.Or)) continue;
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.setElseBranch(null);
            List<OperationRecord> rest = records.subList(0, i);
            String beforeCode = OptionalToIfInspection.wrapCode(context, rest, outVar.getName() + "=" + inVar.getName() + ";");
            if (beforeCode == null) {
                return null;
            }
            return beforeCode + code;
        }
        return code;
    }

    @NotNull
    public static List<OperationRecord> createRecords(@NotNull List<Operation> operations) {
        if (operations == null) {
            OptionalToIfInspection.$$$reportNull$$$0(12);
        }
        ChainVariable inVar = ChainVariable.STUB;
        ArrayList<OperationRecord> records = new ArrayList<OperationRecord>(operations.size());
        for (Operation operation : operations) {
            ChainVariable outVar = operation.getOutVar(inVar);
            records.add(new OperationRecord(inVar, outVar, operation));
            inVar = outVar;
        }
        ArrayList<OperationRecord> arrayList = records;
        if (arrayList == null) {
            OptionalToIfInspection.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    static List<Instruction> createInstructions(PsiStatement @NotNull [] statements) {
        if (statements == null) {
            OptionalToIfInspection.$$$reportNull$$$0(14);
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(statements.length);
        for (PsiStatement statement : statements) {
            Instruction instruction = Instruction.create(statement);
            if (instruction == null) {
                return null;
            }
            instructions.add(instruction);
        }
        return instructions;
    }

    private static PsiStatement @NotNull [] addStatements(@NotNull PsiElementFactory factory, @NotNull PsiStatement chainStatement, @NotNull String code) {
        if (factory == null) {
            OptionalToIfInspection.$$$reportNull$$$0(15);
        }
        if (chainStatement == null) {
            OptionalToIfInspection.$$$reportNull$$$0(16);
        }
        if (code == null) {
            OptionalToIfInspection.$$$reportNull$$$0(17);
        }
        Object[] statements = ControlFlowUtils.unwrapBlock(factory.createStatementFromText("{\n" + code + "\n}", (PsiElement)chainStatement));
        PsiElement parent = chainStatement.getParent();
        PsiStatement[] psiStatementArray = (PsiStatement[])ContainerUtil.map((Object[])statements, s -> (PsiStatement)parent.addBefore((PsiElement)s, (PsiElement)chainStatement), (Object[])PsiStatement.EMPTY_ARRAY);
        if (psiStatementArray == null) {
            OptionalToIfInspection.$$$reportNull$$$0(18);
        }
        return psiStatementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chainStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecords";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractOperations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToOperation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOptionalMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateCode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapCode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRecords";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createInstructions";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addStatements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceOptionalWithIfFix
    implements LocalQuickFix {
        private ReplaceOptionalWithIfFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.replace.optional.chain.with.if.statements", (Object[])new Object[0]);
            if (string == null) {
                ReplaceOptionalWithIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            List<Instruction> instructions;
            if (project == null) {
                ReplaceOptionalWithIfFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceOptionalWithIfFix.$$$reportNull$$$0(2);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethodCallExpression chainExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (chainExpression == null) {
                return;
            }
            PsiStatement chainStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)chainExpression, PsiStatement.class);
            if (chainStatement == null) {
                return;
            }
            List<Operation> operations = OptionalToIfInspection.extractOperations(chainExpression, true);
            if (operations == null || operations.size() == 0) {
                return;
            }
            OptionalToIfContext context = OptionalToIfContext.create((PsiExpression)chainExpression);
            if (context == null) {
                return;
            }
            String code = OptionalToIfInspection.generateCode(context, operations);
            if (code == null) {
                return;
            }
            code = context.addInitializer(code);
            PsiStatement firstStatement = chainStatement;
            PsiStatement[] statements = OptionalToIfInspection.addStatements(factory, chainStatement, code);
            if (statements.length > 0) {
                firstStatement = statements[0];
            }
            if ((instructions = OptionalToIfInspection.createInstructions(statements)) != null) {
                code = Simplifier.simplify(instructions);
                Arrays.stream(statements).forEach(PsiElement::delete);
                statements = OptionalToIfInspection.addStatements(factory, chainStatement, code);
                firstStatement = statements.length > 0 ? statements[0] : chainStatement;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.grabComments((PsiElement)chainStatement);
            tracker.insertCommentsBefore((PsiElement)firstStatement);
            chainStatement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfInspection$ReplaceOptionalWithIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfInspection$ReplaceOptionalWithIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OperationRecord {
        final Operation myOperation;
        ChainVariable myInVar;
        ChainVariable myOutVar;

        @Contract(pure=true)
        OperationRecord(ChainVariable inVar, ChainVariable outVar, Operation operation) {
            this.myInVar = inVar;
            this.myOutVar = outVar;
            this.myOperation = operation;
        }
    }
}

