/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class FindFirstMigration
extends BaseStreamApiMigration {
    FindFirstMigration(boolean shouldWarn) {
        super(shouldWarn, "findFirst()");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        if (project == null) {
            FindFirstMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            FindFirstMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            FindFirstMigration.$$$reportNull$$$0(2);
        }
        PsiStatement statement = tb.getSingleStatement();
        PsiStatement loopStatement = tb.getStreamSourceStatement();
        CommentTracker ct = new CommentTracker();
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression value2 = returnStatement.getReturnValue();
            if (value2 == null) {
                return null;
            }
            PsiReturnStatement nextReturnStatement = ControlFlowUtils.getNextReturnStatement(loopStatement);
            if (nextReturnStatement == null) {
                return null;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSafelyRecomputableExpression(orElseExpression)) {
                return null;
            }
            String stream = FindFirstMigration.generateOptionalUnwrap(ct, tb, value2, orElseExpression, PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement));
            boolean sibling = nextReturnStatement.getParent() == loopStatement.getParent();
            PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)loopStatement, "return " + stream + ";");
            if (sibling || !ControlFlowUtils.isReachable((PsiStatement)nextReturnStatement)) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)nextReturnStatement);
            }
            return replacement;
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length != 2) {
            return null;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        if (assignment == null || FindFirstMigration.isQualified(assignment.getLExpression()) || tb.getVariable().getType() instanceof PsiPrimitiveType && !ExpressionUtils.isReferenceTo(assignment.getRExpression(), tb.getVariable())) {
            if (!(statements[0] instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
            return ct.replaceAndRestoreComments((PsiElement)loopStatement, tb.generate(ct) + ".findFirst().ifPresent(" + ct.lambdaText(tb.getVariable(), expression2) + ");");
        }
        PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (lValue == null) {
            return null;
        }
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiVariable.class);
        if (var == null) {
            return null;
        }
        PsiExpression value3 = assignment.getRExpression();
        if (value3 == null) {
            return null;
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        PsiExpression initializer = var.getInitializer();
        PsiReferenceExpression falseExpression = lValue;
        PsiElement toDelete = null;
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && (status != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE || ExpressionUtils.isSafelyRecomputableExpression(initializer))) {
            falseExpression = initializer;
        } else {
            PsiElement maybeAssignment = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)loopStatement);
            PsiExpression prevRValue = ExpressionUtils.getAssignmentTo(maybeAssignment, var);
            if (prevRValue != null) {
                toDelete = maybeAssignment;
                falseExpression = prevRValue;
            }
        }
        String replacementText = FindFirstMigration.generateOptionalUnwrap(ct, tb, value3, (PsiExpression)falseExpression, var.getType());
        if (toDelete != null) {
            ct.delete(toDelete);
        }
        return FindFirstMigration.replaceInitializer(loopStatement, var, initializer, replacementText, status, ct);
    }

    private static boolean isQualified(PsiExpression expression2) {
        return (expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)expression2) || expression2 instanceof PsiArrayAccessExpression;
    }

    private static String generateOptionalUnwrap(CommentTracker ct, TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType) {
        String qualifier = tb.generate(ct) + ".findFirst()";
        return OptionalRefactoringUtil.generateOptionalUnwrap(qualifier, tb.getVariable(), ct.markUnchanged(trueExpression), ct.markUnchanged(falseExpression), targetType, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/FindFirstMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

