/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MigrateToStreamFix
implements LocalQuickFix {
    private final BaseStreamApiMigration myMigration;

    protected MigrateToStreamFix(BaseStreamApiMigration migration) {
        this.myMigration = migration;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JavaAnalysisBundle.message((String)"replace.with.0", (Object[])new Object[]{this.myMigration.getReplacement()});
        if (string == null) {
            MigrateToStreamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"quickfix.family.replace.with.stream.api.equivalent", (Object[])new Object[0]);
        if (string == null) {
            MigrateToStreamFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            MigrateToStreamFix.$$$reportNull$$$0(2);
        }
        return this;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiLoopStatement loopStatement;
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            MigrateToStreamFix.$$$reportNull$$$0(4);
        }
        if ((loopStatement = (PsiLoopStatement)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiLoopStatement.class)) == null) {
            return;
        }
        StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
        PsiStatement body2 = loopStatement.getBody();
        if (body2 == null || source == null) {
            return;
        }
        TerminalBlock tb = TerminalBlock.from(source, body2);
        PsiElement result = this.myMigration.migrate(project, (PsiElement)body2, tb);
        if (result == null) {
            return;
        }
        tb.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
        MigrateToStreamFix.simplify(project, result);
    }

    static void simplify(@NotNull Project project, PsiElement result) {
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(5);
        }
        if (result == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        result = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result, true);
        MigrateToStreamFix.removeRedundantPatternVariables(result);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    private static void removeRedundantPatternVariables(PsiElement element) {
        for (PsiLambdaExpression lambda2 : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiLambdaExpression.class})) {
            PsiExpression expression2;
            PsiElement body2 = lambda2.getBody();
            if (!(body2 instanceof PsiExpression) || !PsiType.BOOLEAN.equals((Object)(expression2 = (PsiExpression)body2).getType())) continue;
            List<PsiPatternVariable> variables = JavaPsiPatternUtil.getExposedPatternVariablesIgnoreParent(expression2);
            for (PsiPatternVariable variable : variables) {
                if (VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)expression2)) continue;
                variable.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

