/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ExternalCompilerConfigurationStorage;
import com.intellij.compiler.ExternalCompilerConfigurationStorageKt;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.serialization.java.compiler.AnnotationProcessorProfileSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;

@com.intellij.openapi.components.State(name="CompilerConfiguration", storages={@Storage(value="compiler.xml")})
public class CompilerConfigurationImpl
extends CompilerConfiguration
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(CompilerConfiguration.class);
    public static final String TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME = "tests.external.compiler.home";
    public static final int DEFAULT_BUILD_PROCESS_HEAP_SIZE = 700;
    private BackendCompiler myDefaultJavaCompiler;
    private State myState;
    private final List<Pattern> myRegexpResourcePatterns;
    private final List<String> myWildcardPatterns;
    private final List<CompiledPattern> myCompiledPatterns;
    private final List<CompiledPattern> myNegatedCompiledPatterns;
    private boolean myWildcardPatternsInitialized;
    private final Project myProject;
    private final ExcludedEntriesConfiguration myExcludesConfiguration;
    private volatile Collection<BackendCompiler> myRegisteredCompilers;
    private final JavacCompiler JAVAC_EXTERNAL_BACKEND;
    private final Perl5Matcher myPatternMatcher;
    private boolean myAddNotNullAssertions;
    private final ProcessorConfigProfile myDefaultProcessorsProfile;
    private final List<ProcessorConfigProfile> myModuleProcessorProfiles;
    private Map<Module, ProcessorConfigProfile> myProcessorsProfilesMap;
    @Nullable
    private String myBytecodeTargetLevel;
    private final Map<String, String> myModuleBytecodeTarget;

    public CompilerConfigurationImpl(@NotNull Project project) {
        if (project == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myRegexpResourcePatterns = new ArrayList<Pattern>();
        this.myWildcardPatterns = new ArrayList<String>();
        this.myCompiledPatterns = new ArrayList<CompiledPattern>();
        this.myNegatedCompiledPatterns = new ArrayList<CompiledPattern>();
        this.myWildcardPatternsInitialized = false;
        this.myRegisteredCompilers = Collections.emptyList();
        this.myPatternMatcher = new Perl5Matcher();
        this.loadDefaultWildcardPatterns();
        this.myAddNotNullAssertions = true;
        this.myDefaultProcessorsProfile = new ProcessorConfigProfileImpl("Default");
        this.myModuleProcessorProfiles = new ArrayList<ProcessorConfigProfile>();
        this.myProcessorsProfilesMap = null;
        this.myBytecodeTargetLevel = null;
        this.myModuleBytecodeTarget = new HashMap<String, String>();
        this.myProject = project;
        this.myExcludesConfiguration = this.createExcludedEntriesConfiguration(project);
        this.JAVAC_EXTERNAL_BACKEND = new JavacCompiler(this.myProject);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                CompilerConfigurationImpl.this.getAnnotationProcessingConfiguration(module).removeModuleName(module.getName());
            }

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(3);
                }
                CompilerConfigurationImpl.this.myProcessorsProfilesMap = null;
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    1.$$$reportNull$$$0(6);
                }
                CompilerConfigurationImpl.this.updateModuleNames(modules.stream().collect(Collectors.toMap(arg_0 -> oldNameProvider.fun(arg_0), Module::getName)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeModuleRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!project.isDefault()) {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> {
                this.myRegisteredCompilers = this.collectCompilers();
            });
        }
        BackendCompiler.EP_NAME.getPoint((AreaInstance)project).addChangeListener(() -> {
            this.myRegisteredCompilers = this.collectCompilers();
        }, (Disposable)project);
    }

    @NotNull
    protected ExcludedEntriesConfiguration createExcludedEntriesConfiguration(final @NotNull Project project) {
        if (project == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(1);
        }
        ExcludedEntriesConfiguration cfg = new ExcludedEntriesConfiguration((ExcludedEntriesListener)project.getMessageBus().syncPublisher(ExcludedEntriesListener.TOPIC));
        Disposer.register((Disposable)project, (Disposable)cfg);
        project.getMessageBus().connect().subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

            public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                if (description == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clearState();
            }

            public void onEntryRemoved(@NotNull ExcludeEntryDescription description) {
                if (description == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.clearState();
            }

            private void clearState() {
                if (project.isOpen()) {
                    BuildManager.getInstance().clearState(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "description";
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExcludedEntriesConfiguration excludedEntriesConfiguration = cfg;
        if (excludedEntriesConfiguration == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(2);
        }
        return excludedEntriesConfiguration;
    }

    public Element getState() {
        Element state = new Element("state");
        XmlSerializer.serializeInto((Object)this.myState, (Element)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!this.myAddNotNullAssertions) {
            CompilerConfigurationImpl.addChild(state, "addNotNullAssertions").setAttribute("enabled", String.valueOf(this.myAddNotNullAssertions));
        }
        if (this.myExcludesConfiguration.getExcludeEntryDescriptions().length > 0) {
            this.myExcludesConfiguration.writeExternal(CompilerConfigurationImpl.addChild(state, "excludeFromCompile"));
        }
        Element resourceExtensions = new Element("resourceExtensions");
        for (String pattern : this.getRegexpPatterns()) {
            CompilerConfigurationImpl.addChild(resourceExtensions, "entry").setAttribute("name", pattern);
        }
        if (!JDOMUtil.isEmpty((Element)resourceExtensions)) {
            state.addContent(resourceExtensions);
        }
        if (!(!this.myWildcardPatternsInitialized && this.myWildcardPatterns.isEmpty() || JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS.equals(this.myWildcardPatterns))) {
            Element wildcardPatterns = CompilerConfigurationImpl.addChild(state, "wildcardResourcePatterns");
            for (String wildcardPattern : this.myWildcardPatterns) {
                CompilerConfigurationImpl.addChild(wildcardPatterns, "entry").setAttribute("name", wildcardPattern);
            }
        }
        Element annotationProcessingSettings = new Element("annotationProcessing");
        Element profileElement = new Element("profile");
        profileElement.setAttribute("default", "true");
        AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)this.myDefaultProcessorsProfile, (Element)profileElement);
        if (!JDOMUtil.isEmpty((Element)profileElement, (int)2)) {
            annotationProcessingSettings.addContent(profileElement);
        }
        for (ProcessorConfigProfile profile : this.myModuleProcessorProfiles) {
            Element element = new Element("profile");
            AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)profile, (Element)element);
            annotationProcessingSettings.addContent(element);
        }
        if (!JDOMUtil.isEmpty((Element)annotationProcessingSettings)) {
            state.addContent(annotationProcessingSettings);
        }
        List<String> moduleNames = ExternalCompilerConfigurationStorageKt.getFilteredModuleNameList(this.myProject, this.myModuleBytecodeTarget, false);
        if (!StringUtil.isEmpty((String)this.myBytecodeTargetLevel) || !moduleNames.isEmpty()) {
            Element bytecodeTarget = new Element("bytecodeTargetLevel");
            state.addContent(bytecodeTarget);
            if (!StringUtil.isEmpty((String)this.myBytecodeTargetLevel)) {
                bytecodeTarget.setAttribute("target", this.myBytecodeTargetLevel);
            }
            ExternalCompilerConfigurationStorageKt.writeBytecodeTarget(moduleNames, this.myModuleBytecodeTarget, bytecodeTarget);
        }
        return state;
    }

    public int getBuildProcessHeapSize(int javacPreferredHeapSize) {
        int heapSize = this.myState.BUILD_PROCESS_HEAP_SIZE;
        if (heapSize != 700) {
            return heapSize;
        }
        return Math.max(heapSize, javacPreferredHeapSize);
    }

    public void setBuildProcessHeapSize(int size) {
        this.myState.BUILD_PROCESS_HEAP_SIZE = size > 0 ? size : 700;
    }

    public String getBuildProcessVMOptions() {
        return this.myState.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS;
    }

    public void setBuildProcessVMOptions(String options) {
        this.myState.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = options == null ? "" : options.trim();
    }

    private void updateModuleNames(Map<String, String> moduleNameMap) {
        JpsJavaCompilerOptions settings = this.getJavaCompilerSettings();
        boolean updated = false;
        for (Map.Entry<String, String> entry : moduleNameMap.entrySet()) {
            String options;
            String targetLevel = this.myModuleBytecodeTarget.remove(entry.getKey());
            if (targetLevel != null) {
                this.myModuleBytecodeTarget.put(entry.getValue(), targetLevel);
                updated = true;
            }
            if (settings == null || (options = (String)settings.ADDITIONAL_OPTIONS_OVERRIDE.remove(entry.getKey())) == null) continue;
            settings.ADDITIONAL_OPTIONS_OVERRIDE.put(entry.getValue(), options);
            updated = true;
        }
        for (ProcessorConfigProfile profile : this.myModuleProcessorProfiles) {
            Set names2 = profile.getModuleNames();
            Collection updatedNames = ContainerUtil.intersection((Collection)names2, moduleNameMap.keySet());
            if (updatedNames.isEmpty()) continue;
            profile.removeModuleNames(updatedNames);
            profile.addModuleNames((Collection)ContainerUtil.map((Collection)updatedNames, moduleNameMap::get));
            updated = true;
        }
        if (updated) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public void setProjectBytecodeTarget(@Nullable String level) {
        String previous = this.myBytecodeTargetLevel;
        this.myBytecodeTargetLevel = level;
        if (!this.myProject.isDefault() && !Objects.equals(previous, level)) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        return this.myBytecodeTargetLevel;
    }

    public boolean useReleaseOption() {
        return this.myState.USE_RELEASE_OPTION;
    }

    public void setUseReleaseOption(boolean useReleaseOption) {
        this.myState.USE_RELEASE_OPTION = useReleaseOption;
    }

    public void setModulesBytecodeTargetMap(@NotNull Map<String, String> mapping) {
        if (mapping == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(3);
        }
        boolean shouldNotify = !this.myProject.isDefault() && !this.myModuleBytecodeTarget.equals(mapping);
        this.myModuleBytecodeTarget.clear();
        this.myModuleBytecodeTarget.putAll(mapping);
        if (shouldNotify) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        return this.myModuleBytecodeTarget;
    }

    public void setBytecodeTargetLevel(Module module, String level) {
        Project project;
        String previous = StringUtil.isEmpty((String)level) ? this.myModuleBytecodeTarget.remove(module.getName()) : this.myModuleBytecodeTarget.put(module.getName(), level);
        if (!Objects.equals(previous, level) && !(project = module.getProject()).isDefault()) {
            BuildManager.getInstance().clearState(project);
        }
    }

    @Nullable
    public String getBytecodeTargetLevel(Module module) {
        String level = this.myModuleBytecodeTarget.get(module.getName());
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myBytecodeTargetLevel;
    }

    private void loadDefaultWildcardPatterns() {
        if (!this.myWildcardPatterns.isEmpty()) {
            this.removeWildcardPatterns();
        }
        try {
            for (String pattern : JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS) {
                this.addWildcardResourcePattern(pattern);
            }
        }
        catch (MalformedPatternException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public List<String> getAdditionalOptions(@NotNull Module module) {
        String options;
        JpsJavaCompilerOptions settings;
        if (module == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(4);
        }
        if ((settings = this.getJavaCompilerSettings()) != null && !StringUtil.isEmptyOrSpaces((String)(options = settings.ADDITIONAL_OPTIONS_OVERRIDE.getOrDefault(module.getName(), settings.ADDITIONAL_OPTIONS_STRING)))) {
            List list = ParametersListUtil.parse((String)options);
            if (list == null) {
                CompilerConfigurationImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setAdditionalOptions(@NotNull Module module, @NotNull List<String> options) {
        JpsJavaCompilerOptions settings;
        if (module == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(7);
        }
        if (options == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(8);
        }
        if ((settings = this.getJavaCompilerSettings()) != null) {
            this.setAdditionalOptions(settings, module, options);
        }
    }

    public void setAdditionalOptions(@NotNull JpsJavaCompilerOptions settings, @NotNull Module module, @NotNull List<String> options) {
        if (settings == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(9);
        }
        if (module == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(10);
        }
        if (options == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(11);
        }
        String previous = settings.ADDITIONAL_OPTIONS_OVERRIDE.getOrDefault(module.getName(), settings.ADDITIONAL_OPTIONS_STRING);
        String newValue = ParametersListUtil.join(options);
        if (!newValue.equals(previous)) {
            settings.ADDITIONAL_OPTIONS_OVERRIDE.put(module.getName(), newValue);
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    private JpsJavaCompilerOptions getJavaCompilerSettings() {
        CompilerOptions compilerOptions = this.getDefaultCompiler().getOptions();
        return compilerOptions instanceof JpsJavaCompilerOptions ? (JpsJavaCompilerOptions)compilerOptions : null;
    }

    public static String getTestsExternalCompilerHome() {
        String compilerHome = System.getProperty(TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME, null);
        if (compilerHome == null) {
            File javaHome = new File(System.getProperty("java.home"));
            compilerHome = SystemInfo.isMac || !new File(javaHome.getParentFile(), "bin").exists() ? javaHome.getAbsolutePath() : javaHome.getParentFile().getAbsolutePath();
        }
        return compilerHome;
    }

    private static Pattern compilePattern(@NonNls String s) throws MalformedPatternException {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            return SystemInfo.isFileSystemCaseSensitive ? compiler.compile(s) : compiler.compile(s, 1);
        }
        catch (org.apache.oro.text.regex.MalformedPatternException ex) {
            throw new MalformedPatternException((Throwable)ex);
        }
    }

    public JavacCompiler getJavacCompiler() {
        return this.JAVAC_EXTERNAL_BACKEND;
    }

    @NotNull
    private List<BackendCompiler> collectCompilers() {
        ArrayList<BackendCompiler> compilers = new ArrayList<BackendCompiler>();
        compilers.add(this.JAVAC_EXTERNAL_BACKEND);
        if (EclipseCompiler.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            compilers.add(new EclipseCompiler(this.myProject));
        }
        compilers.addAll(BackendCompiler.EP_NAME.getExtensions((AreaInstance)this.myProject));
        this.myDefaultJavaCompiler = this.JAVAC_EXTERNAL_BACKEND;
        for (BackendCompiler compiler : compilers) {
            if (!compiler.getId().equals(this.myState.DEFAULT_COMPILER)) continue;
            this.myDefaultJavaCompiler = compiler;
            break;
        }
        this.myState.DEFAULT_COMPILER = this.myDefaultJavaCompiler.getId();
        ArrayList<BackendCompiler> arrayList = compilers;
        if (arrayList == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public Collection<BackendCompiler> getRegisteredJavaCompilers() {
        Collection<BackendCompiler> compilers = this.myRegisteredCompilers;
        if (compilers.isEmpty()) {
            compilers = this.collectCompilers();
        }
        return Collections.unmodifiableCollection(compilers);
    }

    public String[] getResourceFilePatterns() {
        return this.getWildcardPatterns();
    }

    private String[] getRegexpPatterns() {
        String[] patterns = ArrayUtil.newStringArray((int)this.myRegexpResourcePatterns.size());
        int index = 0;
        for (Pattern myRegexpResourcePattern : this.myRegexpResourcePatterns) {
            patterns[index++] = myRegexpResourcePattern.getPattern();
        }
        return patterns;
    }

    private String[] getWildcardPatterns() {
        return ArrayUtilRt.toStringArray(this.myWildcardPatterns);
    }

    public void addResourceFilePattern(String namePattern) throws MalformedPatternException {
        this.addWildcardResourcePattern(namePattern);
    }

    private void addRegexpPattern(String namePattern) throws MalformedPatternException {
        Pattern pattern = CompilerConfigurationImpl.compilePattern(namePattern);
        if (pattern != null) {
            this.myRegexpResourcePatterns.add(pattern);
        }
    }

    public ExcludesConfiguration getExcludedEntriesConfiguration() {
        return this.myExcludesConfiguration;
    }

    public boolean isExcludedFromCompilation(VirtualFile virtualFile) {
        return this.myExcludesConfiguration.isExcluded(virtualFile);
    }

    public boolean isResourceFile(VirtualFile virtualFile) {
        return this.isResourceFile(virtualFile.getName(), virtualFile.getParent());
    }

    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    public void setAddNotNullAssertions(boolean enabled) {
        this.myAddNotNullAssertions = enabled;
    }

    @NotNull
    public ProcessorConfigProfile getDefaultProcessorProfile() {
        ProcessorConfigProfile processorConfigProfile = this.myDefaultProcessorsProfile;
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(13);
        }
        return processorConfigProfile;
    }

    public void setDefaultProcessorProfile(ProcessorConfigProfile profile) {
        this.myDefaultProcessorsProfile.initFrom(profile);
    }

    @NotNull
    public List<ProcessorConfigProfile> getModuleProcessorProfiles() {
        List<ProcessorConfigProfile> list = Collections.unmodifiableList(this.myModuleProcessorProfiles);
        if (list == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void setModuleProcessorProfiles(Collection<? extends ProcessorConfigProfile> moduleProfiles) {
        this.myModuleProcessorProfiles.clear();
        for (ProcessorConfigProfile processorConfigProfile : moduleProfiles) {
            this.myModuleProcessorProfiles.add((ProcessorConfigProfile)new ProcessorConfigProfileImpl(processorConfigProfile));
        }
        this.myProcessorsProfilesMap = null;
    }

    @Nullable
    public ProcessorConfigProfile findModuleProcessorProfile(@NotNull String name2) {
        if (name2 == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(15);
        }
        for (ProcessorConfigProfile profile : this.myModuleProcessorProfiles) {
            if (!name2.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    public void removeModuleProcessorProfile(ProcessorConfigProfile profile) {
        this.myModuleProcessorProfiles.remove(profile);
        this.myProcessorsProfilesMap = null;
    }

    public void addModuleProcessorProfile(@NotNull ProcessorConfigProfile profile) {
        if (profile == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(16);
        }
        this.myModuleProcessorProfiles.add(profile);
        this.myProcessorsProfilesMap = null;
    }

    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingConfiguration(Module module) {
        ProcessorConfigProfile profile;
        Map<Module, ProcessorConfigProfile> map2 = this.myProcessorsProfilesMap;
        if (map2 == null) {
            map2 = new HashMap<Module, ProcessorConfigProfile>();
            HashMap<String, Module> namesMap = new HashMap<String, Module>();
            for (Module m : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile2 : this.myModuleProcessorProfiles) {
                    for (String name2 : profile2.getModuleNames()) {
                        Module mod = (Module)namesMap.get(name2);
                        if (mod == null) continue;
                        map2.put(mod, profile2);
                    }
                }
            }
            this.myProcessorsProfilesMap = map2;
        }
        ProcessorConfigProfile processorConfigProfile = (profile = map2.get(module)) != null ? profile : this.myDefaultProcessorsProfile;
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(17);
        }
        return processorConfigProfile;
    }

    public boolean isAnnotationProcessorsEnabled() {
        if (this.myDefaultProcessorsProfile.isEnabled()) {
            return true;
        }
        for (ProcessorConfigProfile profile : this.myModuleProcessorProfiles) {
            if (!profile.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void addWildcardResourcePattern(@NonNls String wildcardPattern) throws MalformedPatternException {
        CompiledPattern pattern = CompilerConfigurationImpl.convertToRegexp(wildcardPattern);
        this.myWildcardPatterns.add(wildcardPattern);
        if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
            this.myNegatedCompiledPatterns.add(pattern);
        } else {
            this.myCompiledPatterns.add(pattern);
        }
    }

    public void removeResourceFilePatterns() {
        this.removeWildcardPatterns();
    }

    private void removeRegexpPatterns() {
        this.myRegexpResourcePatterns.clear();
    }

    private void removeWildcardPatterns() {
        this.myWildcardPatterns.clear();
        this.myCompiledPatterns.clear();
        this.myNegatedCompiledPatterns.clear();
    }

    private static CompiledPattern convertToRegexp(String wildcardPattern) {
        if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
            wildcardPattern = wildcardPattern.substring(1);
        }
        wildcardPattern = FileUtil.toSystemIndependentName((String)wildcardPattern);
        String srcRoot = null;
        int colon = wildcardPattern.indexOf(":");
        if (colon > 0) {
            srcRoot = wildcardPattern.substring(0, colon);
            wildcardPattern = wildcardPattern.substring(colon + 1);
        }
        String dirPattern = null;
        int slash = wildcardPattern.lastIndexOf(47);
        if (slash >= 0) {
            dirPattern = wildcardPattern.substring(0, slash + 1);
            wildcardPattern = wildcardPattern.substring(slash + 1);
            dirPattern = ResourcePatterns.optimizeDirPattern((String)dirPattern);
        }
        wildcardPattern = ResourcePatterns.normalizeWildcards((String)wildcardPattern);
        wildcardPattern = CompilerConfigurationImpl.optimize(wildcardPattern);
        Pattern dirCompiled = dirPattern == null ? null : CompilerConfigurationImpl.compilePattern(dirPattern);
        Pattern srcCompiled = srcRoot == null ? null : CompilerConfigurationImpl.compilePattern(CompilerConfigurationImpl.optimize(ResourcePatterns.normalizeWildcards((String)srcRoot)));
        return new CompiledPattern(CompilerConfigurationImpl.compilePattern(wildcardPattern), dirCompiled, srcCompiled);
    }

    private static String optimize(String wildcardPattern) {
        return wildcardPattern.replaceAll("(?:\\.\\*)+", ".*");
    }

    public static boolean isPatternNegated(String wildcardPattern) {
        return wildcardPattern.length() > 1 && wildcardPattern.charAt(0) == '!';
    }

    public boolean isResourceFile(String name2) {
        return this.isResourceFile(name2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(String s, Pattern p) {
        Perl5Matcher perl5Matcher = this.myPatternMatcher;
        synchronized (perl5Matcher) {
            try {
                return this.myPatternMatcher.matches(s, p);
            }
            catch (Exception e) {
                LOG.error("Exception matching file name \"" + s + "\" against the pattern \"" + p + "\"", (Throwable)e);
                return false;
            }
        }
    }

    private boolean isResourceFile(String name2, @Nullable VirtualFile parent) {
        int i;
        Ref parentRef = Ref.create(null);
        for (i = 0; i < this.myCompiledPatterns.size(); ++i) {
            if (!this.matches(name2, parent, (Ref<String>)parentRef, this.myCompiledPatterns.get(i))) continue;
            return true;
        }
        if (this.myNegatedCompiledPatterns.isEmpty()) {
            return false;
        }
        for (i = 0; i < this.myNegatedCompiledPatterns.size(); ++i) {
            if (!this.matches(name2, parent, (Ref<String>)parentRef, this.myNegatedCompiledPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String name2, VirtualFile parent, Ref<String> parentRef, CompiledPattern pair2) {
        if (!this.matches(name2, pair2.fileName)) {
            return false;
        }
        if (parent != null && (pair2.dir != null || pair2.srcRoot != null)) {
            VirtualFile srcRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(parent);
            if (pair2.dir != null) {
                String parentPath = (String)parentRef.get();
                if (parentPath == null) {
                    parentPath = srcRoot == null ? parent.getPath() : VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)srcRoot, (char)'/');
                    parentRef.set((Object)parentPath);
                }
                if (parentPath == null || !this.matches("/" + parentPath, pair2.dir)) {
                    return false;
                }
            }
            if (pair2.srcRoot != null) {
                String srcRootName;
                String string = srcRootName = srcRoot == null ? null : srcRoot.getName();
                if (srcRootName == null || !this.matches(srcRootName, pair2.srcRoot)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void noStateLoaded() {
        this.loadStateFromExternalStorage();
    }

    public void loadState(@NotNull Element parentNode) {
        Element node;
        Element notNullAssertions;
        if (parentNode == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(18);
        }
        this.myState = (State)XmlSerializer.deserialize((Element)parentNode, State.class);
        if (!this.myProject.isDefault()) {
            Element option;
            Iterator iterator = parentNode.getChildren("option").iterator();
            while (iterator.hasNext() && !"DEFAULT_COMPILER".equals((option = (Element)iterator.next()).getAttributeValue("name"))) {
            }
            if (this.myState.BUILD_PROCESS_HEAP_SIZE == 700) {
                CompilerWorkspaceConfiguration workspace = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
                this.myState.BUILD_PROCESS_HEAP_SIZE = workspace.COMPILER_PROCESS_HEAP_SIZE;
            }
        }
        if ((notNullAssertions = parentNode.getChild("addNotNullAssertions")) != null) {
            this.myAddNotNullAssertions = Boolean.valueOf(notNullAssertions.getAttributeValue("enabled", "true"));
        }
        if ((node = parentNode.getChild("excludeFromCompile")) != null) {
            this.myExcludesConfiguration.readExternal(node);
        }
        try {
            this.removeRegexpPatterns();
            node = parentNode.getChild("resourceExtensions");
            if (node != null) {
                for (Object o : node.getChildren("entry")) {
                    Element element = (Element)o;
                    String pattern = element.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)pattern)) continue;
                    this.addRegexpPattern(pattern);
                }
            }
            if ((node = parentNode.getChild("wildcardResourcePatterns")) != null) {
                this.myWildcardPatternsInitialized = true;
                this.removeWildcardPatterns();
                for (Element element : node.getChildren("entry")) {
                    String pattern = element.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)pattern)) continue;
                    this.addWildcardResourcePattern(pattern);
                }
            }
        }
        catch (MalformedPatternException e) {
            LOG.error((Throwable)e);
        }
        this.myModuleProcessorProfiles.clear();
        this.myProcessorsProfilesMap = null;
        Element annotationProcessingSettings = parentNode.getChild("annotationProcessing");
        if (annotationProcessingSettings != null) {
            List profiles = annotationProcessingSettings.getChildren("profile");
            if (!profiles.isEmpty()) {
                for (Object elem : profiles) {
                    Element profileElement = (Element)elem;
                    boolean isDefault = "true".equals(profileElement.getAttributeValue("default"));
                    if (isDefault) {
                        AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)this.myDefaultProcessorsProfile, (Element)profileElement);
                        continue;
                    }
                    ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl("");
                    AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)profile, (Element)profileElement);
                    this.myModuleProcessorProfiles.add((ProcessorConfigProfile)profile);
                }
            } else {
                this.loadProfilesFromOldFormat(annotationProcessingSettings);
            }
        }
        this.myBytecodeTargetLevel = null;
        this.myModuleBytecodeTarget.clear();
        Element bytecodeTargetElement = parentNode.getChild("bytecodeTargetLevel");
        if (bytecodeTargetElement != null) {
            this.myBytecodeTargetLevel = bytecodeTargetElement.getAttributeValue("target");
            ExternalCompilerConfigurationStorageKt.readByteTargetLevel(parentNode, this.myModuleBytecodeTarget);
        }
        this.loadStateFromExternalStorage();
    }

    private void loadStateFromExternalStorage() {
        ExternalCompilerConfigurationStorage externalStorage = ExternalCompilerConfigurationStorage.getInstance(this.myProject);
        Map<String, String> externalState = externalStorage.getLoadedState();
        if (externalState != null) {
            this.myModuleBytecodeTarget.putAll(externalState);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadProfilesFromOldFormat(Element processing) {
        boolean isEnabled = Boolean.parseBoolean(processing.getAttributeValue("enabled", "false"));
        boolean isUseClasspath = Boolean.parseBoolean(processing.getAttributeValue("useClasspath", "true"));
        StringBuilder processorPath = new StringBuilder();
        HashSet<String> optionPairs = new HashSet<String>();
        HashSet<String> processors = new HashSet<String>();
        ArrayList<Couple> modulesToProcess = new ArrayList<Couple>();
        for (Object e : processing.getChildren("processorPath")) {
            Element pathElement = (Element)e;
            String path = pathElement.getAttributeValue("value", (String)null);
            if (path == null) continue;
            if (processorPath.length() > 0) {
                processorPath.append(File.pathSeparator);
            }
            processorPath.append(path);
        }
        for (Object e : processing.getChildren("processor")) {
            Element processorElement = (Element)e;
            String proc = processorElement.getAttributeValue("name", (String)null);
            if (proc != null) {
                processors.add(proc);
            }
            StringTokenizer tokenizer = new StringTokenizer(processorElement.getAttributeValue("options", ""), " ", false);
            while (tokenizer.hasMoreTokens()) {
                String pair2 = tokenizer.nextToken();
                optionPairs.add(pair2);
            }
        }
        for (Object e : processing.getChildren("processModule")) {
            Element moduleElement = (Element)e;
            String name2 = moduleElement.getAttributeValue("name", (String)null);
            if (name2 == null) continue;
            String dir = moduleElement.getAttributeValue("generatedDirName", (String)null);
            modulesToProcess.add(Couple.of((Object)name2, (Object)dir));
        }
        this.myDefaultProcessorsProfile.setEnabled(false);
        this.myDefaultProcessorsProfile.setObtainProcessorsFromClasspath(isUseClasspath);
        if (processorPath.length() > 0) {
            this.myDefaultProcessorsProfile.setProcessorPath(processorPath.toString());
        }
        if (!optionPairs.isEmpty()) {
            for (String string : optionPairs) {
                int index = string.indexOf("=");
                if (index <= 0) continue;
                this.myDefaultProcessorsProfile.setOption(string.substring(0, index), string.substring(index + 1));
            }
        }
        for (String string : processors) {
            this.myDefaultProcessorsProfile.addProcessor(string);
        }
        HashMap<String, HashSet<String>> dirNameToModulesMap = new HashMap<String, HashSet<String>>();
        for (Couple moduleDirPair : modulesToProcess) {
            String dir = (String)moduleDirPair.getSecond();
            HashSet<String> set = (HashSet<String>)dirNameToModulesMap.get(dir);
            if (set == null) {
                set = new HashSet<String>();
                dirNameToModulesMap.put(dir, set);
            }
            set.add((String)moduleDirPair.getFirst());
        }
        boolean bl = false;
        for (Map.Entry entry : dirNameToModulesMap.entrySet()) {
            void var9_20;
            String dirName = (String)entry.getKey();
            ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl(this.myDefaultProcessorsProfile);
            profile.setName("Profile" + (int)(++var9_20));
            profile.setEnabled(isEnabled);
            profile.setGeneratedSourcesDirectoryName(dirName, false);
            for (String moduleName : (Set)entry.getValue()) {
                profile.addModuleName(moduleName);
            }
            this.myModuleProcessorProfiles.add((ProcessorConfigProfile)profile);
        }
    }

    public BackendCompiler getDefaultCompiler() {
        if (this.myRegisteredCompilers.isEmpty()) {
            this.collectCompilers();
        }
        return this.myDefaultJavaCompiler;
    }

    public void setDefaultCompiler(BackendCompiler defaultCompiler) {
        this.myDefaultJavaCompiler = defaultCompiler;
        this.myState.DEFAULT_COMPILER = defaultCompiler.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertPatterns() {
        if (!this.needPatternConversion()) {
            return;
        }
        try {
            boolean ok;
            try {
                ok = this.doConvertPatterns();
            }
            catch (MalformedPatternException ignored) {
                ok = false;
            }
            if (!ok) {
                String initialPatternString = CompilerConfigurationImpl.patternsToString(this.getRegexpPatterns());
                String message2 = JavaCompilerBundle.message((String)"message.resource.patterns.format.changed", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), initialPatternString, CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()});
                String wildcardPatterns = Messages.showInputDialog((Project)this.myProject, (String)message2, (String)JavaCompilerBundle.message((String)"pattern.conversion.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)initialPatternString, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        StringTokenizer tokenizer = new StringTokenizer(inputString, ";", false);
                        StringBuilder malformedPatterns = new StringBuilder();
                        while (tokenizer.hasMoreTokens()) {
                            String pattern = tokenizer.nextToken();
                            try {
                                CompilerConfigurationImpl.this.addWildcardResourcePattern(pattern);
                            }
                            catch (MalformedPatternException e) {
                                malformedPatterns.append("\n\n");
                                malformedPatterns.append(pattern);
                                malformedPatterns.append(": ");
                                malformedPatterns.append(e.getMessage());
                            }
                        }
                        if (malformedPatterns.length() > 0) {
                            Messages.showErrorDialog((String)JavaCompilerBundle.message((String)"error.bad.resource.patterns", (Object[])new Object[]{malformedPatterns.toString()}), (String)JavaCompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
                            CompilerConfigurationImpl.this.removeWildcardPatterns();
                            return false;
                        }
                        return true;
                    }
                });
                if (wildcardPatterns == null) {
                    this.loadDefaultWildcardPatterns();
                }
            }
        }
        finally {
            this.myWildcardPatternsInitialized = true;
        }
    }

    private boolean needPatternConversion() {
        return !this.myWildcardPatternsInitialized && !this.myRegexpResourcePatterns.isEmpty();
    }

    private boolean doConvertPatterns() throws MalformedPatternException {
        String[] regexpPatterns = this.getRegexpPatterns();
        ArrayList<String> converted = new ArrayList<String>();
        Pattern multipleExtensionsPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.\\((\\w+(?:\\|\\w+)*)\\)");
        Pattern singleExtensionPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.(\\w+)");
        Perl5Matcher matcher = new Perl5Matcher();
        for (String regexpPattern : regexpPatterns) {
            MatchResult match;
            if (matcher.matches(regexpPattern, multipleExtensionsPatternPattern)) {
                match = matcher.getMatch();
                StringTokenizer tokenizer = new StringTokenizer(match.group(1), "|", false);
                while (tokenizer.hasMoreTokens()) {
                    converted.add("?*." + tokenizer.nextToken());
                }
                continue;
            }
            if (matcher.matches(regexpPattern, singleExtensionPatternPattern)) {
                match = matcher.getMatch();
                converted.add("?*." + match.group(1));
                continue;
            }
            return false;
        }
        for (String aConverted : converted) {
            this.addWildcardResourcePattern(aConverted);
        }
        return true;
    }

    private static String patternsToString(String[] patterns) {
        StringBuilder extensionsString = new StringBuilder();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }

    public boolean isCompilableResourceFile(Project project, VirtualFile file) {
        if (!this.isResourceFile(file)) {
            return false;
        }
        Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project).findArtifacts(file);
        return artifacts.isEmpty();
    }

    private static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent(child);
        return child;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExcludedEntriesConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalOptions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCompilers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProcessorProfile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProcessorProfiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedEntriesConfiguration";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModulesBytecodeTargetMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModuleProcessorProfile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addModuleProcessorProfile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompiledPattern {
        @NotNull
        final Pattern fileName;
        @Nullable
        final Pattern dir;
        @Nullable
        final Pattern srcRoot;

        private CompiledPattern(@NotNull Pattern fileName, @Nullable Pattern dir, @Nullable Pattern srcRoot) {
            if (fileName == null) {
                CompiledPattern.$$$reportNull$$$0(0);
            }
            this.fileName = fileName;
            this.dir = dir;
            this.srcRoot = srcRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/compiler/CompilerConfigurationImpl$CompiledPattern", "<init>"));
        }
    }

    private static class State {
        public String DEFAULT_COMPILER = "Javac";
        public int BUILD_PROCESS_HEAP_SIZE = 700;
        public String BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = "";
        public boolean USE_RELEASE_OPTION = true;

        private State() {
        }
    }
}

