/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirtyScopeHolder
extends UserDataHolderBase
implements AsyncFileListener {
    private final CompilerReferenceServiceBase<?> myService;
    private final FileDocumentManager myFileDocManager;
    private final PsiDocumentManager myPsiDocManager;
    private final Object myLock;
    private final Set<Module> myVFSChangedModules;
    private final Set<Module> myChangedModulesDuringCompilation;
    private final List<ExcludeEntryDescription> myExcludedDescriptions;
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules;
    private final FileTypeRegistry myFileTypeRegistry;

    DirtyScopeHolder(@NotNull CompilerReferenceServiceBase<?> service, @NotNull FileDocumentManager fileDocumentManager, @NotNull PsiDocumentManager psiDocumentManager, @NotNull BiConsumer<? super MessageBusConnection, ? super Set<String>> compilationAffectedModulesSubscription) {
        if (service == null) {
            DirtyScopeHolder.$$$reportNull$$$0(0);
        }
        if (fileDocumentManager == null) {
            DirtyScopeHolder.$$$reportNull$$$0(1);
        }
        if (psiDocumentManager == null) {
            DirtyScopeHolder.$$$reportNull$$$0(2);
        }
        if (compilationAffectedModulesSubscription == null) {
            DirtyScopeHolder.$$$reportNull$$$0(3);
        }
        this.myLock = new Object();
        this.myVFSChangedModules = new HashSet<Module>();
        this.myChangedModulesDuringCompilation = new HashSet<Module>();
        this.myExcludedDescriptions = new SmartList();
        this.myCompilationAffectedModules = ContainerUtil.newConcurrentSet();
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
        this.myService = service;
        this.myFileDocManager = fileDocumentManager;
        this.myPsiDocManager = psiDocumentManager;
        if (CompilerReferenceService.isEnabled()) {
            MessageBusConnection connect = service.getProject().getMessageBus().connect();
            connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                    if (description == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        if (DirtyScopeHolder.this.myCompilationPhase) {
                            DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/compiler/backwardRefs/DirtyScopeHolder$1", "onEntryAdded"));
                }
            });
            compilationAffectedModulesSubscription.accept((MessageBusConnection)connect, this.myCompilationAffectedModules);
            connect.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Object[] modules = ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules();
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        ContainerUtil.addAll((Collection)DirtyScopeHolder.this.myVFSChangedModules, (Object[])modules);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/backwardRefs/DirtyScopeHolder$2", "beforeRootsChange"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myService.getProject()).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    public void upToDateChecked(boolean isUpToDate) {
        Module[] modules = (Module[])ReadAction.compute(() -> {
            Project project = this.myService.getProject();
            if (project.isDisposed()) {
                return null;
            }
            return ModuleManager.getInstance((Project)project).getModules();
        });
        if (modules == null) {
            return;
        }
        this.compilationFinished(() -> {
            if (!isUpToDate) {
                ContainerUtil.addAll(this.myVFSChangedModules, (Object[])modules);
            }
        });
    }

    void compilerActivityFinished() {
        List compiledModules = (List)ReadAction.compute(() -> {
            Project project = this.myService.getProject();
            if (project.isDisposed()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myService.getProject());
            return ContainerUtil.map(this.myCompilationAffectedModules, arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0));
        });
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            this.myVFSChangedModules.removeAll(compiledModules);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(@NotNull Runnable action) {
        ExcludeEntryDescription[] descriptions;
        if (action == null) {
            DirtyScopeHolder.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[0]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myService.getFileTypes(), this.myService.getProject(), this.myService.getFileIndex());
    }

    @NotNull
    public GlobalSearchScope getDirtyScope() {
        Project project = this.myService.getProject();
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return GlobalSearchScope.allScope((Project)project);
                }
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myService}));
            }
        });
        if (globalSearchScope == null) {
            DirtyScopeHolder.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            GlobalSearchScope globalSearchScope = this.myExcludedFilesScope;
            if (globalSearchScope == null) {
                DirtyScopeHolder.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        GlobalSearchScope dirtyModuleScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])dirtyModules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
        GlobalSearchScope globalSearchScope = dirtyModuleScope.union((SearchScope)this.myExcludedFilesScope);
        if (globalSearchScope == null) {
            DirtyScopeHolder.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public Set<Module> getAllDirtyModules() {
        THashSet dirtyModules = new THashSet(this.myVFSChangedModules);
        for (Document document : this.myFileDocManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file = this.myFileDocManager.getFile(document);
            if (file == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        for (Document document : this.myPsiDocManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file;
            PsiFile psiFile = this.myPsiDocManager.getPsiFile(document);
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        THashSet tHashSet = dirtyModules;
        if (tHashSet == null) {
            DirtyScopeHolder.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(9);
        }
        return this.getDirtyScope().contains(file);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(10);
        }
        final List<Module> modulesToBeMarkedDirty = this.getModulesToBeMarkedDirtyBefore(events);
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                modulesToBeMarkedDirty.forEach(x$0 -> DirtyScopeHolder.this.addToDirtyModules(x$0));
            }

            public void afterVfsChange() {
                if (!DirtyScopeHolder.this.myService.getProject().isDisposed()) {
                    DirtyScopeHolder.this.after(events);
                }
            }
        };
    }

    private void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(11);
        }
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            if (vFileEvent instanceof VFileCreateEvent) {
                String fileName;
                VirtualFile parent = ((VFileCreateEvent)vFileEvent).getParent();
                Module module = this.getModuleForSourceContentFile(parent, fileName = ((VFileCreateEvent)vFileEvent).getChildName());
                if (module == null) continue;
                this.addToDirtyModules(module);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                this.fileChanged(file);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            this.fileChanged(pce.getFile());
        }
    }

    @Contract(pure=true)
    @NotNull
    private List<Module> getModulesToBeMarkedDirtyBefore(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(12);
        }
        ArrayList<Module> modulesToBeMarkedDirty = new ArrayList<Module>();
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            ProgressManager.checkCanceled();
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                Module module = this.getModuleForSourceContentFile(file);
                ContainerUtil.addIfNotNull(modulesToBeMarkedDirty, (Object)module);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            String path = pce.getFile().getPath();
            for (Module module : ModuleManager.getInstance((Project)this.myService.getProject()).getModules()) {
                if (!FileUtil.isAncestor((String)path, (String)module.getModuleFilePath(), (boolean)true)) continue;
                modulesToBeMarkedDirty.add(module);
            }
        }
        ArrayList<Module> arrayList = modulesToBeMarkedDirty;
        if (arrayList == null) {
            DirtyScopeHolder.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public void installVFSListener(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DirtyScopeHolder.$$$reportNull$$$0(14);
        }
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this, parentDisposable);
    }

    private void fileChanged(@NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(15);
        }
        if ((module = this.getModuleForSourceContentFile(file)) != null) {
            this.addToDirtyModules(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirtyModules(@NotNull Module module) {
        if (module == null) {
            DirtyScopeHolder.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCompilationPhase) {
                this.myChangedModulesDuringCompilation.add(module);
            } else {
                this.myVFSChangedModules.add(module);
            }
        }
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file) {
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(17);
        }
        return this.getModuleForSourceContentFile(file, file.getNameSequence());
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile parent, @NotNull CharSequence fileName) {
        if (parent == null) {
            DirtyScopeHolder.$$$reportNull$$$0(18);
        }
        if (fileName == null) {
            DirtyScopeHolder.$$$reportNull$$$0(19);
        }
        FileType fileType = this.myFileTypeRegistry.getFileTypeByFileName(fileName);
        if (this.myService.getFileTypes().contains(fileType) && this.myService.getFileIndex().isInSourceContent(parent)) {
            return this.myService.getFileIndex().getModuleForFile(parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Set<Module> getAllDirtyModulesForTest() {
        Object object = this.myLock;
        // MONITORENTER : object
        Set<Module> set = this.getAllDirtyModules();
        // MONITOREXIT : object
        if (set != null) return set;
        DirtyScopeHolder.$$$reportNull$$$0(20);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        // MONITORENTER : object
        Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
        ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
        ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
        Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
        ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
        DirtyScopeTestInfo dirtyScopeTestInfo = new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        // MONITOREXIT : object
        if (dirtyScopeTestInfo != null) return dirtyScopeTestInfo;
        DirtyScopeHolder.$$$reportNull$$$0(21);
        return dirtyScopeTestInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilationAffectedModulesSubscription";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDirtyScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyModules";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBeMarkedDirtyBefore";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyModulesForTest";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compilationFinished";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBeMarkedDirtyBefore";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "installVFSListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fileChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addToDirtyModules";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForSourceContentFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

