/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ChainSearchTarget {
    private static final Set<String> EXCLUDED_PACKAGES = ContainerUtil.set((Object[])new String[]{"java.lang", "java.util.function"});
    private final String myClassQName;
    private final byte[] myAcceptedArrayKinds;
    private final PsiType myPsiType;
    private final boolean myIteratorAccess;

    public ChainSearchTarget(String classQName, byte[] arrayKinds, PsiType targetType) {
        this(classQName, arrayKinds, targetType, false);
    }

    private ChainSearchTarget(String classQName, byte[] arrayKinds, PsiType targetType, boolean iteratorAccess) {
        this.myClassQName = classQName;
        this.myAcceptedArrayKinds = arrayKinds;
        this.myPsiType = targetType;
        this.myIteratorAccess = iteratorAccess;
    }

    public String getClassQName() {
        return this.myClassQName;
    }

    public byte[] getArrayKind() {
        return this.myAcceptedArrayKinds;
    }

    public PsiClass getTargetClass() {
        return PsiUtil.resolveClassInType((PsiType)this.myPsiType);
    }

    public boolean isIteratorAccess() {
        return this.myIteratorAccess;
    }

    public ChainSearchTarget toIterators() {
        return this.myAcceptedArrayKinds.length == 1 && this.myAcceptedArrayKinds[0] == 0 ? new ChainSearchTarget(this.myClassQName, new byte[]{1, -1}, this.myPsiType, true) : this;
    }

    @Nullable
    public static ChainSearchTarget create(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return ChainSearchTarget.create((PsiArrayType)type2);
        }
        if (type2 instanceof PsiClassType) {
            return ChainSearchTarget.create((PsiClassType)type2);
        }
        return null;
    }

    @Nullable
    private static ChainSearchTarget create(PsiArrayType arrayType) {
        PsiType componentType = arrayType.getComponentType();
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)componentType);
        if (aClass == null) {
            return null;
        }
        String targetQName = aClass.getQualifiedName();
        if (targetQName == null) {
            return null;
        }
        return new ChainSearchTarget(targetQName, new byte[]{1}, (PsiType)arrayType);
    }

    @Nullable
    private static ChainSearchTarget create(PsiClassType classType) {
        PsiClass resolvedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)classType);
        if (resolvedClass == null) {
            return null;
        }
        byte iteratorKind = 0;
        String iteratorClass = ChainSearchTarget.getIteratorKind(resolvedClass);
        if (iteratorClass != null) {
            resolvedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)PsiUtil.substituteTypeParameter((PsiType)classType, (String)iteratorClass, (int)0, (boolean)false));
            if (resolvedClass == null) {
                return null;
            }
            iteratorKind = -1;
        }
        if (resolvedClass.hasTypeParameters() || resolvedClass instanceof PsiTypeParameter || AnnotationUtil.isAnnotated((PsiModifierListOwner)resolvedClass, (String)"java.lang.FunctionalInterface", (int)2)) {
            return null;
        }
        String packageName = JavaHierarchyUtil.getPackageName(resolvedClass);
        if (packageName == null || EXCLUDED_PACKAGES.contains(packageName)) {
            return null;
        }
        String classQName = resolvedClass.getQualifiedName();
        if (classQName == null) {
            return null;
        }
        return new ChainSearchTarget(classQName, new byte[]{iteratorKind}, (PsiType)classType);
    }

    public static String getIteratorKind(PsiClass resolvedClass) {
        if (InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"java.lang.Iterable")) {
            return "java.lang.Iterable";
        }
        if (InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"java.util.Iterator")) {
            return "java.util.Iterator";
        }
        if (InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"java.util.stream.Stream")) {
            return "java.util.stream.Stream";
        }
        return null;
    }
}

