/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CompilerContentIterator
implements ContentIterator {
    final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
    private final FileType myFileType;
    private final FileIndex myFileIndex;
    private final boolean myInSourceOnly;
    private final Collection<? super VirtualFile> myFiles;

    public CompilerContentIterator(FileType fileType, FileIndex fileIndex, boolean inSourceOnly, Collection<? super VirtualFile> files) {
        this.myFileType = fileType;
        this.myFileIndex = fileIndex;
        this.myInSourceOnly = inSourceOnly;
        this.myFiles = files;
    }

    public boolean processFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            CompilerContentIterator.$$$reportNull$$$0(0);
        }
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (!fileOrDir.isInLocalFileSystem()) {
            return true;
        }
        if (this.myInSourceOnly && !this.myFileIndex.isInSourceContent(fileOrDir)) {
            return true;
        }
        if (this.myFileType == null || FileTypeRegistry.getInstance().isFileOfType(fileOrDir, this.myFileType)) {
            this.myFiles.add((VirtualFile)fileOrDir);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/compiler/impl/CompilerContentIterator", "processFile"));
    }
}

