/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class ProjectCompileScope
extends FileIndexCompileScope {
    private final Project myProject;

    public ProjectCompileScope(Project project) {
        this.myProject = project;
    }

    @Override
    protected FileIndex[] getFileIndices() {
        return new FileIndex[]{ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()};
    }

    public boolean belongs(@NotNull String url) {
        VirtualFile file;
        if (url == null) {
            ProjectCompileScope.$$$reportNull$$$0(0);
        }
        if ((file = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
            for (FileIndex index : this.getFileIndices()) {
                if (!index.isInSourceContent(file)) continue;
                return true;
            }
        } else {
            for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots()) {
                String rootUrl = root.getUrl();
                if (!FileUtil.startsWith((String)url, (String)(rootUrl.endsWith("/") ? rootUrl : rootUrl + "/"))) continue;
                return true;
            }
        }
        return false;
    }

    public Module @NotNull [] getAffectedModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            ProjectCompileScope.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/ProjectCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/ProjectCompileScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

