/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor
implements AsyncFileListener {
    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    private static void processRecursively(final @NotNull VirtualFile fromFile, final boolean dbOnly, final @NotNull FileProcessor processor2) {
        if (fromFile == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(1);
        }
        if (!(fromFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!file.isDirectory()) {
                    processor2.execute(file);
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                return result;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (dbOnly) {
                    return file.isDirectory() ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
                if (file.equals(fromFile) || !file.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file) ? null : ((NewVirtualFile)file).iterInDbChildren();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isInContentOfOpenedProject(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(2);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isInitialized() || !BuildManager.getInstance().isProjectWatched(project) || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
            return true;
        }
        return false;
    }

    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(3);
        }
        THashSet filesChanged = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        THashSet filesDeleted = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent) {
                TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), (Collection<? super File>)filesDeleted);
                continue;
            }
            if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
            TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), (Collection<? super File>)filesChanged);
        }
        return new AsyncFileListener.ChangeApplier((Set)filesDeleted, (Set)filesChanged){
            final /* synthetic */ Set val$filesDeleted;
            final /* synthetic */ Set val$filesChanged;
            {
                this.val$filesDeleted = set;
                this.val$filesChanged = set2;
            }

            public void afterVfsChange() {
                TranslatingCompilerFilesMonitor.after(events, this.val$filesDeleted, this.val$filesChanged);
            }
        };
    }

    private static void after(@NotNull List<? extends VFileEvent> events, Set<File> filesDeleted, Set<File> filesChanged) {
        if (events == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(4);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                TranslatingCompilerFilesMonitor.handlePropChange((VFilePropertyChangeEvent)vFileEvent, filesDeleted, filesChanged);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileCopyEvent)) continue;
            TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), filesChanged);
        }
        TranslatingCompilerFilesMonitor.notifyFilesDeleted(filesDeleted);
        TranslatingCompilerFilesMonitor.notifyFilesChanged(filesChanged);
    }

    private static void handlePropChange(@NotNull VFilePropertyChangeEvent event, final @NotNull Collection<? super File> filesDeleted, @NotNull Collection<? super File> filesChanged) {
        if (event == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(5);
        }
        if (filesDeleted == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(6);
        }
        if (filesChanged == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(7);
        }
        if ("name".equals(event.getPropertyName())) {
            String newName;
            String oldName = (String)event.getOldValue();
            if (Objects.equals(oldName, newName = (String)event.getNewValue())) {
                return;
            }
            final VirtualFile eventFile = event.getFile();
            if (TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(eventFile)) {
                VirtualFile parent = eventFile.getParent();
                if (parent != null) {
                    final String root = parent.getPath() + "/" + oldName;
                    if (eventFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
                            private final StringBuilder filePath;
                            {
                                super(arg0);
                                this.filePath = new StringBuilder(root);
                            }

                            public boolean visitFile(@NotNull VirtualFile child) {
                                if (child == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                if (child.isDirectory()) {
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        this.filePath.append("/").append(child.getName());
                                    }
                                } else {
                                    String childPath = this.filePath.toString();
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        childPath = childPath + "/" + child.getName();
                                    }
                                    filesDeleted.add(new File(childPath));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile file) {
                                if (file == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                if (file.isDirectory() && !Comparing.equal((Object)file, (Object)eventFile)) {
                                    this.filePath.delete(this.filePath.length() - file.getName().length() - 1, this.filePath.length());
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "child";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$3";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitFile";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "afterChildrenVisited";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    } else {
                        filesDeleted.add(new File(root));
                    }
                }
                TranslatingCompilerFilesMonitor.collectPaths(eventFile, filesChanged);
            }
        }
    }

    private static void collectPaths(@Nullable VirtualFile file, @NotNull Collection<? super File> outFiles) {
        if (outFiles == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(8);
        }
        if (file != null && !TranslatingCompilerFilesMonitor.isIgnoredOrUnderIgnoredDirectory(file)) {
            TranslatingCompilerFilesMonitor.processRecursively(file, !TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file), f -> outFiles.add(new File(f.getPath())));
        }
    }

    private static boolean isIgnoredOrUnderIgnoredDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(9);
        }
        if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredByBuild(@NotNull VirtualFile file) {
        if (file == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(10);
        }
        return FileTypeManager.getInstance().isFileIgnored(file) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)file.getPath(), (boolean)false);
    }

    private static void notifyFilesChanged(@NotNull Collection<? extends File> paths) {
        if (paths == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(11);
        }
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(paths);
        }
    }

    private static void notifyFilesDeleted(@NotNull Collection<? extends File> paths) {
        if (paths == null) {
            TranslatingCompilerFilesMonitor.$$$reportNull$$$0(12);
        }
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(paths);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesDeleted";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesChanged";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContentOfOpenedProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePropChange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "collectPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredOrUnderIgnoredDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredByBuild";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyFilesChanged";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyFilesDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    private static interface FileProcessor {
        public void execute(@NotNull VirtualFile var1);
    }
}

