/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.DynamicBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.options.TargetOptionsComponent;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JavaCompilersTab
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JPanel myContentPanel;
    private JComboBox<BackendCompiler> myCompiler;
    private JPanel myTargetOptionsPanel;
    private JBCheckBox myCbUseReleaseOption;
    private final CardLayout myCardLayout;
    private final Project myProject;
    private final CompilerConfigurationImpl myCompilerConfiguration;
    private final BackendCompiler myDefaultCompiler;
    private final TargetOptionsComponent myTargetLevelComponent;
    private final List<Configurable> myConfigurables;
    private BackendCompiler mySelectedCompiler;

    public JavaCompilersTab(@NotNull Project project) {
        if (project == null) {
            JavaCompilersTab.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCompilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        this.myDefaultCompiler = this.myCompilerConfiguration.getDefaultCompiler();
        this.myTargetLevelComponent = new TargetOptionsComponent(project);
        this.myCardLayout = new CardLayout();
        this.myContentPanel.setLayout(this.myCardLayout);
        this.myTargetOptionsPanel.setLayout(new BorderLayout());
        this.myTargetOptionsPanel.add((Component)this.myTargetLevelComponent, "Center");
        Collection<BackendCompiler> compilers = this.myCompilerConfiguration.getRegisteredJavaCompilers();
        this.myConfigurables = new ArrayList<Configurable>(compilers.size());
        for (BackendCompiler compiler : compilers) {
            Configurable configurable = compiler.createConfigurable();
            this.myConfigurables.add(configurable);
            JComponent component = configurable.createComponent();
            assert (component != null) : configurable.getClass();
            this.myContentPanel.add((Component)component, compiler.getId());
        }
        this.myCompiler.setModel(new DefaultComboBoxModel<BackendCompiler>(compilers.toArray(new BackendCompiler[0])));
        this.myCompiler.setRenderer((ListCellRenderer<BackendCompiler>)SimpleListCellRenderer.create((String)"", BackendCompiler::getPresentableName));
        this.myCompiler.addActionListener(e -> {
            BackendCompiler compiler = (BackendCompiler)this.myCompiler.getSelectedItem();
            if (compiler != null) {
                this.selectCompiler(compiler);
            }
        });
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"java.compiler.description", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.projectsettings.compiler.javacompiler";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            JavaCompilersTab.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.mySelectedCompiler, (Object)this.myCompilerConfiguration.getDefaultCompiler()) || this.myCbUseReleaseOption.isSelected() != this.myCompilerConfiguration.useReleaseOption() || !Objects.equals(this.myTargetLevelComponent.getProjectBytecodeTarget(), this.myCompilerConfiguration.getProjectBytecodeTarget()) || !Comparing.equal(this.myTargetLevelComponent.getModulesBytecodeTargetMap(), this.myCompilerConfiguration.getModulesBytecodeTargetMap()) || super.isModified();
    }

    public void apply() throws ConfigurationException {
        try {
            this.myCompilerConfiguration.setDefaultCompiler(this.mySelectedCompiler);
            this.myCompilerConfiguration.setUseReleaseOption(this.myCbUseReleaseOption.isSelected());
            this.myCompilerConfiguration.setProjectBytecodeTarget(this.myTargetLevelComponent.getProjectBytecodeTarget());
            this.myCompilerConfiguration.setModulesBytecodeTargetMap(this.myTargetLevelComponent.getModulesBytecodeTargetMap());
            super.apply();
            this.myTargetLevelComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
            this.myTargetLevelComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
        }
        finally {
            BuildManager.getInstance().clearState(this.myProject);
            PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
        }
    }

    public void reset() {
        super.reset();
        this.selectCompiler(this.myCompilerConfiguration.getDefaultCompiler());
        this.myCbUseReleaseOption.setSelected(this.myCompilerConfiguration.useReleaseOption());
        this.myTargetLevelComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
        this.myTargetLevelComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
    }

    private void selectCompiler(BackendCompiler compiler) {
        if (compiler == null) {
            compiler = this.myDefaultCompiler;
        }
        this.myCompiler.setSelectedItem(compiler);
        this.mySelectedCompiler = compiler;
        this.myCardLayout.show(this.myContentPanel, compiler.getId());
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    @NotNull
    protected List<Configurable> createConfigurables() {
        List<Configurable> list = this.myConfigurables;
        if (list == null) {
            JavaCompilersTab.$$$reportNull$$$0(2);
        }
        return list;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", JavaCompilersTab.class).getString("option.use.compiler.text"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myCompiler = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myTargetOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbUseReleaseOption = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", JavaCompilersTab.class).getString("settings.use.release.option.for.cross.compilation"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/JavaCompilersTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/JavaCompilersTab";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

