/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CyclicDependenciesBuilder {
    @NotNull
    private final Project myProject;
    private final AnalysisScope myScope;
    private final Map<String, PsiPackage> myPackages;
    private Graph<PsiPackage> myGraph;
    private final Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> myFilesInDependentPackages;
    private final Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> myBackwardFilesInDependentPackages;
    private final Map<PsiPackage, Set<PsiPackage>> myPackageDependencies;
    private HashMap<PsiPackage, Set<List<PsiPackage>>> myCyclicDependencies;
    private int myFileCount;
    private final ForwardDependenciesBuilder myForwardBuilder;
    private String myRootNodeNameInUsageView;

    public CyclicDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(1);
        }
        this.myPackages = new HashMap<String, PsiPackage>();
        this.myFilesInDependentPackages = new HashMap<PsiPackage, Map<PsiPackage, Set<PsiFile>>>();
        this.myBackwardFilesInDependentPackages = new HashMap<PsiPackage, Map<PsiPackage, Set<PsiFile>>>();
        this.myPackageDependencies = new HashMap<PsiPackage, Set<PsiPackage>>();
        this.myCyclicDependencies = new HashMap();
        this.myProject = project;
        this.myScope = scope;
        this.myForwardBuilder = new ForwardDependenciesBuilder(this.myProject, this.myScope){

            public String getRootNodeNameInUsageView() {
                return CyclicDependenciesBuilder.this.getRootNodeNameInUsageView();
            }

            public String getInitialUsagesPosition() {
                return JavaBundle.message((String)"cyclic.dependencies.usage.view.initial.text", (Object[])new Object[0]);
            }
        };
    }

    @NotNull
    private String getRootNodeNameInUsageView() {
        String string = this.myRootNodeNameInUsageView;
        if (string == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setRootNodeNameInUsageView(@NotNull String rootNodeNameInUsageView) {
        if (rootNodeNameInUsageView == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(3);
        }
        this.myRootNodeNameInUsageView = rootNodeNameInUsageView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(5);
        }
        return analysisScope;
    }

    @NotNull
    public DependenciesBuilder getForwardBuilder() {
        ForwardDependenciesBuilder forwardDependenciesBuilder = this.myForwardBuilder;
        if (forwardDependenciesBuilder == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(6);
        }
        return forwardDependenciesBuilder;
    }

    public void analyze() {
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file instanceof PsiJavaFile) {
                    PsiPackage aPackage;
                    PsiJavaFile psiJavaFile = (PsiJavaFile)file;
                    if (CyclicDependenciesBuilder.this.getScope().contains((PsiElement)psiJavaFile) && (aPackage = CyclicDependenciesBuilder.this.findPackage(psiJavaFile.getPackageName())) != null) {
                        CyclicDependenciesBuilder.this.myPackages.put(psiJavaFile.getPackageName(), aPackage);
                    }
                    Set packs = CyclicDependenciesBuilder.this.getPackageHierarchy(psiJavaFile.getPackageName());
                    ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(CyclicDependenciesBuilder.this.getProject(), new AnalysisScope((PsiFile)psiJavaFile));
                    builder.setTotalFileCount(CyclicDependenciesBuilder.this.getScope().getFileCount());
                    builder.setInitialFileCount(++CyclicDependenciesBuilder.this.myFileCount);
                    builder.analyze();
                    Set psiFiles = (Set)builder.getDependencies().get(psiJavaFile);
                    if (psiFiles == null) {
                        return;
                    }
                    for (PsiPackage pack : packs) {
                        Set pack2Packages = CyclicDependenciesBuilder.this.myPackageDependencies.computeIfAbsent(pack, __ -> new HashSet());
                        for (PsiFile psiFile : psiFiles) {
                            PsiPackage depPackage;
                            String packageName;
                            if (!(psiFile instanceof PsiJavaFile) || !projectFileIndex.isInSourceContent(psiFile.getVirtualFile()) || !CyclicDependenciesBuilder.this.getScope().contains((PsiElement)psiFile) || (packageName = ((PsiJavaFile)psiFile).getPackageName()).startsWith(pack.getQualifiedName()) || (depPackage = CyclicDependenciesBuilder.this.findPackage(packageName)) == null) continue;
                            pack2Packages.add(depPackage);
                            CyclicDependenciesBuilder.this.constractFilesInDependenciesPackagesMap(pack, depPackage, psiFile, CyclicDependenciesBuilder.this.myFilesInDependentPackages);
                            CyclicDependenciesBuilder.this.constractFilesInDependenciesPackagesMap(depPackage, pack, (PsiFile)psiJavaFile, CyclicDependenciesBuilder.this.myBackwardFilesInDependentPackages);
                            CyclicDependenciesBuilder.this.constractWholeDependenciesMap(psiJavaFile, psiFile);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cyclicDependencies/CyclicDependenciesBuilder$2", "visitFile"));
            }
        });
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)indicator);
            indicator.setText(JavaBundle.message((String)"cyclic.dependencies.progress.text", (Object[])new Object[0]));
            indicator.setText2("");
            indicator.setIndeterminate(true);
        }
        this.myCyclicDependencies = this.getCycles(this.myPackages.values());
    }

    private void constractFilesInDependenciesPackagesMap(PsiPackage pack, PsiPackage depPackage, PsiFile file, Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> filesInDependentPackages) {
        Set<PsiFile> depFiles;
        Map<PsiPackage, Set<PsiFile>> dependentPackages2Files = filesInDependentPackages.get(pack);
        if (dependentPackages2Files == null) {
            dependentPackages2Files = new HashMap<PsiPackage, Set<PsiFile>>();
            filesInDependentPackages.put(pack, dependentPackages2Files);
        }
        if ((depFiles = dependentPackages2Files.get(depPackage)) == null) {
            depFiles = new HashSet<PsiFile>();
            dependentPackages2Files.put(depPackage, depFiles);
        }
        depFiles.add(file);
    }

    private void constractWholeDependenciesMap(PsiJavaFile psiJavaFile, PsiFile psiFile) {
        HashSet<PsiFile> wholeDependencies = (HashSet<PsiFile>)this.myForwardBuilder.getDependencies().get(psiJavaFile);
        if (wholeDependencies == null) {
            wholeDependencies = new HashSet<PsiFile>();
            this.myForwardBuilder.getDependencies().put(psiJavaFile, wholeDependencies);
        }
        wholeDependencies.add(psiFile);
    }

    public Set<PsiFile> getDependentFilesInPackage(PsiPackage pack, PsiPackage depPack) {
        Set<Object> psiFiles = new HashSet<PsiFile>();
        Map<PsiPackage, Set<PsiFile>> map2 = this.myFilesInDependentPackages.get(pack);
        if (map2 != null) {
            psiFiles = map2.get(depPack);
        }
        if (psiFiles == null) {
            psiFiles = new HashSet();
        }
        return psiFiles;
    }

    public Set<PsiFile> getDependentFilesInPackage(PsiPackage firstPack, PsiPackage middlePack, PsiPackage lastPack) {
        Map<PsiPackage, Set<PsiFile>> backwardMap;
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        Map<PsiPackage, Set<PsiFile>> forwardMap = this.myFilesInDependentPackages.get(firstPack);
        if (forwardMap != null && forwardMap.get(middlePack) != null) {
            result.addAll((Collection)forwardMap.get(middlePack));
        }
        if ((backwardMap = this.myBackwardFilesInDependentPackages.get(lastPack)) != null && backwardMap.get(middlePack) != null) {
            result.addAll((Collection<PsiFile>)backwardMap.get(middlePack));
        }
        return result;
    }

    public HashMap<PsiPackage, Set<List<PsiPackage>>> getCyclicDependencies() {
        return this.myCyclicDependencies;
    }

    public HashMap<PsiPackage, Set<List<PsiPackage>>> getCycles(Collection<? extends PsiPackage> packages) {
        if (this.myGraph == null) {
            this.myGraph = this.buildGraph();
        }
        HashMap<PsiPackage, Set<List<PsiPackage>>> result = new HashMap<PsiPackage, Set<List<PsiPackage>>>();
        for (PsiPackage psiPackage : packages) {
            Set paths2Pack = result.computeIfAbsent(psiPackage, __ -> new HashSet());
            paths2Pack.addAll(GraphAlgorithms.getInstance().findCycles(this.myGraph, (Object)psiPackage));
        }
        return result;
    }

    public Map<String, PsiPackage> getAllScopePackages() {
        if (this.myPackages.isEmpty()) {
            final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(@NotNull PsiFile file) {
                    if (file == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (file instanceof PsiJavaFile) {
                        PsiJavaFile psiJavaFile = (PsiJavaFile)file;
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(psiJavaFile.getPackageName());
                        if (aPackage != null) {
                            CyclicDependenciesBuilder.this.myPackages.put(aPackage.getQualifiedName(), aPackage);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cyclicDependencies/CyclicDependenciesBuilder$3", "visitFile"));
                }
            });
        }
        return this.myPackages;
    }

    private Graph<PsiPackage> buildGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<PsiPackage>(){

            @NotNull
            public Collection<PsiPackage> getNodes() {
                Collection<PsiPackage> collection = CyclicDependenciesBuilder.this.getAllScopePackages().values();
                if (collection == null) {
                    4.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @NotNull
            public Iterator<PsiPackage> getIn(PsiPackage psiPack) {
                Set psiPackages = (Set)CyclicDependenciesBuilder.this.myPackageDependencies.get(psiPack);
                if (psiPackages == null) {
                    Iterator<PsiPackage> iterator = Collections.emptyIterator();
                    if (iterator == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return iterator;
                }
                Iterator<PsiPackage> iterator = psiPackages.iterator();
                if (iterator == null) {
                    4.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/cyclicDependencies/CyclicDependenciesBuilder$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    @NotNull
    private Set<PsiPackage> getPackageHierarchy(@NotNull String packageName) {
        PsiPackage aPackage;
        if (packageName == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(7);
        }
        HashSet<PsiPackage> result = new HashSet<PsiPackage>();
        PsiPackage psiPackage = this.findPackage(packageName);
        if (psiPackage != null) {
            result.add(psiPackage);
        } else {
            HashSet<PsiPackage> hashSet = result;
            if (hashSet == null) {
                CyclicDependenciesBuilder.$$$reportNull$$$0(8);
            }
            return hashSet;
        }
        while (psiPackage.getParentPackage() != null && !psiPackage.getParentPackage().getQualifiedName().isEmpty() && (aPackage = this.findPackage(psiPackage.getParentPackage().getQualifiedName())) != null) {
            result.add(aPackage);
            psiPackage = psiPackage.getParentPackage();
        }
        HashSet<PsiPackage> hashSet = result;
        if (hashSet == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private PsiPackage findPackage(@NotNull String packName) {
        if (packName == null) {
            CyclicDependenciesBuilder.$$$reportNull$$$0(10);
        }
        return this.getAllScopePackages().get(packName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cyclicDependencies/CyclicDependenciesBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNodeNameInUsageView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cyclicDependencies/CyclicDependenciesBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNodeNameInUsageView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getForwardBuilder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRootNodeNameInUsageView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageHierarchy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

