/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ArrayAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl debugProcess;
        if (e == null) {
            ArrayAction.$$$reportNull$$$0(0);
        }
        if ((debugProcess = (debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) == null) {
            return;
        }
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode((DataContext)e.getDataContext());
        if (node == null) {
            return;
        }
        ArrayRenderer renderer = ArrayAction.getArrayRenderer((XValue)node.getValueContainer());
        if (renderer == null) {
            return;
        }
        this.createNewRenderer(node, renderer, debuggerContext, node.getName()).onSuccess(newRenderer -> ArrayAction.setArrayRenderer(newRenderer, node, debuggerContext));
    }

    @NotNull
    protected abstract Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl var1, ArrayRenderer var2, @NotNull DebuggerContextImpl var3, String var4);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ArrayAction.$$$reportNull$$$0(1);
        }
        boolean enable = false;
        List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
        if (values.size() == 1) {
            enable = ArrayAction.getArrayRenderer((XValue)values.get(0)) != null;
        }
        e.getPresentation().setEnabledAndVisible(enable);
    }

    @Nullable
    public static ArrayRenderer getArrayRenderer(XValue value2) {
        if (value2 instanceof JavaValue) {
            ChildrenRenderer childrenRenderer;
            ValueDescriptorImpl descriptor = ((JavaValue)value2).getDescriptor();
            Renderer lastRenderer = descriptor.getLastRenderer();
            if (lastRenderer instanceof CompoundReferenceRenderer && (childrenRenderer = ((CompoundReferenceRenderer)lastRenderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer && (lastRenderer = ExpressionChildrenRenderer.getLastChildrenRenderer(descriptor)) == null) {
                lastRenderer = ((ExpressionChildrenRenderer)childrenRenderer).getPredictedRenderer();
            }
            if (lastRenderer instanceof ArrayRenderer) {
                return (ArrayRenderer)lastRenderer;
            }
        }
        return null;
    }

    public static void setArrayRenderer(final ArrayRenderer newRenderer, final @NotNull XValueNodeImpl node, @NotNull DebuggerContextImpl debuggerContext) {
        XValue container;
        ArrayRenderer renderer;
        if (node == null) {
            ArrayAction.$$$reportNull$$$0(2);
        }
        if (debuggerContext == null) {
            ArrayAction.$$$reportNull$$$0(3);
        }
        if ((renderer = ArrayAction.getArrayRenderer(container = (XValue)node.getValueContainer())) == null) {
            return;
        }
        final ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess != null) {
            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    CompoundReferenceRenderer compoundRenderer;
                    ChildrenRenderer childrenRenderer;
                    Renderer lastRenderer;
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((lastRenderer = descriptor.getLastRenderer()) instanceof ArrayRenderer) {
                        ((JavaValue)container).setRenderer(newRenderer, node);
                        node.invokeNodeUpdate(() -> node.getTree().expandPath(node.getPath()));
                    } else if (lastRenderer instanceof CompoundReferenceRenderer && (childrenRenderer = (compoundRenderer = (CompoundReferenceRenderer)lastRenderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer) {
                        ExpressionChildrenRenderer.setPreferableChildrenRenderer(descriptor, newRenderer);
                        ((JavaValue)container).reBuild(node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ArrayAction$1", "contextAction"));
                }
            });
        }
    }

    private static String createNodeTitle(String prefix, DebuggerTreeNodeImpl node) {
        if (node != null) {
            DebuggerTreeNodeImpl parent = node.getParent();
            NodeDescriptorImpl descriptor = parent.getDescriptor();
            if (descriptor instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)descriptor).isArray()) {
                int index = parent.getIndex(node);
                return ArrayAction.createNodeTitle(prefix, parent) + "[" + index + "]";
            }
            String name2 = node.getDescriptor() != null ? node.getDescriptor().getName() : null;
            return name2 != null ? prefix + " " + name2 : prefix;
        }
        return prefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/ArrayAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setArrayRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FilterArrayAction
    extends ArrayAction {
        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                FilterArrayAction.$$$reportNull$$$0(0);
            }
            ArrayFilterInplaceEditor.editParent(node);
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                FilterArrayAction.$$$reportNull$$$0(1);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AdjustArrayRangeAction
    extends ArrayAction {
        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                AdjustArrayRangeAction.$$$reportNull$$$0(0);
            }
            ArrayRenderer clonedRenderer = original.clone();
            clonedRenderer.setForced(true);
            if (ShowSettingsUtil.getInstance().editConfigurable(debuggerContext.getProject(), (Configurable)new NamedArrayConfigurable(title, clonedRenderer))) {
                Promise promise = Promises.resolvedPromise((Object)clonedRenderer);
                if (promise == null) {
                    AdjustArrayRangeAction.$$$reportNull$$$0(1);
                }
                return promise;
            }
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AdjustArrayRangeAction.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String myTitle;

        NamedArrayConfigurable(String title, ArrayRenderer renderer) {
            super(renderer);
            this.myTitle = title;
        }

        public String getDisplayName() {
            return this.myTitle;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

