/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class JavaSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private static final Logger LOG = Logger.getInstance(JavaSmartStepIntoHandler.class);

    @Override
    public boolean isAvailable(SourcePosition position) {
        PsiFile file = position.getFile();
        return file.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(final SourcePosition position, DebuggerSession session, final boolean smart) {
        final AsyncPromise res = new AsyncPromise();
        session.getProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(session.getContextManager().getContext()){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                res.setResult((Object)((List)ReadAction.compute(() -> JavaSmartStepIntoHandler.this.findStepTargets(position, suspendContext, this.getDebuggerContext(), smart))));
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JavaSmartStepIntoHandler$1", "threadAction"));
            }
        });
        AsyncPromise asyncPromise = res;
        if (asyncPromise == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public Promise<List<SmartStepTarget>> findSmartStepTargetsAsync(SourcePosition position, DebuggerSession session) {
        return this.findSmartStepTargetsAsync(position, session, true);
    }

    @Override
    @NotNull
    public Promise<List<SmartStepTarget>> findStepIntoTargets(SourcePosition position, DebuggerSession session) {
        if (DebuggerSettings.getInstance().ALWAYS_SMART_STEP_INTO) {
            return this.findSmartStepTargetsAsync(position, session, false);
        }
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return promise;
    }

    @Override
    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        throw new IllegalStateException("Should not be used");
    }

    protected List<SmartStepTarget> findStepTargets(final SourcePosition position, @Nullable SuspendContextImpl suspendContext, final @NotNull DebuggerContextImpl debuggerContext, boolean smart) {
        TextRange lineRange;
        int line;
        if (debuggerContext == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        if ((line = position.getLine()) < 0) {
            return Collections.emptyList();
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return Collections.emptyList();
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            return Collections.emptyList();
        }
        if (line >= doc.getLineCount()) {
            return Collections.emptyList();
        }
        TextRange curLineRange = DocumentUtil.getLineTextRange((Document)doc, (int)line);
        PsiElement element = position.getElementAt();
        PsiElement body2 = DebuggerUtilsEx.getBody(DebuggerUtilsEx.getContainingMethod(element));
        TextRange textRange = lineRange = body2 != null ? curLineRange.intersection(body2.getTextRange()) : curLineRange;
        if (lineRange == null || lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            final ArrayList<SmartStepTarget> targets = new ArrayList<SmartStepTarget>();
            final Ref textRange2 = new Ref((Object)lineRange);
            JavaRecursiveElementVisitor methodCollector = new JavaRecursiveElementVisitor(){
                final Deque<PsiMethod> myContextStack = new LinkedList<PsiMethod>();
                final Deque<String> myParamNameStack = new LinkedList<String>();
                private int myNextLambdaExpressionOrdinal = 0;
                private boolean myInsideLambda = false;

                @Nullable
                private String getCurrentParamName() {
                    return this.myParamNameStack.peekFirst();
                }

                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                    PsiExpressionList argumentList = aClass.getArgumentList();
                    if (argumentList != null) {
                        argumentList.accept((PsiElementVisitor)this);
                    }
                    for (PsiMethod psiMethod : aClass.getMethods()) {
                        targets.add(0, new MethodSmartStepTarget(psiMethod, this.getCurrentParamName(), (PsiElement)psiMethod.getBody(), true, null));
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                    boolean inLambda = this.myInsideLambda;
                    this.myInsideLambda = true;
                    super.visitLambdaExpression(expression2);
                    this.myInsideLambda = inLambda;
                    targets.add(0, new LambdaSmartStepTarget(expression2, this.getCurrentParamName(), expression2.getBody(), this.myNextLambdaExpressionOrdinal++, null, !this.myInsideLambda));
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                    PsiElement navMethod;
                    PsiElement element = expression2.resolve();
                    if (element instanceof PsiMethod && (navMethod = element.getNavigationElement()) instanceof PsiMethod) {
                        targets.add(0, new MethodSmartStepTarget((PsiMethod)navMethod, null, (PsiElement)expression2, true, null));
                    }
                }

                public void visitField(PsiField field) {
                    if (this.checkTextRange((PsiElement)field, false)) {
                        super.visitField(field);
                    }
                }

                public void visitMethod(PsiMethod method) {
                    if (this.checkTextRange((PsiElement)method, false)) {
                        super.visitMethod(method);
                    }
                }

                public void visitStatement(PsiStatement statement) {
                    if (this.checkTextRange((PsiElement)statement, true)) {
                        super.visitStatement(statement);
                    }
                }

                public void visitIfStatement(PsiIfStatement statement) {
                    this.visitConditional((PsiElement)statement.getCondition(), (PsiElement)statement.getThenBranch(), (PsiElement)statement.getElseBranch());
                }

                public void visitConditionalExpression(PsiConditionalExpression expression2) {
                    this.visitConditional((PsiElement)expression2.getCondition(), (PsiElement)expression2.getThenExpression(), (PsiElement)expression2.getElseExpression());
                }

                private void visitConditional(@Nullable PsiElement condition2, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
                    ThreeState conditionRes;
                    if (condition2 != null && this.checkTextRange(condition2, true)) {
                        condition2.accept((PsiElementVisitor)this);
                    }
                    if ((conditionRes = this.evaluateCondition(condition2)) != ThreeState.NO && thenBranch != null && this.checkTextRange(thenBranch, true)) {
                        thenBranch.accept((PsiElementVisitor)this);
                    }
                    if (conditionRes != ThreeState.YES && elseBranch != null && this.checkTextRange(elseBranch, true)) {
                        elseBranch.accept((PsiElementVisitor)this);
                    }
                }

                private ThreeState evaluateCondition(@Nullable PsiElement condition2) {
                    if (condition2 != null && !DebuggerUtils.hasSideEffects((PsiElement)condition2)) {
                        try {
                            ExpressionEvaluator evaluator = EvaluatorBuilderImpl.getInstance().build(condition2, position);
                            return ThreeState.fromBoolean((boolean)DebuggerUtilsEx.evaluateBoolean(evaluator, debuggerContext.createEvaluationContext()));
                        }
                        catch (EvaluateException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return ThreeState.UNSURE;
                }

                public void visitExpression(PsiExpression expression2) {
                    this.checkTextRange((PsiElement)expression2, true);
                    super.visitExpression(expression2);
                }

                boolean checkTextRange(@NotNull PsiElement expression2, boolean expand) {
                    TextRange range;
                    if (expression2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (lineRange.intersects(range = expression2.getTextRange())) {
                        if (expand) {
                            textRange2.set((Object)((TextRange)textRange2.get()).union(range));
                        }
                        return true;
                    }
                    return false;
                }

                public void visitExpressionList(PsiExpressionList expressionList) {
                    this.visitArguments(expressionList, this.myContextStack.peekFirst());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void visitArguments(PsiExpressionList expressionList, PsiMethod psiMethod) {
                    if (psiMethod != null) {
                        String methodName = psiMethod.getName();
                        PsiExpression[] expressions2 = expressionList.getExpressions();
                        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                        for (int idx = 0; idx < expressions2.length; ++idx) {
                            String paramName = idx < parameters2.length && !parameters2[idx].isVarArgs() ? parameters2[idx].getName() : "arg" + (idx + 1);
                            this.myParamNameStack.push(methodName + ": " + paramName + ".");
                            PsiExpression argExpression = expressions2[idx];
                            try {
                                argExpression.accept((PsiElementVisitor)this);
                                continue;
                            }
                            finally {
                                this.myParamNameStack.pop();
                            }
                        }
                    } else {
                        super.visitExpressionList(expressionList);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitCallExpression(PsiCallExpression expression2) {
                    int pos = -1;
                    if (this.myContextStack.isEmpty()) {
                        pos = targets.size();
                    }
                    PsiMethod psiMethod = expression2.resolveMethod();
                    boolean isMethodCall = expression2 instanceof PsiMethodCallExpression;
                    if (isMethodCall) {
                        PsiExpression qualifier = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression();
                        if (qualifier != null) {
                            qualifier.accept((PsiElementVisitor)this);
                        }
                        this.visitArguments(expression2.getArgumentList(), psiMethod);
                    }
                    if (psiMethod != null) {
                        this.myContextStack.push(psiMethod);
                        MethodSmartStepTarget target = new MethodSmartStepTarget(psiMethod, null, (PsiElement)(isMethodCall ? ((PsiMethodCallExpression)expression2).getMethodExpression().getReferenceNameElement() : (expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getClassOrAnonymousClassReference() : expression2)), this.myInsideLambda || expression2 instanceof PsiNewExpression && ((PsiNewExpression)expression2).getAnonymousClass() != null, null);
                        target.setOrdinal((int)JavaSmartStepIntoHandler.existingMethodCalls(targets, psiMethod).count());
                        if (pos != -1) {
                            targets.add(pos, target);
                        } else {
                            targets.add(target);
                        }
                    }
                    try {
                        if (isMethodCall) {
                            this.checkTextRange((PsiElement)expression2, true);
                        } else {
                            super.visitCallExpression(expression2);
                        }
                    }
                    finally {
                        if (psiMethod != null) {
                            this.myContextStack.pop();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/actions/JavaSmartStepIntoHandler$2", "checkTextRange"));
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            Range sourceLines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getEndOffset())));
            targets.forEach(t -> t.setCallingExpressionLines((Range<Integer>)sourceLines));
            HashSet<Integer> lines = new HashSet();
            IntStream.rangeClosed((Integer)sourceLines.getFrom(), (Integer)sourceLines.getTo()).forEach(lines::add);
            LineNumbersMapping mapping = (LineNumbersMapping)vFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
            if (mapping != null) {
                lines = ((StreamEx)StreamEx.of(lines).map(l -> mapping.sourceToBytecode(l + 1) - 1).filter(l -> l >= 0)).toSet();
            }
            if (!targets.isEmpty()) {
                StackFrameProxyImpl frameProxy;
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext != null ? suspendContext.getFrameProxy() : null;
                if (frameProxy != null) {
                    VirtualMachineProxyImpl virtualMachine = frameProxy.getVirtualMachine();
                    if (!virtualMachine.canGetConstantPool() || !virtualMachine.canGetBytecodes()) {
                        return smart ? targets : Collections.emptyList();
                    }
                    DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
                    try {
                        List methodTargets = JavaSmartStepIntoHandler.immediateMethodCalls(targets).toList();
                        JavaSmartStepIntoHandler.visitLinesInstructions(frameProxy.location(), true, lines, (opcode, owner2, name2, desc, itf, ordinal) -> JavaSmartStepIntoHandler.removeMatchingMethod(methodTargets, owner2, name2, desc, ordinal, debugProcess));
                        if (!methodTargets.isEmpty()) {
                            LOG.debug("Sanity check failed for: " + methodTargets);
                            return Collections.emptyList();
                        }
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                        return smart ? targets : Collections.emptyList();
                    }
                    try {
                        ArrayList<SmartStepTarget> all = new ArrayList<SmartStepTarget>(targets);
                        JumpsAndInsnVisitor visitor2 = new JumpsAndInsnVisitor(targets, debugProcess);
                        JavaSmartStepIntoHandler.visitLinesInstructions(frameProxy.location(), false, lines, visitor2);
                        if (!smart && !targets.isEmpty()) {
                            ArrayList<SmartStepTarget> copy = new ArrayList<SmartStepTarget>(targets);
                            visitor2.setJumpsToIgnore(visitor2.getJumpCounter() + 1);
                            JavaSmartStepIntoHandler.visitLinesInstructions(frameProxy.location(), true, lines, visitor2);
                            if (!targets.isEmpty() && !JavaSmartStepIntoHandler.immediateMethodCalls(targets).findAny().isPresent()) {
                                targets.clear();
                                targets.addAll(copy);
                            }
                        }
                        ArrayList<SmartStepTarget> removed = new ArrayList<SmartStepTarget>(all);
                        removed.removeAll(targets);
                        for (SmartStepTarget m : removed) {
                            MethodSmartStepTarget target = (MethodSmartStepTarget)m;
                            JavaSmartStepIntoHandler.existingMethodCalls(all, target.getMethod()).forEach(t -> {
                                int ordinal = t.getOrdinal();
                                if (ordinal > target.getOrdinal()) {
                                    t.setOrdinal(ordinal - 1);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                        return Collections.emptyList();
                    }
                }
                return targets;
            }
        }
        return Collections.emptyList();
    }

    private static void removeMatchingMethod(List<MethodSmartStepTarget> targets, String owner2, String name2, String desc, int ordinal, DebugProcessImpl process2) {
        Iterator<MethodSmartStepTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            MethodSmartStepTarget target = iterator.next();
            if (!DebuggerUtilsEx.methodMatches(target.getMethod(), owner2.replace("/", "."), name2, desc, process2) || target.getOrdinal() != ordinal) continue;
            iterator.remove();
            break;
        }
    }

    private static void visitLinesInstructions(final Location location, boolean full, final Set<Integer> lines, final MethodInsnVisitor visitor2) {
        final TObjectIntHashMap myCounter = new TObjectIntHashMap();
        MethodBytecodeUtil.visit(location.method(), full ? Long.MAX_VALUE : location.codeIndex(), new MethodVisitor(524288){
            boolean myLineMatch;
            {
                super(arg0);
                this.myLineMatch = false;
            }

            public void visitJumpInsn(int opcode, Label label) {
                if (this.myLineMatch) {
                    visitor2.visitJumpInsn(opcode, label);
                }
            }

            public void visitCode() {
                visitor2.visitCode();
            }

            public void visitLineNumber(int line, Label start) {
                this.myLineMatch = lines.contains(line - 1);
            }

            public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                if (this.myLineMatch) {
                    String key2 = owner2 + "." + name2 + desc;
                    final int currentCount = myCounter.get((Object)key2);
                    myCounter.put((Object)key2, currentCount + 1);
                    if (name2.startsWith("access$")) {
                        Method method;
                        ReferenceType cls = (ReferenceType)ContainerUtil.getFirstItem(location.virtualMachine().classesByName(owner2));
                        if (cls != null && (method = DebuggerUtils.findMethod((ReferenceType)cls, (String)name2, (String)desc)) != null) {
                            MethodBytecodeUtil.visit(method, new MethodVisitor(524288){

                                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                                    if ("java/lang/AbstractMethodError".equals(owner2)) {
                                        return;
                                    }
                                    visitor2.visitMethodInsn(opcode, owner2, name2, desc, itf, currentCount);
                                }
                            }, false);
                        }
                    } else {
                        visitor2.visitMethodInsn(opcode, owner2, name2, desc, itf, currentCount);
                    }
                }
            }
        }, true);
    }

    private static StreamEx<MethodSmartStepTarget> immediateMethodCalls(List<SmartStepTarget> targets) {
        return (StreamEx)StreamEx.of(targets).select(MethodSmartStepTarget.class).filter(target -> !target.needsBreakpointRequest());
    }

    private static StreamEx<MethodSmartStepTarget> existingMethodCalls(List<SmartStepTarget> targets, PsiMethod psiMethod) {
        return (StreamEx)JavaSmartStepIntoHandler.immediateMethodCalls(targets).filter(t -> t.getMethod().equals(psiMethod));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmartStepTargetsAsync";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepIntoTargets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findStepTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JumpsAndInsnVisitor
    implements MethodInsnVisitor {
        private final List<SmartStepTarget> myTargets;
        private final DebugProcessImpl myDebugProcess;
        private int myJumpCounter;
        private int myJumpsToIgnore;

        JumpsAndInsnVisitor(List<SmartStepTarget> targets, DebugProcessImpl debugProcess) {
            this.myTargets = targets;
            this.myDebugProcess = debugProcess;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf, int ordinal) {
            if (this.myJumpCounter >= this.myJumpsToIgnore) {
                Iterator<SmartStepTarget> iterator = this.myTargets.iterator();
                while (iterator.hasNext()) {
                    SmartStepTarget e = iterator.next();
                    if (!(e instanceof MethodSmartStepTarget) || !DebuggerUtilsEx.methodMatches(((MethodSmartStepTarget)e).getMethod(), owner2.replace("/", "."), name2, desc, this.myDebugProcess) || ((MethodSmartStepTarget)e).getOrdinal() != ordinal) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        @Override
        public void visitCode() {
            this.myJumpCounter = 0;
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            ++this.myJumpCounter;
        }

        int getJumpCounter() {
            return this.myJumpCounter;
        }

        void setJumpsToIgnore(int jumpsToIgnore) {
            this.myJumpsToIgnore = jumpsToIgnore;
        }
    }

    private static interface MethodInsnVisitor {
        public void visitMethodInsn(int var1, String var2, String var3, String var4, boolean var5, int var6);

        default public void visitJumpInsn(int opcode, Label label) {
        }

        default public void visitCode() {
        }
    }
}

