/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStaticGroup
extends XValueGroup
implements NodeDescriptorProvider {
    private final StaticDescriptorImpl myStaticDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;

    public JavaStaticGroup(StaticDescriptorImpl staticDescriptor, EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        super(staticDescriptor.getName());
        this.myStaticDescriptor = staticDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
    }

    @Nullable
    public String getComment() {
        String res = NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myStaticDescriptor.getType().name());
        if (!StringUtil.isEmpty((String)res)) {
            return " members of " + res;
        }
        return res;
    }

    @NotNull
    public String getSeparator() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return this.myStaticDescriptor;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaStaticGroup.$$$reportNull$$$0(0);
        }
        JavaValue.scheduleCommand(this.myEvaluationContext, node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ReferenceType refType = JavaStaticGroup.this.myStaticDescriptor.getType();
                DebuggerUtilsAsync.allFields(refType).thenAccept(fields -> {
                    boolean showSynthetics = NodeRendererSettings.getInstance().getClassRenderer().SHOW_SYNTHETICS;
                    List fieldsToShow = ContainerUtil.filter((Collection)fields, f -> f.isStatic() && (showSynthetics || !DebuggerUtils.isSynthetic((TypeComponent)f)));
                    List chunks = DebuggerUtilsImpl.partition(fieldsToShow, 100);
                    CompletableFuture[] futures = (CompletableFuture[])chunks.stream().map(l -> this.createNodes((List<Field>)l, refType, suspendContext)).toArray(CompletableFuture[]::new);
                    CompletableFuture.allOf(futures).thenAccept(__ -> {
                        StreamEx.of((Object[])futures).map(CompletableFuture::join).forEach(c -> node.addChildren(c, false));
                        node.addChildren(XValueChildrenList.EMPTY, true);
                    });
                });
            }

            private CompletableFuture<XValueChildrenList> createNodes(List<Field> fields, ReferenceType refType, SuspendContext context) {
                return DebuggerUtilsAsync.getValues(refType, fields).thenApply(cachedValues -> {
                    XValueChildrenList children = new XValueChildrenList();
                    for (Field field : fields) {
                        FieldDescriptorImpl fieldDescriptor = JavaStaticGroup.this.myNodeManager.getFieldDescriptor(JavaStaticGroup.this.myStaticDescriptor, null, field);
                        if (cachedValues != null) {
                            fieldDescriptor.setValue((Value)cachedValues.get(field));
                        }
                        children.add((XNamedValue)JavaValue.create(fieldDescriptor, JavaStaticGroup.this.myEvaluationContext, JavaStaticGroup.this.myNodeManager));
                    }
                    return children;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStaticGroup$1", "contextAction"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStaticGroup", "computeChildren"));
    }
}

