/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestHint {
    public static final int STOP = 0;
    public static final int RESUME = -100;
    private static final Logger LOG = Logger.getInstance(RequestHint.class);
    private final int mySize;
    private final int myDepth;
    private final SourcePosition myPosition;
    private final int myFrameCount;
    private boolean mySteppedOut;
    @Nullable
    private final MethodFilter myMethodFilter;
    private int myFilterMatchedCount;
    private boolean myTargetMethodMatched;
    private boolean myIgnoreFilters;
    private boolean myResetIgnoreFilters;
    private boolean myRestoreBreakpoints;

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, @NotNull MethodFilter methodFilter) {
        if (methodFilter == null) {
            RequestHint.$$$reportNull$$$0(0);
        }
        this(stepThread, suspendContext, -2, 1, methodFilter);
    }

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, int depth) {
        this(stepThread, suspendContext, -2, depth, null);
    }

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, int stepSize, int depth, @Nullable MethodFilter methodFilter) {
        this.mySteppedOut = false;
        this.myFilterMatchedCount = 0;
        this.myTargetMethodMatched = false;
        this.myIgnoreFilters = false;
        this.myResetIgnoreFilters = false;
        this.myRestoreBreakpoints = false;
        this.mySize = stepSize;
        this.myDepth = depth;
        this.myMethodFilter = methodFilter;
        this.myFrameCount = DebugProcessImpl.getFrameCount(stepThread, suspendContext);
        this.myPosition = suspendContext.getDebugProcess().getPositionManager().getSourcePosition(DebugProcessImpl.getLocation(stepThread, suspendContext));
    }

    public void setIgnoreFilters(boolean ignoreFilters) {
        this.myIgnoreFilters = ignoreFilters;
    }

    public void setResetIgnoreFilters(boolean resetIgnoreFilters) {
        this.myResetIgnoreFilters = resetIgnoreFilters;
    }

    public boolean isResetIgnoreFilters() {
        return this.myResetIgnoreFilters;
    }

    public void setRestoreBreakpoints(boolean restoreBreakpoints) {
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    public boolean isIgnoreFilters() {
        return this.myIgnoreFilters;
    }

    public int getSize() {
        return this.mySize;
    }

    public int getDepth() {
        return this.myDepth;
    }

    @Nullable
    public MethodFilter getMethodFilter() {
        return this.myMethodFilter;
    }

    public boolean wasStepTargetMethodMatched() {
        return this.myMethodFilter instanceof BreakpointStepMethodFilter || this.myTargetMethodMatched;
    }

    protected boolean isTheSameFrame(SuspendContextImpl context) {
        if (this.mySteppedOut) {
            return false;
        }
        ThreadReferenceProxyImpl contextThread = context.getThread();
        if (contextThread != null) {
            try {
                int currentDepth = contextThread.frameCount();
                if (currentDepth < this.myFrameCount) {
                    this.mySteppedOut = true;
                }
                return currentDepth == this.myFrameCount;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isOnTheSameLine(SourcePosition locationPosition) {
        if (this.myMethodFilter == null) {
            return this.myPosition.getLine() == locationPosition.getLine();
        }
        Range<Integer> exprLines = this.myMethodFilter.getCallingExpressionLines();
        return exprLines != null && exprLines.isWithin((Comparable)Integer.valueOf(locationPosition.getLine()));
    }

    protected boolean isSteppedOut() {
        return this.mySteppedOut;
    }

    public Integer checkCurrentPosition(SuspendContextImpl context, Location location) {
        SourcePosition locationPosition;
        if ((this.myDepth == 2 || this.myDepth == 1) && this.myPosition != null && (locationPosition = context.getDebugProcess().getPositionManager().getSourcePosition(location)) != null) {
            return (Integer)ReadAction.compute(() -> {
                if (this.myPosition.getFile().equals(locationPosition.getFile()) && this.isTheSameFrame(context) && !this.mySteppedOut) {
                    return this.isOnTheSameLine(locationPosition) ? this.myDepth : 0;
                }
                return null;
            });
        }
        return null;
    }

    static boolean isProxyMethod(Method method) {
        return method.isBridge() || DebuggerUtilsEx.isProxyClass(method.declaringType());
    }

    public int getNextStepDepth(SuspendContextImpl context) {
        try {
            Integer resultDepth;
            Location location = context.getLocation();
            if (this.myMethodFilter != null && location != null && !(this.myMethodFilter instanceof BreakpointStepMethodFilter) && !this.isTheSameFrame(context)) {
                boolean proxyMatch;
                if (RequestHint.isProxyMethod(location.method())) {
                    return 1;
                }
                boolean bl = proxyMatch = this.myMethodFilter instanceof BasicStepMethodFilter && ((BasicStepMethodFilter)this.myMethodFilter).proxyCheck(location, context, this);
                if ((proxyMatch || this.myMethodFilter.locationMatches(context.getDebugProcess(), location, context.getFrameProxy())) && this.myMethodFilter.getSkipCount() <= this.myFilterMatchedCount++) {
                    this.myTargetMethodMatched = true;
                    return this.myMethodFilter.onReached(context, this);
                }
            }
            if ((resultDepth = this.checkCurrentPosition(context, location)) != null) {
                return resultDepth;
            }
            DebuggerSettings settings = DebuggerSettings.getInstance();
            if ((this.myMethodFilter != null || settings.SKIP_SYNTHETIC_METHODS && !this.myIgnoreFilters) && location != null && DebuggerUtils.isSynthetic((TypeComponent)location.method())) {
                return this.myDepth;
            }
            if (!this.myIgnoreFilters) {
                boolean isGetter;
                if (settings.SKIP_GETTERS && (isGetter = ((Boolean)ReadAction.compute(() -> {
                    PsiElement contextElement = ContextUtil.getContextElement((StackFrameContext)context);
                    return contextElement != null && DebuggerUtils.isInsideSimpleGetter((PsiElement)contextElement);
                })).booleanValue())) {
                    return 3;
                }
                if (location != null) {
                    Method method;
                    if (settings.SKIP_CONSTRUCTORS && (method = location.method()) != null && method.isConstructor()) {
                        return 3;
                    }
                    if (settings.SKIP_CLASSLOADERS && DebuggerUtilsEx.isAssignableFrom("java.lang.ClassLoader", location.declaringType())) {
                        return 3;
                    }
                }
                for (ExtraSteppingFilter filter : ExtraSteppingFilter.EP_NAME.getExtensionList()) {
                    try {
                        if (!filter.isApplicable(context)) continue;
                        return filter.getStepRequestDepth(context);
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            if (this.myMethodFilter != null) {
                this.isTheSameFrame(context);
                if (!this.mySteppedOut) {
                    return 3;
                }
            }
        }
        catch (VMDisconnectedException location) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFilter", "com/intellij/debugger/engine/RequestHint", "<init>"));
    }
}

