/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.CaptureTraverser;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebuggerDfaRunner
extends DataFlowRunner {
    private static final Value NullConst = new Value(){

        @Override
        public VirtualMachine virtualMachine() {
            return null;
        }

        @Override
        public Type type() {
            return null;
        }

        @Override
        public String toString() {
            return "null";
        }
    };
    private static final Set<String> COLLECTIONS_WITH_SIZE_FIELD = ContainerUtil.immutableSet((Object[])new String[]{"java.util.ArrayList", "java.util.LinkedList", "java.util.HashMap", "java.util.TreeMap"});
    @NotNull
    private final PsiElement myBody;
    @NotNull
    private final PsiElement myAnchor;
    @NotNull
    private final Project myProject;
    @Nullable
    private final ControlFlow myFlow;
    @Nullable
    private final DfaInstructionState myStartingState;
    private final long myModificationStamp;

    DebuggerDfaRunner(@NotNull PsiElement body2, @NotNull PsiElement anchor, @NotNull StackFrameProxyEx proxy) throws EvaluateException {
        if (body2 == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(1);
        }
        if (proxy == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(2);
        }
        super(body2.getProject(), (PsiElement)(body2.getParent() instanceof PsiClassInitializer ? ((PsiClassInitializer)body2.getParent()).getContainingClass() : body2));
        this.myBody = body2;
        this.myAnchor = anchor;
        this.myProject = body2.getProject();
        this.myFlow = this.buildFlow(this.myBody);
        this.myStartingState = this.getStartingState(proxy);
        this.myModificationStamp = PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount();
    }

    boolean isValid() {
        return this.myStartingState != null;
    }

    RunnerResult interpret(InstructionVisitor visitor2) {
        if (this.myFlow == null || this.myStartingState == null || PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount() != this.myModificationStamp) {
            return RunnerResult.ABORTED;
        }
        return this.interpret(this.myBody, visitor2, this.myFlow, Collections.singletonList(this.myStartingState));
    }

    @Nullable
    private DfaInstructionState getStartingState(@NotNull StackFrameProxyEx proxy) throws EvaluateException {
        if (proxy == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(3);
        }
        if (this.myFlow == null) {
            return null;
        }
        int offset = this.myFlow.getStartOffset(this.myAnchor).getInstructionOffset();
        if (offset < 0) {
            return null;
        }
        DfaMemoryState state = super.createMemoryState();
        StateBuilder builder = new StateBuilder(proxy, state);
        for (DfaValue dfaValue : this.getFactory().getValues().toArray(new DfaValue[0])) {
            if (!(dfaValue instanceof DfaVariableValue)) continue;
            DfaVariableValue var = (DfaVariableValue)dfaValue;
            builder.resolveJdi(var);
        }
        builder.finish();
        if (builder.myChanged) {
            return new DfaInstructionState(this.myFlow.getInstruction(offset), state);
        }
        return null;
    }

    @Override
    @NotNull
    protected DataFlowRunner.TimeStats createStatistics() {
        return new DataFlowRunner.TimeStats(false);
    }

    private static Value wrap(Value value2) {
        return value2 == null ? NullConst : value2;
    }

    private static String getEnumConstantName(ObjectReference ref) {
        ReferenceType type2 = ref.referenceType();
        if (!(type2 instanceof ClassType) || !((ClassType)type2).isEnum()) {
            return null;
        }
        ClassType superclass = ((ClassType)type2).superclass();
        if (superclass == null) {
            return null;
        }
        if (!superclass.name().equals("java.lang.Enum")) {
            superclass = superclass.superclass();
        }
        if (superclass == null || !superclass.name().equals("java.lang.Enum")) {
            return null;
        }
        Field nameField = superclass.fieldByName("name");
        if (nameField == null) {
            return null;
        }
        Value nameValue = ref.getValue(nameField);
        return nameValue instanceof StringReference ? ((StringReference)nameValue).value() : null;
    }

    @Nullable
    private static PsiType getType(@NotNull Type type2, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        PsiClass aClass;
        if (type2 == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(6);
        }
        if (type2 instanceof PrimitiveType) {
            String name2 = type2.name();
            return PsiJavaParserFacadeImpl.getPrimitiveType(name2);
        }
        if (type2 instanceof ArrayType) {
            try {
                PsiType componentPsiType = DebuggerDfaRunner.getType(((ArrayType)type2).componentType(), project, scope);
                return componentPsiType == null ? null : componentPsiType.createArrayType();
            }
            catch (ClassNotLoadedException e) {
                return null;
            }
        }
        if (type2 instanceof ReferenceType && (aClass = DebuggerUtils.findClass((String)type2.name(), (Project)project, (GlobalSearchScope)scope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)project).createType(aClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartingState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StateBuilder {
        @NotNull
        private final PsiElementFactory myPsiFactory;
        @NotNull
        private final DfaValueFactory myFactory;
        @Nullable
        private final ClassLoaderReference myContextLoader;
        @NotNull
        private final DfaMemoryState myMemState;
        @NotNull
        private final Map<Value, DfaVariableValue> myCanonicalMap;
        @NotNull
        private final StackFrameProxyEx myProxy;
        @NotNull
        private final Location myLocation;
        @Nullable
        private List<ClassLoaderReference> myParentLoaders;
        private boolean myChanged;

        StateBuilder(@NotNull StackFrameProxyEx proxy, DfaMemoryState memState) throws EvaluateException {
            if (proxy == null) {
                StateBuilder.$$$reportNull$$$0(0);
            }
            if (memState == null) {
                StateBuilder.$$$reportNull$$$0(1);
            }
            this.myPsiFactory = JavaPsiFacade.getElementFactory((Project)DebuggerDfaRunner.this.myProject);
            this.myFactory = DebuggerDfaRunner.this.getFactory();
            this.myCanonicalMap = new HashMap<Value, DfaVariableValue>();
            this.myParentLoaders = null;
            this.myProxy = proxy;
            this.myLocation = proxy.location();
            this.myContextLoader = proxy.getClassLoader();
            this.myMemState = memState;
        }

        void resolveJdi(@NotNull DfaVariableValue var) throws EvaluateException {
            Value jdiValue;
            if (var == null) {
                StateBuilder.$$$reportNull$$$0(2);
            }
            if ((jdiValue = this.findJdiValue(var)) != null) {
                this.add(var, jdiValue);
            }
        }

        @Nullable
        private Value findJdiValue(@NotNull DfaVariableValue var) throws EvaluateException {
            Field field;
            ReferenceType type2;
            String name2;
            PsiClass psiClass;
            if (var == null) {
                StateBuilder.$$$reportNull$$$0(3);
            }
            if (var.getQualifier() != null) {
                VariableDescriptor descriptor = var.getDescriptor();
                if (descriptor instanceof SpecialField) {
                    return null;
                }
                Value qualifierValue = this.findJdiValue(var.getQualifier());
                if (qualifierValue == null) {
                    return null;
                }
                PsiModifierListOwner element = descriptor.getPsiElement();
                if (element instanceof PsiField && qualifierValue instanceof ObjectReference) {
                    Field field2;
                    ReferenceType type3 = ((ObjectReference)qualifierValue).referenceType();
                    PsiClass psiClass2 = ((PsiField)element).getContainingClass();
                    if (psiClass2 != null && type3.name().equals(JVMNameUtil.getClassVMName(psiClass2)) && (field2 = type3.fieldByName(((PsiField)element).getName())) != null) {
                        return DebuggerDfaRunner.wrap(((ObjectReference)qualifierValue).getValue(field2));
                    }
                }
                if (descriptor instanceof DfaExpressionFactory.ArrayElementDescriptor && qualifierValue instanceof ArrayReference) {
                    int index = ((DfaExpressionFactory.ArrayElementDescriptor)descriptor).getIndex();
                    int length = ((ArrayReference)qualifierValue).length();
                    if (index >= 0 && index < length) {
                        return DebuggerDfaRunner.wrap(((ArrayReference)qualifierValue).getValue(index));
                    }
                }
                return null;
            }
            if (var.getDescriptor() instanceof DfaExpressionFactory.AssertionDisabledDescriptor) {
                ThreeState status = DebuggerUtilsEx.getEffectiveAssertionStatus(this.myLocation);
                return this.myLocation.virtualMachine().mirrorOf(status == ThreeState.NO);
            }
            PsiModifierListOwner psi = var.getPsiVariable();
            if (psi instanceof PsiClass) {
                PsiClass currentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)DebuggerDfaRunner.this.myBody, PsiClass.class);
                return CaptureTraverser.create((PsiClass)psi, currentClass, true).traverse(this.myProxy.thisObject());
            }
            if (psi instanceof PsiLocalVariable || psi instanceof PsiParameter) {
                Field field3;
                ReferenceType type4;
                String varName = ((PsiVariable)psi).getName();
                if (varName == null || PsiResolveHelper.SERVICE.getInstance((Project)DebuggerDfaRunner.this.myProject).resolveReferencedVariable(varName, DebuggerDfaRunner.this.myAnchor) != psi) {
                    return null;
                }
                LocalVariableProxy variable = this.myProxy.visibleVariableByName(varName);
                if (variable != null) {
                    return DebuggerDfaRunner.wrap(this.myProxy.getVariableValue(variable));
                }
                PsiClass currentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)DebuggerDfaRunner.this.myBody, PsiClass.class);
                PsiClass varClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psi, PsiClass.class);
                ObjectReference thisRef = CaptureTraverser.create(varClass, currentClass, false).oneLevelLess().traverse(this.myProxy.thisObject());
                if (thisRef != null && (type4 = thisRef.referenceType()) instanceof ClassType && type4.isPrepared() && (field3 = type4.fieldByName("val$" + varName)) != null) {
                    return DebuggerDfaRunner.wrap(thisRef.getValue(field3));
                }
            }
            if (psi instanceof PsiField && psi.hasModifierProperty("static") && (psiClass = ((PsiField)psi).getContainingClass()) != null && (name2 = psiClass.getQualifiedName()) != null && (type2 = (ReferenceType)ContainerUtil.getOnlyItem((Collection)this.myProxy.getVirtualMachine().classesByName(name2))) != null && type2.isPrepared() && (field = type2.fieldByName(((PsiField)psi).getName())) != null && field.isStatic()) {
                return DebuggerDfaRunner.wrap(type2.getValue(field));
            }
            return null;
        }

        void add(@NotNull DfaVariableValue var, @NotNull Value jdiValue) {
            DfaVariableValue canonicalVar;
            if (var == null) {
                StateBuilder.$$$reportNull$$$0(4);
            }
            if (jdiValue == null) {
                StateBuilder.$$$reportNull$$$0(5);
            }
            DfaVariableValue dfaVariableValue = canonicalVar = jdiValue instanceof ObjectReference ? this.myCanonicalMap.putIfAbsent(jdiValue, var) : null;
            if (canonicalVar != null) {
                this.myMemState.applyCondition(var.eq(canonicalVar));
            } else {
                this.addConditions(var, jdiValue);
            }
            this.myChanged = true;
        }

        void finish() {
            if (this.myChanged) {
                Object[] distinctValues = (DfaVariableValue[])((StreamEx)StreamEx.ofValues(this.myCanonicalMap).filter(v -> v.getType() != null && !TypeConstraints.exact(v.getType()).isComparedByEquals())).toArray((Object[])new DfaVariableValue[0]);
                ((EntryStream)EntryStream.ofPairs((Object[])distinctValues).filterKeyValue((left, right) -> Objects.requireNonNull(left.getType()).isConvertibleFrom(Objects.requireNonNull(right.getType()))).limit(20L)).forKeyValue((left, right) -> this.myMemState.applyCondition(left.cond(RelationType.NE, (DfaValue)right)));
            }
        }

        private void addConditions(DfaVariableValue var, Value jdiValue) {
            DfType val = this.getConstantValue(jdiValue);
            if (val != DfTypes.TOP) {
                this.myMemState.applyCondition(var.eq(this.myFactory.fromDfType(val)));
            }
            if (jdiValue instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)jdiValue;
                ReferenceType type2 = ref.referenceType();
                ClassLoaderReference typeLoader = type2.classLoader();
                if (!this.isCompatibleClassLoader(typeLoader)) {
                    return;
                }
                PsiType psiType = DebuggerDfaRunner.getType(type2, DebuggerDfaRunner.this.myProject, DebuggerDfaRunner.this.myBody.getResolveScope());
                if (psiType == null) {
                    return;
                }
                TypeConstraint exactType = TypeConstraints.exact(psiType);
                String name2 = type2.name();
                this.myMemState.meetDfType(var, exactType.asDfType().meet(DfTypes.NOT_NULL_OBJECT));
                if (jdiValue instanceof ArrayReference) {
                    DfaValue dfaLength = SpecialField.ARRAY_LENGTH.createValue(this.myFactory, var);
                    int jdiLength = ((ArrayReference)jdiValue).length();
                    this.myMemState.applyCondition(dfaLength.eq(this.myFactory.getInt(jdiLength)));
                } else if (TypeConversionUtil.isPrimitiveWrapper((String)name2)) {
                    this.setSpecialField(var, ref, type2, "value", SpecialField.UNBOX);
                } else if (COLLECTIONS_WITH_SIZE_FIELD.contains(name2)) {
                    this.setSpecialField(var, ref, type2, "size", SpecialField.COLLECTION_SIZE);
                } else if (name2.startsWith("java.util.Collections$Empty")) {
                    this.myMemState.applyCondition(SpecialField.COLLECTION_SIZE.createValue(this.myFactory, var).eq(this.myFactory.getInt(0)));
                } else if (name2.startsWith("java.util.Collections$Singleton")) {
                    this.myMemState.applyCondition(SpecialField.COLLECTION_SIZE.createValue(this.myFactory, var).eq(this.myFactory.getInt(1)));
                } else if ("java.util.Optional".equals(name2) && !(var.getDescriptor() instanceof SpecialField)) {
                    this.setSpecialField(var, ref, type2, "value", SpecialField.OPTIONAL_VALUE);
                }
            }
        }

        private boolean isCompatibleClassLoader(ClassLoaderReference loader) {
            if (loader == null || loader.equals(this.myContextLoader)) {
                return true;
            }
            return this.getParentLoaders().contains(loader);
        }

        @NotNull
        private List<ClassLoaderReference> getParentLoaders() {
            if (this.myParentLoaders == null) {
                List loaders = Collections.emptyList();
                if (this.myContextLoader != null) {
                    Field parent;
                    ClassType classLoaderClass;
                    for (classLoaderClass = (ClassType)this.myContextLoader.referenceType(); classLoaderClass != null && !"java.lang.ClassLoader".equals(classLoaderClass.name()); classLoaderClass = classLoaderClass.superclass()) {
                    }
                    if (classLoaderClass != null && (parent = classLoaderClass.fieldByName("parent")) != null) {
                        loaders = StreamEx.iterate((Object)this.myContextLoader, Objects::nonNull, loader -> (ClassLoaderReference)ObjectUtils.tryCast((Object)loader.getValue(parent), ClassLoaderReference.class)).toList();
                    }
                }
                this.myParentLoaders = loaders;
            }
            List<ClassLoaderReference> list = this.myParentLoaders;
            if (list == null) {
                StateBuilder.$$$reportNull$$$0(6);
            }
            return list;
        }

        private void setSpecialField(DfaVariableValue dfaQualifier, ObjectReference jdiQualifier, ReferenceType type2, String fieldName, SpecialField specialField) {
            Field value2 = type2.fieldByName(fieldName);
            if (value2 != null) {
                DfaVariableValue dfaUnboxed = (DfaVariableValue)ObjectUtils.tryCast((Object)specialField.createValue(this.myFactory, dfaQualifier), DfaVariableValue.class);
                Value jdiUnboxed = jdiQualifier.getValue(value2);
                if (jdiUnboxed != null && dfaUnboxed != null) {
                    this.addConditions(dfaUnboxed, jdiUnboxed);
                }
            }
        }

        @NotNull
        private DfType getConstantValue(Value jdiValue) {
            if (jdiValue == NullConst) {
                DfNullConstantType dfNullConstantType = DfTypes.NULL;
                if (dfNullConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(7);
                }
                return dfNullConstantType;
            }
            if (jdiValue instanceof BooleanValue) {
                DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue(((BooleanValue)jdiValue).value());
                if (dfBooleanConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(8);
                }
                return dfBooleanConstantType;
            }
            if (jdiValue instanceof LongValue) {
                DfLongConstantType dfLongConstantType = DfTypes.longValue(((LongValue)jdiValue).longValue());
                if (dfLongConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(9);
                }
                return dfLongConstantType;
            }
            if (jdiValue instanceof ShortValue || jdiValue instanceof CharValue || jdiValue instanceof ByteValue || jdiValue instanceof IntegerValue) {
                DfIntConstantType dfIntConstantType = DfTypes.intValue(((PrimitiveValue)jdiValue).intValue());
                if (dfIntConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(10);
                }
                return dfIntConstantType;
            }
            if (jdiValue instanceof FloatValue) {
                DfFloatConstantType dfFloatConstantType = DfTypes.floatValue(((FloatValue)jdiValue).floatValue());
                if (dfFloatConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(11);
                }
                return dfFloatConstantType;
            }
            if (jdiValue instanceof DoubleValue) {
                DfDoubleConstantType dfDoubleConstantType = DfTypes.doubleValue(((DoubleValue)jdiValue).doubleValue());
                if (dfDoubleConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(12);
                }
                return dfDoubleConstantType;
            }
            if (jdiValue instanceof StringReference) {
                PsiClassType stringType = this.myPsiFactory.createTypeByFQClassName("java.lang.String", DebuggerDfaRunner.this.myBody.getResolveScope());
                DfConstantType<?> dfConstantType = DfTypes.constant(((StringReference)jdiValue).value(), (PsiType)stringType);
                if (dfConstantType == null) {
                    StateBuilder.$$$reportNull$$$0(13);
                }
                return dfConstantType;
            }
            if (jdiValue instanceof ObjectReference) {
                PsiField enumConst;
                PsiClass enumClass;
                PsiType psiType;
                ReferenceType type2 = ((ObjectReference)jdiValue).referenceType();
                String enumConstantName = DebuggerDfaRunner.getEnumConstantName((ObjectReference)jdiValue);
                if (enumConstantName != null && (psiType = DebuggerDfaRunner.getType(type2, DebuggerDfaRunner.this.myProject, DebuggerDfaRunner.this.myBody.getResolveScope())) instanceof PsiClassType && (enumClass = ((PsiClassType)psiType).resolve()) != null && enumClass.isEnum() && (enumConst = enumClass.findFieldByName(enumConstantName, false)) instanceof PsiEnumConstant) {
                    DfConstantType<?> dfConstantType = DfTypes.constant(enumConst, psiType);
                    if (dfConstantType == null) {
                        StateBuilder.$$$reportNull$$$0(14);
                    }
                    return dfConstantType;
                }
            }
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                StateBuilder.$$$reportNull$$$0(15);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proxy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memState";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdiValue";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$StateBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$StateBuilder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentLoaders";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstantValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveJdi";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findJdiValue";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

