/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeFragmentFactory
extends CodeFragmentFactory {
    public static final Key<String> KEY = Key.create((String)"DefaultCodeFragmentFactory.KEY");

    public static DefaultCodeFragmentFactory getInstance() {
        return SingletonHolder.ourInstance;
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return this.createCodeFragment(item, context, project);
    }

    public JavaCodeFragment createCodeFragment(TextWithImports item, PsiElement context, Project project) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        String text2 = item.getText();
        JavaCodeFragment fragment = null;
        if (CodeFragmentKind.EXPRESSION == item.getKind()) {
            try {
                String expressionText = StringUtil.trimTrailing((String)text2, (char)';');
                if (!expressionText.isEmpty()) {
                    JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(expressionText, context);
                }
                fragment = factory.createExpressionCodeFragment(expressionText, context, null, true);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (fragment == null) {
            fragment = factory.createCodeBlockCodeFragment(text2, context, true);
        }
        if (item.getImports().length() > 0) {
            fragment.addImportsFromString(item.getImports());
        }
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        fragment.putUserData(KEY, (Object)"DebuggerComboBoxEditor.IS_DEBUGGER_EDITOR");
        fragment.putCopyableUserData(JavaCompletionUtil.DYNAMIC_TYPE_EVALUATOR, (expression2, parameters2) -> {
            if (!RuntimeTypeEvaluator.isSubtypeable(expression2)) {
                return null;
            }
            if (parameters2.getInvocationCount() <= 1 && JavaCompletionUtil.mayHaveSideEffects((PsiElement)expression2)) {
                CompletionService.getCompletionService().setAdvertisementText(JavaDebuggerBundle.message((String)"invoke.completion.once.more", (Object[])new Object[0]));
                return null;
            }
            DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
            DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
            if (debuggerSession != null && debuggerContext.getSuspendContext() != null) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                final AtomicReference nameRef = new AtomicReference();
                RuntimeTypeEvaluator worker = new RuntimeTypeEvaluator(null, (PsiElement)expression2, debuggerContext, ProgressManager.getInstance().getProgressIndicator()){

                    @Override
                    protected void typeCalculationFinished(@Nullable PsiType type2) {
                        nameRef.set(type2);
                        semaphore.up();
                    }
                };
                debuggerSession.getProcess().getManagerThread().invoke(worker);
                for (int i = 0; i < 50; ++i) {
                    ProgressManager.checkCanceled();
                    if (semaphore.waitFor(20L)) break;
                }
                return (PsiType)nameRef.get();
            }
            return null;
        });
        return fragment;
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return true;
    }

    @NotNull
    public LanguageFileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            DefaultCodeFragmentFactory.$$$reportNull$$$0(0);
        }
        return javaFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    public static boolean isDebuggerFile(PsiFile file) {
        return KEY.isIn((UserDataHolder)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory", "getFileType"));
    }

    private static final class SingletonHolder {
        public static final DefaultCodeFragmentFactory ourInstance = new DefaultCodeFragmentFactory();

        private SingletonHolder() {
        }
    }
}

