/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.util.ThreeState;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AssertStatementEvaluator
implements Evaluator {
    @NotNull
    private final Evaluator myEvaluator;

    public AssertStatementEvaluator(@NotNull Evaluator evaluator) {
        if (evaluator == null) {
            AssertStatementEvaluator.$$$reportNull$$$0(0);
        }
        this.myEvaluator = evaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value res;
        ClassObjectReference classObjectReference;
        Method method;
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        ThreeState status = DebuggerUtilsEx.getEffectiveAssertionStatus(frameProxy.location());
        if (status == ThreeState.UNSURE && (method = DebuggerUtils.findMethod((ReferenceType)(classObjectReference = frameProxy.location().declaringType().classObject()).referenceType(), (String)"desiredAssertionStatus", (String)"()Z")) != null && (res = context.getDebugProcess().invokeMethod((EvaluationContext)context, classObjectReference, method, Collections.emptyList())) instanceof BooleanValue) {
            status = ThreeState.fromBoolean((boolean)((BooleanValue)res).value());
        }
        if (status == ThreeState.NO) {
            return context.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        }
        return this.myEvaluator.evaluate(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/evaluation/expression/AssertStatementEvaluator", "<init>"));
    }
}

