/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class AssignmentEvaluator
implements Evaluator {
    private final Evaluator myLeftEvaluator;
    private final Evaluator myRightEvaluator;

    public AssignmentEvaluator(@NotNull Evaluator leftEvaluator, @NotNull Evaluator rightEvaluator) {
        if (leftEvaluator == null) {
            AssignmentEvaluator.$$$reportNull$$$0(0);
        }
        if (rightEvaluator == null) {
            AssignmentEvaluator.$$$reportNull$$$0(1);
        }
        this.myLeftEvaluator = leftEvaluator;
        this.myRightEvaluator = DisableGC.create(rightEvaluator);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        this.myLeftEvaluator.evaluate(context);
        Modifier modifier = this.myLeftEvaluator.getModifier();
        Object right = this.myRightEvaluator.evaluate(context);
        if (right != null && !(right instanceof Value)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.not.rvalue", (Object[])new Object[0]));
        }
        AssignmentEvaluator.assign(modifier, right, context);
        return right;
    }

    static void assign(Modifier modifier, Object right, EvaluationContextImpl context) throws EvaluateException {
        if (modifier == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.not.lvalue", (Object[])new Object[0]));
        }
        try {
            modifier.setValue((Value)right);
        }
        catch (ClassNotLoadedException e) {
            if (!context.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            try {
                context.getDebugProcess().loadClass(context, e.className(), context.getClassLoader());
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
        }
        catch (InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Override
    public Modifier getModifier() {
        return this.myLeftEvaluator.getModifier();
    }

    public String toString() {
        return this.myLeftEvaluator + " = " + this.myRightEvaluator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leftEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rightEvaluator";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/AssignmentEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

